/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.editors;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.widgets.Composite;

public class StringIdentifierEditor
extends StringFieldEditor {
    private static final String ERROR_MESSAGE = "Given input is not valid!";
    private String matchingPattern = "";

    public StringIdentifierEditor(String name, String labelText, int width, Composite parent, String matchingPattern, boolean isEnabled) {
        super(name, labelText, width, 0, parent);
        this.setEmptyStringAllowed(false);
        this.setEnabled(isEnabled, parent);
        this.setErrorMessage(ERROR_MESSAGE);
        this.matchingPattern = matchingPattern;
    }

    protected boolean doCheckState() {
        String textField = this.getStringValue();
        if (textField.equals(this.getPreferenceStore().getString(this.getPreferenceName()))) {
            return true;
        }
        Matcher matchedString = Pattern.compile(this.matchingPattern).matcher(textField);
        return matchedString.find();
    }
}

