/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.typehierarchy;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.typehierarchy.HistoryAction;
import org.eclipse.jdt.internal.ui.typehierarchy.HistoryListAction;
import org.eclipse.jdt.internal.ui.typehierarchy.TypeHierarchyMessages;
import org.eclipse.jdt.internal.ui.typehierarchy.TypeHierarchyViewPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryDropDownAction
extends Action
implements IMenuCreator {
    public static final int RESULTS_IN_DROP_DOWN = 10;
    private TypeHierarchyViewPart fHierarchyView;
    private Menu fMenu;

    public HistoryDropDownAction(TypeHierarchyViewPart view) {
        this.fHierarchyView = view;
        this.fMenu = null;
        this.setToolTipText(TypeHierarchyMessages.HistoryDropDownAction_tooltip);
        JavaPluginImages.setLocalImageDescriptors((IAction)this, "history_list.png");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.typehierarchy_history_action");
        this.setMenuCreator(this);
    }

    public void dispose() {
        if (this.fMenu != null) {
            this.fMenu.dispose();
            this.fMenu = null;
        }
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public Menu getMenu(Control parent) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(parent);
        List<IJavaElement[]> elements = this.fHierarchyView.getHistoryEntries();
        this.addEntries(this.fMenu, elements);
        new MenuItem(this.fMenu, 2);
        this.addActionToMenu(this.fMenu, new HistoryListAction(this.fHierarchyView));
        this.addActionToMenu(this.fMenu, new ClearHistoryAction(this.fHierarchyView));
        return this.fMenu;
    }

    private boolean addEntries(Menu menu, List<IJavaElement[]> elements) {
        boolean checked = false;
        int count = 0;
        int min = Math.min(elements.size(), 10);
        Iterator<IJavaElement[]> iterator = elements.iterator();
        while (count < min) {
            IJavaElement[] entries = iterator.next();
            if (entries != null && entries.length != 0) {
                HistoryAction action = new HistoryAction(this.fHierarchyView, entries);
                action.setChecked(entries.equals(this.fHierarchyView.getInputElements()));
                checked = checked || action.isChecked();
                this.addActionToMenu(menu, action);
            }
            ++count;
        }
        return checked;
    }

    protected void addActionToMenu(Menu parent, Action action) {
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    public void run() {
        new HistoryListAction(this.fHierarchyView).run();
    }

    public static class ClearHistoryAction
    extends Action {
        private TypeHierarchyViewPart fView;

        public ClearHistoryAction(TypeHierarchyViewPart view) {
            super(TypeHierarchyMessages.HistoryDropDownAction_clearhistory_label);
            this.fView = view;
        }

        public void run() {
            this.fView.setHistoryEntries(new IJavaElement[0]);
            this.fView.setInputElement(null);
        }
    }
}

