/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.util;

import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.corext.util.SearchUtils;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.util.StringMatcher;

public class PatternMatcher {
    private String fPattern;
    private int fMatchKind;
    private StringMatcher fStringMatcher;
    private static final char END_SYMBOL = '<';
    private static final char ANY_STRING = '*';
    private static final char BLANK = ' ';

    public PatternMatcher(String pattern) {
        this(pattern, 387);
    }

    private PatternMatcher(String pattern, int allowedModes) {
        this.initializePatternAndMatchKind(pattern);
        this.fMatchKind &= allowedModes;
        if (this.fMatchKind == 2) {
            this.fStringMatcher = new StringMatcher(this.fPattern, true, false);
        }
    }

    public String getPattern() {
        return this.fPattern;
    }

    public int getMatchKind() {
        return this.fMatchKind;
    }

    public boolean matches(String text) {
        switch (this.fMatchKind) {
            case 2: {
                return this.fStringMatcher.match(text);
            }
            case 0: {
                return this.fPattern.equalsIgnoreCase(text);
            }
            case 256: {
                return SearchPattern.camelCaseMatch((String)this.fPattern, (String)text, (boolean)true);
            }
            case 128: {
                if (SearchPattern.camelCaseMatch((String)this.fPattern, (String)text)) {
                    return true;
                }
                return Strings.startsWithIgnoreCase(text, this.fPattern);
            }
        }
        return Strings.startsWithIgnoreCase(text, this.fPattern);
    }

    private void initializePatternAndMatchKind(String pattern) {
        int length = pattern.length();
        if (length == 0) {
            this.fMatchKind = 0;
            this.fPattern = pattern;
            return;
        }
        char last = pattern.charAt(length - 1);
        if (pattern.indexOf(42) != -1 || pattern.indexOf(63) != -1) {
            this.fMatchKind = 2;
            switch (last) {
                case ' ': 
                case '<': {
                    this.fPattern = pattern.substring(0, length - 1);
                    break;
                }
                case '*': {
                    this.fPattern = pattern;
                    break;
                }
                default: {
                    this.fPattern = String.valueOf(pattern) + '*';
                }
            }
            return;
        }
        if (last == '<' || last == ' ') {
            this.fPattern = pattern.substring(0, length - 1);
            this.fMatchKind = SearchPattern.validateMatchRule((String)this.fPattern, (int)256) == 256 ? 256 : 0;
            return;
        }
        if (SearchUtils.isCamelCasePattern(pattern)) {
            this.fMatchKind = 128;
            this.fPattern = pattern;
            return;
        }
        this.fMatchKind = 1;
        this.fPattern = pattern;
    }
}

