/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.numeric.equations;

import org.eclipse.chemclipse.numeric.equations.IEquation;

public class PolynomicalEquation4thDegree
implements IEquation {
    private static final long serialVersionUID = -6786649038436947751L;
    private double a;
    private double b;
    private double c;
    private double d;

    public PolynomicalEquation4thDegree(double a, double b, double c, double d) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
    }

    @Override
    public double calculateY(double x) {
        double ax = this.a * Math.pow(x, 4.0);
        double bx = this.b * Math.pow(x, 3.0);
        double cx = this.c * Math.pow(x, 2.0);
        double dx = this.d;
        double result = ax + bx + cx + dx;
        return result;
    }

    @Override
    public double calculateX(double y) {
        return 0.0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append("[");
        builder.append("f(x)=");
        builder.append(String.valueOf(this.a) + "x^9");
        builder.append(" + ");
        builder.append(String.valueOf(this.b) + "x^8");
        builder.append(" + ");
        builder.append(String.valueOf(this.c) + "x^7");
        builder.append(" + ");
        builder.append(String.valueOf(this.d) + "x^6");
        builder.append("]");
        return builder.toString();
    }
}

