/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.converter.core;

import java.io.File;
import org.eclipse.chemclipse.converter.core.IImportConverter;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;

public abstract class AbstractImportConverter
implements IImportConverter {
    private static final String DESCRIPTION = "Import Converter";

    @Override
    public IProcessingInfo validate(File file) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        if (file == null) {
            processingInfo.addErrorMessage(DESCRIPTION, "The given file couldn't be found.");
        } else if (!file.exists()) {
            processingInfo.addErrorMessage(DESCRIPTION, "The given file doesn't exists: " + file.getAbsolutePath());
        } else {
            if (file.isFile() && file.length() == 0L) {
                processingInfo.addErrorMessage(DESCRIPTION, "The given file is empty: " + file.getAbsolutePath());
            }
            if (!file.canRead()) {
                processingInfo.addErrorMessage(DESCRIPTION, "The given file is not readable: " + file.getAbsolutePath());
            }
        }
        return processingInfo;
    }
}

