/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.supplier.coda.calculator;

import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.model.exceptions.NoExtractedIonSignalStoredException;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignal;
import org.eclipse.chemclipse.msd.model.xic.IExtractedIonSignals;
import org.eclipse.chemclipse.numeric.statistics.Calculations;
import org.eclipse.chemclipse.numeric.statistics.WindowSize;

public class CodaCalculator {
    private static final Logger logger = Logger.getLogger(CodaCalculator.class);

    private CodaCalculator() {
    }

    public static float getMCQValue(IExtractedIonSignals extractedIonSignals, WindowSize windowSize, int ion) {
        int startScan = extractedIonSignals.getStartScan();
        int stopScan = extractedIonSignals.getStopScan();
        int width = stopScan - startScan + 1;
        double[] euclidianLengthValues = new double[width];
        double[] standardizedSmoothedValues = new double[width];
        int scan = startScan;
        int counter = 0;
        while (scan <= stopScan) {
            float signal;
            try {
                IExtractedIonSignal extractedIonSignal = extractedIonSignals.getExtractedIonSignal(scan);
                signal = extractedIonSignal.getAbundance(ion);
            }
            catch (NoExtractedIonSignalStoredException e) {
                logger.warn((Object)e);
                signal = 0.0f;
            }
            euclidianLengthValues[counter] = signal;
            standardizedSmoothedValues[counter] = signal;
            ++scan;
            ++counter;
        }
        Calculations.scaleToEuclidianLength((double[])euclidianLengthValues);
        Calculations.smooth((double[])standardizedSmoothedValues, (WindowSize)windowSize);
        Calculations.scaleToStandardizedLength((double[])standardizedSmoothedValues);
        return CodaCalculator.calculateMCQValue(euclidianLengthValues, standardizedSmoothedValues, windowSize);
    }

    private static float calculateMCQValue(double[] euclidianLengthValues, double[] standardizedSmoothedValues, WindowSize windowSize) {
        assert (windowSize != null) : "The window size must not be null.";
        float mcq = 0.0f;
        int lastScan = Calculations.getWindowReducedLength((double[])euclidianLengthValues, (int)windowSize.getSize());
        int scans = euclidianLengthValues.length;
        double sumSignals = 0.0;
        int i = 0;
        while (i < lastScan) {
            sumSignals += euclidianLengthValues[i] * standardizedSmoothedValues[i];
            ++i;
        }
        mcq = (float)(1.0 / Math.sqrt(scans - windowSize.getSize()) * sumSignals);
        if (mcq < 0.0f || mcq > 1.0f) {
            logger.warn((Object)"There is something going wrong with the coda algorithm. The mcq value must be in between 0.0f and 1.0f.");
        }
        return mcq;
    }
}

