/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.alignment.converter.retentionindices;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.chemclipse.chromatogram.alignment.converter.exceptions.FileIsEmptyException;
import org.eclipse.chemclipse.chromatogram.alignment.converter.exceptions.FileIsNotReadableException;
import org.eclipse.chemclipse.chromatogram.alignment.converter.retentionindices.IRetentionIndicesImportConverter;

public abstract class AbstractRetentionIndicesImportConverter
implements IRetentionIndicesImportConverter {
    @Override
    public void validate(File retentionIndices) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        if (!retentionIndices.exists()) {
            throw new FileNotFoundException("The file " + retentionIndices.getAbsoluteFile() + " does not exist.");
        }
        if (retentionIndices.length() == 0L) {
            throw new FileIsEmptyException("The file " + retentionIndices.getAbsoluteFile() + " is empty.");
        }
        if (!retentionIndices.canRead()) {
            throw new FileIsNotReadableException("Can't read the chromatogram file: " + retentionIndices.getAbsoluteFile());
        }
    }
}

