/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.swt;

import java.util.List;
import org.eclipse.chemclipse.support.ui.provider.ListContentProvider;
import org.eclipse.chemclipse.support.ui.swt.EnhancedTableViewer;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider.OverlaySettingsCheckBoxEditingSupport;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider.OverlaySettingsLabelProvider;
import org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider.OverlaySettingsTableSorter;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.widgets.Composite;

public class OverlaySettingsTableViewer
extends EnhancedTableViewer {
    public static final String OVERLAY_SELECTED = "Overlay";
    public static final String LOCK_OFFSET = "Lock Offset";
    private String[] TITLES = new String[]{"Chromatogram", "Overlay", "Lock Offset"};
    private int[] BOUNDS = new int[]{250, 100, 100};

    public OverlaySettingsTableViewer(Composite parent, int style) {
        super(parent, style);
        this.createColumns();
    }

    private void createColumns() {
        this.setColumns(this.TITLES, this.BOUNDS);
        this.setLabelProvider((IBaseLabelProvider)new OverlaySettingsLabelProvider());
        this.setContentProvider((IContentProvider)new ListContentProvider());
        this.setSorter(new OverlaySettingsTableSorter());
        this.setEditingSupport();
    }

    private void setEditingSupport() {
        TableViewer tableViewer = this.getTableViewer();
        List tableViewerColumns = this.getTableViewerColumns();
        int i = 0;
        while (i < tableViewerColumns.size()) {
            TableViewerColumn tableViewerColumn = (TableViewerColumn)tableViewerColumns.get(i);
            String label = tableViewerColumn.getColumn().getText();
            if (label.equals(OVERLAY_SELECTED)) {
                tableViewerColumn.setEditingSupport((EditingSupport)new OverlaySettingsCheckBoxEditingSupport(tableViewer, OVERLAY_SELECTED));
            } else if (label.equals(LOCK_OFFSET)) {
                tableViewerColumn.setEditingSupport((EditingSupport)new OverlaySettingsCheckBoxEditingSupport(tableViewer, LOCK_OFFSET));
            }
            ++i;
        }
    }
}

