/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.ui.swt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.support.messages.SupportMessages;
import org.eclipse.chemclipse.support.settings.OperatingSystemUtils;
import org.eclipse.chemclipse.support.ui.swt.EnhancedViewerSorter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class EnhancedTableViewer
extends Composite {
    private static final Logger logger = Logger.getLogger(EnhancedTableViewer.class);
    private static final String POPUP_MENU_ID = "#PopUpMenu";
    private static final String POPUP_MENU_POSTFIX = "PopUpMenu";
    private TableViewer tableViewer;
    private List<TableViewerColumn> tableViewerColumns;
    private EnhancedViewerSorter sorter;
    private Clipboard clipboard;

    public EnhancedTableViewer(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.createControl();
    }

    public void createColumns(Object object) {
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public void setContentProvider(IContentProvider provider) {
        this.tableViewer.setContentProvider(provider);
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        this.tableViewer.setLabelProvider(labelProvider);
    }

    public void setSorter(EnhancedViewerSorter sorter) {
        this.sorter = sorter;
        this.tableViewer.setSorter((ViewerSorter)sorter);
    }

    public void setInput(Object input) {
        this.tableViewer.setInput(input);
    }

    public void setColumns(String[][] titlesAndBounds) {
        String[] titles = new String[titlesAndBounds.length];
        int[] bounds = new int[titlesAndBounds.length];
        int i = 0;
        while (i < titlesAndBounds.length) {
            try {
                String[] titleAndBound = titlesAndBounds[i];
                titles[i] = titleAndBound[0];
                bounds[i] = Integer.parseInt(titleAndBound[1]);
            }
            catch (NumberFormatException e) {
                logger.warn((Object)e);
            }
            ++i;
        }
        this.createColumns(titles, bounds);
    }

    public void setColumns(String[] titles, int[] bounds) {
        this.createColumns(titles, bounds);
    }

    public List<TableViewerColumn> getTableViewerColumns() {
        return this.tableViewerColumns;
    }

    private void createControl() {
        this.tableViewerColumns = new ArrayList<TableViewerColumn>();
        this.clipboard = new Clipboard(Display.getDefault());
        this.tableViewer = new TableViewer((Composite)this, 66306);
        Table table = this.tableViewer.getTable();
        table.setLayout((Layout)new FillLayout());
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 99 && e.stateMask == 262144) {
                    EnhancedTableViewer.this.copyToClipboard();
                }
            }
        });
        this.initContextMenu(this.tableViewer);
    }

    private void copyToClipboard() {
        String DELIMITER = "\t";
        String END_OF_LINE = OperatingSystemUtils.getLineDelimiter();
        StringBuilder builder = new StringBuilder();
        Table table = this.tableViewer.getTable();
        TableColumn[] tableColumns = table.getColumns();
        int size = tableColumns.length;
        Object[] objectArray = tableColumns;
        int n = tableColumns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn tableColumn = objectArray[n2];
            builder.append(tableColumn.getText());
            builder.append(DELIMITER);
            ++n2;
        }
        builder.append(END_OF_LINE);
        int[] nArray = table.getSelectionIndices();
        objectArray = nArray;
        n = nArray.length;
        n2 = 0;
        while (n2 < n) {
            TableColumn index = objectArray[n2];
            TableItem selection = table.getItem((int)index);
            int columnIndex = 0;
            while (columnIndex < size) {
                builder.append(selection.getText(columnIndex));
                builder.append(DELIMITER);
                ++columnIndex;
            }
            builder.append(END_OF_LINE);
            ++n2;
        }
        if (builder.length() == 0) {
            builder.append(SupportMessages.INSTANCE().getMessage("labelCopyLinesInfo", new String[0]));
            builder.append(END_OF_LINE);
        }
        TextTransfer textTransfer = TextTransfer.getInstance();
        Object[] data = new Object[]{builder.toString()};
        Transfer[] dataTypes = new Transfer[]{textTransfer};
        this.clipboard.setContents(data, dataTypes);
    }

    private void initContextMenu(TableViewer tableViewer) {
        MenuManager menuManager = new MenuManager(POPUP_MENU_ID, String.valueOf(((Object)((Object)this)).getClass().getName()) + POPUP_MENU_POSTFIX);
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Action action = new Action(){

                    public void run() {
                        EnhancedTableViewer.this.copyToClipboard();
                    }
                };
                action.setText(SupportMessages.INSTANCE().getMessage("labelCopySelectionClipboard", new String[0]));
                manager.add((IAction)action);
            }
        });
        Menu menu = menuManager.createContextMenu((Control)tableViewer.getTable());
        tableViewer.getTable().setMenu(menu);
    }

    private void createColumns(String[] titles, int[] bounds) {
        this.clearTableViewerColumns(this.tableViewer);
        int i = 0;
        while (i < titles.length) {
            final int index = i;
            final TableColumn tableColumn = this.getTableColumn(titles[i], bounds[i], this.tableViewer);
            tableColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EnhancedTableViewer.this.handleSortSelectionListener(EnhancedTableViewer.this.tableViewer, tableColumn, index);
                }
            });
            ++i;
        }
        this.setTableProperties(this.tableViewer);
    }

    private void handleSortSelectionListener(TableViewer tableViewer, TableColumn tableColumn, int index) {
        if (this.sorter != null) {
            Table table = tableViewer.getTable();
            this.sorter.setColumn(index);
            int direction = table.getSortDirection();
            direction = table.getSortColumn() == tableColumn ? (direction == 128 ? 1024 : 128) : 128;
            table.setSortDirection(direction);
            table.setSortColumn(tableColumn);
            tableViewer.refresh();
        }
    }

    private TableColumn getTableColumn(String title, int bound, TableViewer tableViewer) {
        TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, 0);
        this.tableViewerColumns.add(tableViewerColumn);
        TableColumn tableColumn = tableViewerColumn.getColumn();
        tableColumn.setText(title);
        tableColumn.setWidth(bound);
        tableColumn.setResizable(true);
        tableColumn.setMoveable(true);
        return tableColumn;
    }

    private void setTableProperties(TableViewer tableViewer) {
        Table table = tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
    }

    private void clearTableViewerColumns(TableViewer tableViewer) {
        Table table = tableViewer.getTable();
        table.setRedraw(false);
        this.tableViewerColumns.clear();
        table.clearAll();
        while (table.getColumnCount() > 0) {
            table.getColumns()[0].dispose();
        }
        table.setRedraw(true);
        tableViewer.refresh();
    }
}

