/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.components.massspectrum;

import java.util.HashSet;
import java.util.List;
import org.eclipse.chemclipse.msd.swt.ui.internal.editingsupport.LibraryTextEditingSupport;
import org.eclipse.chemclipse.msd.swt.ui.internal.provider.MassSpectrumListContentProvider;
import org.eclipse.chemclipse.msd.swt.ui.internal.provider.MassSpectrumListFilter;
import org.eclipse.chemclipse.msd.swt.ui.internal.provider.MassSpectrumListLabelProvider;
import org.eclipse.chemclipse.msd.swt.ui.internal.provider.MassSpectrumListTableComparator;
import org.eclipse.chemclipse.support.ui.swt.ExtendedTableViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;

public class MassSpectrumListUI
extends ExtendedTableViewer {
    private String[] titles = new String[]{"Name", "Retention Time", "Retention Index", "Base Peak", "Base Peak Abundance", "Number of Ions", "CAS", "MW", "Formula", "SMILES", "InChI", "Reference Identifier", "Comments"};
    private int[] bounds = new int[]{300, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100};
    private MassSpectrumListFilter massSpectrumListFilter;

    public MassSpectrumListUI(Composite parent) {
        super(parent);
        this.createColumns();
    }

    public MassSpectrumListUI(Composite parent, int style) {
        super(parent, style);
        this.createColumns();
    }

    public void setSearchText(String searchText, boolean caseSensitive) {
        this.massSpectrumListFilter.setSearchText(searchText, caseSensitive);
        this.refresh();
    }

    private void createColumns() {
        this.createColumns(this.titles, this.bounds);
        this.setLabelProvider((IBaseLabelProvider)new MassSpectrumListLabelProvider());
        this.setContentProvider((IContentProvider)new MassSpectrumListContentProvider());
        this.setComparator((ViewerComparator)new MassSpectrumListTableComparator());
        this.massSpectrumListFilter = new MassSpectrumListFilter();
        this.setFilters(new ViewerFilter[]{this.massSpectrumListFilter});
        this.setEditingSupport();
    }

    private void setEditingSupport() {
        HashSet<String> excludeFromEditing = new HashSet<String>();
        excludeFromEditing.add("Base Peak");
        excludeFromEditing.add("Base Peak Abundance");
        excludeFromEditing.add("Number of Ions");
        List tableViewerColumns = this.getTableViewerColumns();
        for (TableViewerColumn tableViewerColumn : tableViewerColumns) {
            String columnLabel = tableViewerColumn.getColumn().getText();
            if (excludeFromEditing.contains(columnLabel)) continue;
            tableViewerColumn.setEditingSupport((EditingSupport)new LibraryTextEditingSupport((TableViewer)this, columnLabel));
        }
    }
}

