/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.baseline.detector.supplier.smoothed.ui.internal.modifier;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.chemclipse.chromatogram.xxd.baseline.detector.core.BaselineDetector;
import org.eclipse.chemclipse.chromatogram.xxd.baseline.detector.processing.IBaselineDetectorProcessingInfo;
import org.eclipse.chemclipse.model.processor.AbstractChromatogramProcessor;
import org.eclipse.chemclipse.model.processor.IChromatogramProcessor;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.ui.support.ProcessingInfoViewSupport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;

public class BaselineDetectorRunnable
extends AbstractChromatogramProcessor
implements IRunnableWithProgress {
    private static final String DESCRIPTION = "Baseline Detector Smoothed";
    private static final String BASELINE_DETECTOR_ID = "org.eclipse.chemclipse.chromatogram.msd.baseline.detector.supplier.smoothed";

    public BaselineDetectorRunnable(IChromatogramSelection chromatogramSelection) {
        super(chromatogramSelection);
    }

    public void execute(IProgressMonitor monitor) {
        if (this.getChromatogramSelection() != null) {
            final IChromatogramSelection chromatogramSelection = this.getChromatogramSelection();
            IBaselineDetectorProcessingInfo processingInfo = BaselineDetector.setBaseline((IChromatogramSelection)chromatogramSelection, (String)BASELINE_DETECTOR_ID, (IProgressMonitor)monitor);
            ProcessingInfoViewSupport.updateProcessingInfo((IProcessingInfo)processingInfo, (boolean)false);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    chromatogramSelection.reset(true);
                }
            });
        }
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            monitor.beginTask(DESCRIPTION, -1);
            this.getChromatogramSelection().getChromatogram().doOperation((IChromatogramProcessor)this, monitor);
        }
        finally {
            monitor.done();
        }
    }
}

