/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.amdis.converter.msp;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotWriteableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IPeaks;
import org.eclipse.chemclipse.msd.converter.peak.AbstractPeakExportConverter;
import org.eclipse.chemclipse.msd.converter.processing.peak.IPeakExportConverterProcessingInfo;
import org.eclipse.chemclipse.msd.converter.processing.peak.PeakExportConverterProcessingInfo;
import org.eclipse.chemclipse.msd.converter.supplier.amdis.internal.converter.SpecificationValidatorMSP;
import org.eclipse.chemclipse.msd.converter.supplier.amdis.io.AmdisMSPWriter;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.implementation.MassSpectra;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;
import org.eclipse.core.runtime.IProgressMonitor;

public class MSPPeakExportConverter
extends AbstractPeakExportConverter {
    private static final Logger logger = Logger.getLogger(MSPPeakExportConverter.class);
    private static final String DESCRIPTION = "AMDIS MSP Peak Export";

    public IPeakExportConverterProcessingInfo convert(File file, IPeakMSD peak, boolean append, IProgressMonitor monitor) {
        PeakExportConverterProcessingInfo processingInfo = new PeakExportConverterProcessingInfo();
        IProcessingInfo processingInfoValidate = this.validate(file = SpecificationValidatorMSP.validateSpecification(file), peak);
        if (processingInfoValidate.hasErrorMessages()) {
            processingInfo.addMessages(processingInfoValidate);
        } else {
            try {
                AmdisMSPWriter massSpectraWriter = new AmdisMSPWriter();
                massSpectraWriter.write(file, (IScanMSD)peak.getExtractedMassSpectrum(), append, monitor);
                processingInfo.setFile(file);
            }
            catch (FileNotFoundException e) {
                logger.warn((Object)e);
                processingInfo.addErrorMessage(DESCRIPTION, "The file couldn't be found: " + file.getAbsolutePath());
            }
            catch (FileIsNotWriteableException e) {
                logger.warn((Object)e);
                processingInfo.addErrorMessage(DESCRIPTION, "The file is not writeable: " + file.getAbsolutePath());
            }
            catch (IOException e) {
                logger.warn((Object)e);
                processingInfo.addErrorMessage(DESCRIPTION, "Something has gone completely wrong: " + file.getAbsolutePath());
            }
        }
        return processingInfo;
    }

    public IPeakExportConverterProcessingInfo convert(File file, IPeaks peaks, boolean append, IProgressMonitor monitor) {
        PeakExportConverterProcessingInfo processingInfo = new PeakExportConverterProcessingInfo();
        IProcessingInfo processingInfoValidate = this.validate(file = SpecificationValidatorMSP.validateSpecification(file), peaks);
        if (processingInfoValidate.hasErrorMessages()) {
            processingInfo.addMessages(processingInfoValidate);
        } else {
            try {
                AmdisMSPWriter massSpectraWriter = new AmdisMSPWriter();
                IMassSpectra massSpectra = this.extractMassSpectra(peaks);
                massSpectraWriter.write(file, massSpectra, append, monitor);
                processingInfo.setFile(file);
            }
            catch (FileNotFoundException e) {
                logger.warn((Object)e);
                processingInfo.addErrorMessage(DESCRIPTION, "The file couldn't be found: " + file.getAbsolutePath());
            }
            catch (FileIsNotWriteableException e) {
                logger.warn((Object)e);
                processingInfo.addErrorMessage(DESCRIPTION, "The file is not writeable: " + file.getAbsolutePath());
            }
            catch (IOException e) {
                logger.warn((Object)e);
                processingInfo.addErrorMessage(DESCRIPTION, "Something has gone completely wrong: " + file.getAbsolutePath());
            }
        }
        return processingInfo;
    }

    private IMassSpectra extractMassSpectra(IPeaks peaks) {
        MassSpectra massSpectra = new MassSpectra();
        for (IPeak peak : peaks.getPeaks()) {
            if (!(peak instanceof IPeakMSD)) continue;
            IPeakMSD peakMSD = (IPeakMSD)peak;
            massSpectra.addMassSpectrum((IScanMSD)peakMSD.getExtractedMassSpectrum());
        }
        return massSpectra;
    }

    private IProcessingInfo validate(File file, IPeakMSD peak) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        processingInfo.addMessages(super.validate(file));
        processingInfo.addMessages(super.validate(peak));
        return processingInfo;
    }

    private IProcessingInfo validate(File file, IPeaks peaks) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        processingInfo.addMessages(super.validate(file));
        processingInfo.addMessages(super.validate(peaks));
        return processingInfo;
    }
}

