/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.mapping.IMergeContext;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.core.mapping.provider.SynchronizationContext;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.mapping.MergeAllOperation;
import org.eclipse.team.ui.mapping.SynchronizationOperation;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ModelMergeOperation;

public final class MergeAllOperation
extends SynchronizationOperation {
    private final IMergeContext context;
    private final String jobName;

    public MergeAllOperation(String jobName, ISynchronizePageConfiguration configuration, Object[] elements, IMergeContext context) {
        super(configuration, elements);
        this.jobName = jobName;
        this.context = context;
    }

    public void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        new ModelMergeOperation(this.getPart(), ((SynchronizationContext)this.context).getScopeManager()){

            public boolean isPreviewRequested() {
                return false;
            }

            protected void initializeContext(IProgressMonitor monitor) throws CoreException {
                monitor.beginTask(null, 10);
                monitor.done();
            }

            protected ISynchronizationContext getContext() {
                return MergeAllOperation.this.context;
            }

            protected void executeMerge(IProgressMonitor monitor) throws CoreException {
                monitor.beginTask(null, 100);
                if (!this.hasChangesOfInterest()) {
                    this.handleNoChanges();
                } else if (this.isPreviewRequested()) {
                    this.handlePreviewRequest();
                } else {
                    IStatus status = ModelMergeOperation.validateMerge(this.getMergeContext(), Policy.subMonitorFor(monitor, 10));
                    if (!status.isOK() && !this.promptToContinue(status)) {
                        return;
                    }
                    status = this.performMerge(Policy.subMonitorFor(monitor, 90));
                    if (!status.isOK()) {
                        this.handleMergeFailure(status);
                    }
                }
                monitor.done();
            }

            private IMergeContext getMergeContext() {
                return (IMergeContext)this.getContext();
            }

            private boolean promptToContinue(IStatus status) {
                boolean[] result = new boolean[1];
                Runnable runnable = new Runnable(this, status, result){
                    final /* synthetic */ 1 this$1;
                    private final /* synthetic */ IStatus val$status;
                    private final /* synthetic */ boolean[] val$result;
                    {
                        this.this$1 = var1_1;
                        this.val$status = iStatus;
                        this.val$result = blArray;
                    }

                    public void run() {
                        ErrorDialog dialog = new ErrorDialog(this, 1.access$0(this.this$1), TeamUIMessages.ModelMergeOperation_0, TeamUIMessages.ModelMergeOperation_1, this.val$status, 7){
                            final /* synthetic */ 2 this$2;
                            {
                                super($anonymous0, $anonymous1, $anonymous2, $anonymous3, $anonymous4);
                                this.this$2 = var1_1;
                            }

                            protected void createButtonsForButtonBar(Composite parent) {
                                this.createButton(parent, 2, IDialogConstants.YES_LABEL, false);
                                this.createButton(parent, 3, IDialogConstants.NO_LABEL, true);
                                this.createDetailsButton(parent);
                            }

                            protected void buttonPressed(int id) {
                                if (id == 2) {
                                    super.buttonPressed(0);
                                } else if (id == 3) {
                                    super.buttonPressed(1);
                                }
                                super.buttonPressed(id);
                            }
                        };
                        int code = dialog.open();
                        this.val$result[0] = code == 0;
                    }
                };
                this.getShell().getDisplay().syncExec(runnable);
                return result[0];
            }

            static /* synthetic */ Shell access$0(1 var0) {
                return var0.getShell();
            }
        }.run(monitor);
    }

    protected boolean canRunAsJob() {
        return true;
    }

    protected String getJobName() {
        return this.jobName;
    }
}

