/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree;

import net.sf.saxon.event.LocationCopier;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.AttributeCollectionImpl;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.NamespaceCodeIterator;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.DocumentImpl;
import net.sf.saxon.tree.NodeImpl;
import net.sf.saxon.tree.ParentNodeImpl;

public class ElementImpl
extends ParentNodeImpl {
    private static final AttributeCollectionImpl emptyAtts = new AttributeCollectionImpl(null);
    protected int nameCode;
    protected DocumentImpl root;

    public void setNameCode(int nameCode) {
        this.nameCode = nameCode;
    }

    public void initialise(int nameCode, AttributeCollectionImpl atts, NodeInfo parent, String baseURI, int lineNumber, int sequenceNumber) {
        this.nameCode = nameCode;
        this.parent = (ParentNodeImpl)parent;
        this.sequence = sequenceNumber;
        this.root = (DocumentImpl)parent.getDocumentRoot();
        this.root.setLineNumber(sequenceNumber, lineNumber);
        this.root.setSystemId(sequenceNumber, baseURI);
    }

    public void setSystemId(String uri) {
        this.root.setSystemId(this.sequence, uri);
    }

    public NodeInfo getRoot() {
        return this.root;
    }

    public DocumentInfo getDocumentRoot() {
        return this.root;
    }

    public final String getSystemId() {
        return ((DocumentImpl)this.getDocumentRoot()).getSystemId(this.sequence);
    }

    public String getBaseURI() {
        return Navigator.getBaseURI(this);
    }

    public void setLineNumber(int line) {
        ((DocumentImpl)this.getDocumentRoot()).setLineNumber(this.sequence, line);
    }

    public int getLineNumber() {
        return ((DocumentImpl)this.getDocumentRoot()).getLineNumber(this.sequence);
    }

    public int getNameCode() {
        return this.nameCode;
    }

    public void generateId(FastStringBuffer buffer) {
        this.getDocumentRoot().generateId(buffer);
        buffer.append("e");
        buffer.append(Integer.toString(this.sequence));
    }

    public int[] getDeclaredNamespaces(int[] buffer) {
        return EMPTY_NAMESPACE_LIST;
    }

    public final int getNodeKind() {
        return 1;
    }

    public AttributeCollection getAttributeList() {
        return emptyAtts;
    }

    public void copy(Receiver out, int whichNamespaces, boolean copyAnnotations, int locationId) throws XPathException {
        int typeCode;
        int n = typeCode = copyAnnotations ? this.getTypeAnnotation() : -1;
        if (locationId == 0 && out instanceof LocationCopier) {
            out.setSystemId(this.getSystemId());
            ((LocationCopier)out).setLineNumber(this.getLineNumber());
        }
        out.startElement(this.getNameCode(), typeCode, locationId, 0);
        switch (whichNamespaces) {
            case 0: {
                break;
            }
            case 1: {
                int ns;
                int[] localNamespaces = this.getDeclaredNamespaces(null);
                for (int i = 0; i < localNamespaces.length && (ns = localNamespaces[i]) != -1; ++i) {
                    out.namespace(ns, 0);
                }
                break;
            }
            case 2: {
                NamespaceCodeIterator.sendNamespaces(this, out);
            }
        }
        out.startContent();
        int childNamespaces = whichNamespaces == 0 ? 0 : 1;
        for (NodeImpl next = (NodeImpl)this.getFirstChild(); next != null; next = (NodeImpl)next.getNextSibling()) {
            next.copy(out, childNamespaces, copyAnnotations, locationId);
        }
        out.endElement();
    }
}

