/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.msd.ui.views;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.swt.ui.components.peak.PeakWithBackgroundUI;
import org.eclipse.chemclipse.swt.ui.support.AxisTitlesMassScale;
import org.eclipse.chemclipse.swt.ui.support.IAxisTitles;
import org.eclipse.chemclipse.ux.extension.msd.ui.views.AbstractChromatogramSelectionMSDView;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class PeakWithBackgroundView
extends AbstractChromatogramSelectionMSDView {
    @Inject
    private Composite parent;
    private PeakWithBackgroundUI peakWithBackgroundUI;

    @Inject
    public PeakWithBackgroundView(EPartService partService, MPart part, IEventBroker eventBroker) {
        super(part, partService, eventBroker);
    }

    @PostConstruct
    private void createControl() {
        this.parent.setLayout((Layout)new FillLayout());
        this.peakWithBackgroundUI = new PeakWithBackgroundUI(this.parent, 0, (IAxisTitles)new AxisTitlesMassScale());
    }

    @PreDestroy
    private void preDestroy() {
        this.unsubscribe();
    }

    @Focus
    public void setFocus() {
        this.peakWithBackgroundUI.setFocus();
        this.update(this.getChromatogramSelection(), false);
    }

    @Override
    public void update(IChromatogramSelectionMSD chromatogramSelection, boolean forceReload) {
        if (this.doUpdate((IChromatogramSelection)chromatogramSelection)) {
            this.update((IPeakMSD)chromatogramSelection.getSelectedPeak(), forceReload);
        }
    }

    @Override
    public boolean doUpdate(IChromatogramSelection chromatogramSelection) {
        if (super.doUpdate(chromatogramSelection) && chromatogramSelection instanceof IChromatogramSelectionMSD) {
            return ((IChromatogramSelectionMSD)chromatogramSelection).getSelectedPeak() != null;
        }
        return false;
    }

    private void update(IPeakMSD peak, boolean forceReload) {
        if (this.isPartVisible() && peak != null) {
            this.peakWithBackgroundUI.update(peak, forceReload);
        }
    }
}

