/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.core;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.identifier.peak.AbstractPeakIdentifier;
import org.eclipse.chemclipse.chromatogram.msd.identifier.processing.IPeakIdentifierProcessingInfo;
import org.eclipse.chemclipse.chromatogram.msd.identifier.processing.PeakIdentifierProcessingInfo;
import org.eclipse.chemclipse.chromatogram.msd.identifier.settings.IPeakIdentifierSettings;
import org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.internal.identifier.FileIdentifier;
import org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.msd.identifier.supplier.file.settings.IVendorPeakIdentifierSettings;
import org.eclipse.chemclipse.model.identifier.IPeakIdentificationResults;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.core.runtime.IProgressMonitor;

public class PeakIdentifier
extends AbstractPeakIdentifier {
    public IPeakIdentifierProcessingInfo identify(List<IPeakMSD> peaks, IPeakIdentifierSettings peakIdentifierSettings, IProgressMonitor monitor) {
        PeakIdentifierProcessingInfo processingInfo = new PeakIdentifierProcessingInfo();
        try {
            FileIdentifier fileIdentifier = new FileIdentifier();
            IVendorPeakIdentifierSettings filePeakIdentifierSettings = peakIdentifierSettings instanceof IVendorPeakIdentifierSettings ? (IVendorPeakIdentifierSettings)peakIdentifierSettings : PreferenceSupplier.getPeakIdentifierSettings();
            IPeakIdentificationResults peakIdentificationResults = fileIdentifier.runPeakIdentification(peaks, filePeakIdentifierSettings, (IPeakIdentifierProcessingInfo)processingInfo, monitor);
            processingInfo.setPeakIdentificationResults(peakIdentificationResults);
            processingInfo.addInfoMessage("File Identifier", "Done - peaks have been identified.");
        }
        catch (FileNotFoundException fileNotFoundException) {
            processingInfo.addErrorMessage("File Identifier", "Something has gone wrong.");
        }
        return processingInfo;
    }

    public IPeakIdentifierProcessingInfo identify(IPeakMSD peak, IPeakIdentifierSettings peakIdentifierSettings, IProgressMonitor monitor) {
        ArrayList<IPeakMSD> peaks = new ArrayList<IPeakMSD>();
        peaks.add(peak);
        return this.identify(peaks, peakIdentifierSettings, monitor);
    }

    public IPeakIdentifierProcessingInfo identify(IPeakMSD peak, IProgressMonitor monitor) {
        IVendorPeakIdentifierSettings peakIdentifierSettings = PreferenceSupplier.getPeakIdentifierSettings();
        return this.identify(peak, (IPeakIdentifierSettings)peakIdentifierSettings, monitor);
    }

    public IPeakIdentifierProcessingInfo identify(List<IPeakMSD> peaks, IProgressMonitor monitor) {
        IVendorPeakIdentifierSettings peakIdentifierSettings = PreferenceSupplier.getPeakIdentifierSettings();
        return this.identify(peaks, (IPeakIdentifierSettings)peakIdentifierSettings, monitor);
    }
}

