/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.chemclipse.internal.io;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipFile;
import org.eclipse.chemclipse.converter.exceptions.FileIsEmptyException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotReadableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.baseline.IBaselineModel;
import org.eclipse.chemclipse.model.core.IChromatogramOverview;
import org.eclipse.chemclipse.model.core.IIntegrationEntry;
import org.eclipse.chemclipse.model.core.IMethod;
import org.eclipse.chemclipse.model.core.IPeakIntensityValues;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.core.PeakType;
import org.eclipse.chemclipse.model.core.RetentionIndexType;
import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.model.exceptions.PeakException;
import org.eclipse.chemclipse.model.exceptions.ReferenceMustNotBeNullException;
import org.eclipse.chemclipse.model.identifier.ChromatogramComparisonResult;
import org.eclipse.chemclipse.model.identifier.ChromatogramLibraryInformation;
import org.eclipse.chemclipse.model.identifier.IComparisonResult;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.model.identifier.PeakComparisonResult;
import org.eclipse.chemclipse.model.identifier.PeakLibraryInformation;
import org.eclipse.chemclipse.model.implementation.PeakIntensityValues;
import org.eclipse.chemclipse.model.implementation.QuantitationEntry;
import org.eclipse.chemclipse.model.quantitation.IInternalStandard;
import org.eclipse.chemclipse.model.quantitation.IQuantitationEntry;
import org.eclipse.chemclipse.model.quantitation.InternalStandard;
import org.eclipse.chemclipse.model.targets.IPeakTarget;
import org.eclipse.chemclipse.model.targets.PeakTarget;
import org.eclipse.chemclipse.msd.converter.io.IChromatogramMSDReader;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.internal.io.AbstractChromatogramReader;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.internal.io.ReaderProxy_1007;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.model.chromatogram.IVendorIon;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.model.chromatogram.VendorChromatogram;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.model.chromatogram.VendorIon;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.model.chromatogram.VendorScan;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.model.chromatogram.VendorScanProxy;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IIonTransition;
import org.eclipse.chemclipse.msd.model.core.IIonTransitionSettings;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IPeakModelMSD;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.identifier.chromatogram.IChromatogramTargetMSD;
import org.eclipse.chemclipse.msd.model.core.identifier.massspectrum.IMassSpectrumTarget;
import org.eclipse.chemclipse.msd.model.core.identifier.massspectrum.MassSpectrumComparisonResult;
import org.eclipse.chemclipse.msd.model.core.identifier.massspectrum.MassSpectrumLibraryInformation;
import org.eclipse.chemclipse.msd.model.core.identifier.massspectrum.MassSpectrumTarget;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;
import org.eclipse.chemclipse.msd.model.exceptions.IonTransitionIsNullException;
import org.eclipse.chemclipse.msd.model.implementation.ChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.implementation.ChromatogramTarget;
import org.eclipse.chemclipse.msd.model.implementation.IntegrationEntryMSD;
import org.eclipse.chemclipse.msd.model.implementation.PeakMassSpectrum;
import org.eclipse.chemclipse.msd.model.implementation.PeakModelMSD;
import org.eclipse.chemclipse.msd.model.implementation.QuantitationEntryMSD;
import org.eclipse.chemclipse.msd.model.implementation.ScanMSD;
import org.eclipse.chemclipse.support.history.EditInformation;
import org.eclipse.chemclipse.support.history.IEditHistory;
import org.eclipse.chemclipse.support.history.IEditInformation;
import org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.internal.support.BaselineElement;
import org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.internal.support.IBaselineElement;
import org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.preferences.PreferenceSupplier;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public class ChromatogramReader_1100
extends AbstractChromatogramReader
implements IChromatogramMSDReader {
    private static final Logger logger = Logger.getLogger(ChromatogramReader_1100.class);

    public IChromatogramMSD read(File file, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        IChromatogramMSD chromatogram = null;
        try (ZipFile zipFile = new ZipFile(file);){
            if (this.isValidFileFormat(zipFile)) {
                monitor.subTask("Import Chromatogram");
                chromatogram = this.readFromZipFile(zipFile, file, monitor);
            }
        }
        return chromatogram;
    }

    public IChromatogramOverview readOverview(File file, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        IChromatogramOverview chromatogramOverview = null;
        try (ZipFile zipFile = new ZipFile(file);){
            if (this.isValidFileFormat(zipFile)) {
                chromatogramOverview = this.readOverviewFromZipFile(zipFile, monitor);
            }
        }
        return chromatogramOverview;
    }

    private IChromatogramMSD readFromZipFile(ZipFile zipFile, File file, IProgressMonitor monitor) throws IOException {
        VendorChromatogram chromatogram = new VendorChromatogram();
        IEclipsePreferences preferences = PreferenceSupplier.INSTANCE().getPreferences();
        boolean useScanProxies = preferences.getBoolean("useScanProxies", false);
        this.readMethod(zipFile, chromatogram, monitor);
        if (useScanProxies) {
            this.readScanProxies(zipFile, file, chromatogram, monitor);
        } else {
            this.readScans(zipFile, chromatogram, monitor);
        }
        this.readBaseline(zipFile, chromatogram, monitor);
        this.readPeaks(zipFile, chromatogram, monitor);
        this.readArea(zipFile, chromatogram, monitor);
        this.readIdentification(zipFile, chromatogram, monitor);
        this.readHistory(zipFile, chromatogram, monitor);
        this.readMiscellaneous(zipFile, chromatogram, monitor);
        this.setAdditionalInformation(file, chromatogram, monitor);
        return chromatogram;
    }

    private void readMethod(ZipFile zipFile, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws IOException {
        DataInputStream dataInputStream = this.getDataInputStream(zipFile, "MSD/CHROMATOGRAM/SYSTEM_SETTINGS");
        IMethod method = chromatogram.getMethod();
        method.setInstrumentName(this.readString(dataInputStream));
        method.setIonSource(this.readString(dataInputStream));
        method.setSamplingRate(dataInputStream.readDouble());
        method.setSolventDelay(dataInputStream.readInt());
        method.setSourceHeater(dataInputStream.readDouble());
        method.setStopMode(this.readString(dataInputStream));
        method.setStopTime(dataInputStream.readInt());
        method.setTimeFilterPeakWidth(dataInputStream.readInt());
        dataInputStream.close();
    }

    private IChromatogramOverview readOverviewFromZipFile(ZipFile zipFile, IProgressMonitor monitor) throws IOException {
        DataInputStream dataInputStream = this.getDataInputStream(zipFile, "MSD/OVERVIEW/TIC");
        VendorChromatogram chromatogram = new VendorChromatogram();
        this.readScansOverview(dataInputStream, chromatogram, monitor);
        dataInputStream.close();
        return chromatogram;
    }

    private void readScansOverview(DataInputStream dataInputStream, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws IOException {
        int scans = dataInputStream.readInt();
        int scan = 1;
        while (scan <= scans) {
            VendorScan massSpectrum = new VendorScan();
            int retentionTime = dataInputStream.readInt();
            float abundance = dataInputStream.readFloat();
            try {
                VendorIon ion = new VendorIon(0.0, abundance);
                massSpectrum.setRetentionTime(retentionTime);
                massSpectrum.addIon((IIon)ion);
                chromatogram.addScan((IScan)massSpectrum);
            }
            catch (AbundanceLimitExceededException e) {
                logger.warn((Object)e);
            }
            catch (IonLimitExceededException e) {
                logger.warn((Object)e);
            }
            ++scan;
        }
    }

    private void setAdditionalInformation(File file, IChromatogramMSD chromatogram, IProgressMonitor monitor) {
        int startRetentionTime;
        chromatogram.setConverterId("org.eclipse.chemclipse.xxd.converter.supplier.chemclipse");
        chromatogram.setFile(file);
        int scanDelay = startRetentionTime = chromatogram.getStartRetentionTime();
        chromatogram.setScanDelay(scanDelay);
        int endRetentionTime = chromatogram.getStopRetentionTime();
        int scanInterval = endRetentionTime / chromatogram.getNumberOfScans();
        chromatogram.setScanInterval(scanInterval);
    }

    private void readScanProxies(ZipFile zipFile, File file, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws IOException {
        IIonTransitionSettings ionTransitionSettings = chromatogram.getIonTransitionSettings();
        DataInputStream dataInputStream = this.getDataInputStream(zipFile, "MSD/CHROMATOGRAM/SCANPROXIES");
        int scans = dataInputStream.readInt();
        int scan = 1;
        while (scan <= scans) {
            monitor.subTask("Import Scan: " + scan);
            int offset = dataInputStream.readInt();
            int retentionTime = dataInputStream.readInt();
            int numberOfIons = dataInputStream.readInt();
            float totalSignal = dataInputStream.readFloat();
            float retentionIndex = dataInputStream.readFloat();
            int timeSegmentId = dataInputStream.readInt();
            int cycleNumber = dataInputStream.readInt();
            VendorScanProxy massSpectrum = new VendorScanProxy(file, offset, "1.1.0.0", ionTransitionSettings);
            massSpectrum.setRetentionTime(retentionTime);
            massSpectrum.setNumberOfIons(numberOfIons);
            massSpectrum.setTotalSignal(totalSignal);
            massSpectrum.setRetentionIndex(retentionIndex);
            massSpectrum.setTimeSegmentId(timeSegmentId);
            massSpectrum.setCycleNumber(cycleNumber);
            chromatogram.addScan((IScan)massSpectrum);
            ++scan;
        }
        dataInputStream.close();
    }

    private void readScans(ZipFile zipFile, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws IOException {
        IIonTransitionSettings ionTransitionSettings = chromatogram.getIonTransitionSettings();
        DataInputStream dataInputStream = this.getDataInputStream(zipFile, "MSD/CHROMATOGRAM/SCANS");
        ReaderProxy_1007 readerProxy = new ReaderProxy_1007();
        int scans = dataInputStream.readInt();
        int scan = 1;
        while (scan <= scans) {
            monitor.subTask("Import Scan: " + scan);
            VendorScan massSpectrum = new VendorScan();
            readerProxy.readMassSpectrum(massSpectrum, dataInputStream, ionTransitionSettings, monitor);
            chromatogram.addScan((IScan)massSpectrum);
            ++scan;
        }
        dataInputStream.close();
    }

    private void readBaseline(ZipFile zipFile, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws IOException {
        DataInputStream dataInputStream = this.getDataInputStream(zipFile, "MSD/CHROMATOGRAM/BASELINE");
        int scans = dataInputStream.readInt();
        ArrayList<BaselineElement> baselineElements = new ArrayList<BaselineElement>();
        int scan = 1;
        while (scan <= scans) {
            monitor.subTask("Import Baseline: " + scan);
            int retentionTime = dataInputStream.readInt();
            float backgroundAbundance = dataInputStream.readFloat();
            BaselineElement baselineElement = new BaselineElement(retentionTime, backgroundAbundance);
            baselineElements.add(baselineElement);
            ++scan;
        }
        IBaselineModel baselineModel = chromatogram.getBaselineModel();
        int index = 0;
        while (index < scans - 1) {
            monitor.subTask("Import Baseline: " + index);
            IBaselineElement baselineElement = (IBaselineElement)baselineElements.get(index);
            IBaselineElement baselineElementNext = (IBaselineElement)baselineElements.get(index + 1);
            int startRetentionTime = baselineElement.getRetentionTime();
            float startBackgroundAbundance = baselineElement.getBackgroundAbundance();
            int stopRetentionTime = baselineElementNext.getRetentionTime();
            float stopBackgroundAbundance = baselineElementNext.getBackgroundAbundance();
            baselineModel.addBaseline(startRetentionTime, stopRetentionTime, startBackgroundAbundance, stopBackgroundAbundance, false);
            ++index;
        }
        dataInputStream.close();
    }

    private void readPeaks(ZipFile zipFile, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws IOException {
        DataInputStream dataInputStream = this.getDataInputStream(zipFile, "MSD/CHROMATOGRAM/PEAKS");
        int numberOfPeaks = dataInputStream.readInt();
        int i = 1;
        while (i <= numberOfPeaks) {
            monitor.subTask("Import Peak: " + i);
            try {
                IChromatogramPeakMSD peak = this.readPeak(dataInputStream, chromatogram, monitor);
                chromatogram.addPeak(peak);
            }
            catch (IllegalArgumentException e) {
                logger.warn((Object)e);
            }
            catch (PeakException e) {
                logger.warn((Object)e);
            }
            ++i;
        }
        dataInputStream.close();
    }

    private IChromatogramPeakMSD readPeak(DataInputStream dataInputStream, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws IOException, IllegalArgumentException, PeakException {
        IIonTransitionSettings ionTransitionSettings = chromatogram.getIonTransitionSettings();
        String detectorDescription = this.readString(dataInputStream);
        String quantifierDescription = this.readString(dataInputStream);
        boolean activeForAnalysis = dataInputStream.readBoolean();
        String integratorDescription = this.readString(dataInputStream);
        String modelDescription = this.readString(dataInputStream);
        PeakType peakType = PeakType.valueOf((String)this.readString(dataInputStream));
        int suggestedNumberOfComponents = dataInputStream.readInt();
        float startBackgroundAbundance = dataInputStream.readFloat();
        float stopBackgroundAbundance = dataInputStream.readFloat();
        IPeakMassSpectrum peakMaximum = this.readPeakMassSpectrum(dataInputStream, ionTransitionSettings, monitor);
        int numberOfRetentionTimes = dataInputStream.readInt();
        PeakIntensityValues intensityValues = new PeakIntensityValues(Float.MAX_VALUE);
        int i = 1;
        while (i <= numberOfRetentionTimes) {
            int retentionTime = dataInputStream.readInt();
            float relativeIntensity = dataInputStream.readFloat();
            intensityValues.addIntensityValue(retentionTime, relativeIntensity);
            ++i;
        }
        intensityValues.normalize();
        PeakModelMSD peakModel = new PeakModelMSD(peakMaximum, (IPeakIntensityValues)intensityValues, startBackgroundAbundance, stopBackgroundAbundance);
        ChromatogramPeakMSD peak = new ChromatogramPeakMSD((IPeakModelMSD)peakModel, chromatogram);
        peak.setDetectorDescription(detectorDescription);
        peak.setQuantifierDescription(quantifierDescription);
        peak.setActiveForAnalysis(activeForAnalysis);
        peak.setIntegratorDescription(integratorDescription);
        peak.setModelDescription(modelDescription);
        peak.setPeakType(peakType);
        peak.setSuggestedNumberOfComponents(suggestedNumberOfComponents);
        List<IIntegrationEntry> integrationEntries = this.readIntegrationEntries(dataInputStream);
        peak.setIntegratedArea(integrationEntries, integratorDescription);
        this.readPeakIdentificationTargets(dataInputStream, (IPeakMSD)peak, monitor);
        this.readPeakQuantitationEntries(dataInputStream, (IPeakMSD)peak, monitor);
        boolean readOptimizedMassSpectrum = dataInputStream.readBoolean();
        if (readOptimizedMassSpectrum) {
            ScanMSD optimizedMassSpectrum = new ScanMSD();
            this.readNormalMassSpectrum((IScanMSD)optimizedMassSpectrum, dataInputStream, ionTransitionSettings, monitor);
            peakMaximum.setOptimizedMassSpectrum((IScanMSD)optimizedMassSpectrum);
        }
        List<IInternalStandard> internalStandards = this.readInternalStandards(dataInputStream);
        peak.addInternalStandards(internalStandards);
        return peak;
    }

    private List<IInternalStandard> readInternalStandards(DataInputStream dataInputStream) throws IOException {
        ArrayList<IInternalStandard> internalStandards = new ArrayList<IInternalStandard>();
        int numberOfInternalStandards = dataInputStream.readInt();
        int i = 1;
        while (i <= numberOfInternalStandards) {
            String name = this.readString(dataInputStream);
            double concentration = dataInputStream.readDouble();
            String concentrationUnit = this.readString(dataInputStream);
            double responseFactor = dataInputStream.readDouble();
            String chemicalClass = this.readString(dataInputStream);
            InternalStandard internalStandard = new InternalStandard(name, concentration, concentrationUnit, responseFactor);
            internalStandard.setChemicalClass(chemicalClass);
            internalStandards.add((IInternalStandard)internalStandard);
            ++i;
        }
        return internalStandards;
    }

    private List<IIntegrationEntry> readIntegrationEntries(DataInputStream dataInputStream) throws IOException {
        ArrayList<IIntegrationEntry> integrationEntries = new ArrayList<IIntegrationEntry>();
        int numberOfIntegrationEntries = dataInputStream.readInt();
        int i = 1;
        while (i <= numberOfIntegrationEntries) {
            double ion = dataInputStream.readDouble();
            double integratedArea = dataInputStream.readDouble();
            IntegrationEntryMSD integrationEntry = new IntegrationEntryMSD(ion, integratedArea);
            integrationEntries.add((IIntegrationEntry)integrationEntry);
            ++i;
        }
        return integrationEntries;
    }

    private void readPeakIdentificationTargets(DataInputStream dataInputStream, IPeakMSD peak, IProgressMonitor monitor) throws IOException {
        int numberOfPeakTargets = dataInputStream.readInt();
        int i = 1;
        while (i <= numberOfPeakTargets) {
            String identifier = this.readString(dataInputStream);
            boolean manuallyVerified = dataInputStream.readBoolean();
            String casNumber = this.readString(dataInputStream);
            String comments = this.readString(dataInputStream);
            String referenceIdentifier = this.readString(dataInputStream);
            String miscellaneous = this.readString(dataInputStream);
            String database = this.readString(dataInputStream);
            String contributor = this.readString(dataInputStream);
            String name = this.readString(dataInputStream);
            HashSet<String> synonyms = new HashSet<String>();
            int numberOfSynonyms = dataInputStream.readInt();
            int j = 0;
            while (j < numberOfSynonyms) {
                synonyms.add(this.readString(dataInputStream));
                ++j;
            }
            String formula = this.readString(dataInputStream);
            String smiles = this.readString(dataInputStream);
            String inChI = this.readString(dataInputStream);
            double molWeight = dataInputStream.readDouble();
            float matchFactor = dataInputStream.readFloat();
            float matchFactorDirect = dataInputStream.readFloat();
            float reverseMatchFactor = dataInputStream.readFloat();
            float reverseMatchFactorDirect = dataInputStream.readFloat();
            float probability = dataInputStream.readFloat();
            boolean isMatch = dataInputStream.readBoolean();
            PeakLibraryInformation libraryInformation = new PeakLibraryInformation();
            libraryInformation.setCasNumber(casNumber);
            libraryInformation.setComments(comments);
            libraryInformation.setReferenceIdentifier(referenceIdentifier);
            libraryInformation.setMiscellaneous(miscellaneous);
            libraryInformation.setDatabase(database);
            libraryInformation.setContributor(contributor);
            libraryInformation.setName(name);
            libraryInformation.setSynonyms(synonyms);
            libraryInformation.setFormula(formula);
            libraryInformation.setSmiles(smiles);
            libraryInformation.setInChI(inChI);
            libraryInformation.setMolWeight(molWeight);
            PeakComparisonResult comparisonResult = new PeakComparisonResult(matchFactor, reverseMatchFactor, matchFactorDirect, reverseMatchFactorDirect, probability);
            comparisonResult.setMatch(isMatch);
            try {
                PeakTarget identificationEntry = new PeakTarget((ILibraryInformation)libraryInformation, (IComparisonResult)comparisonResult);
                identificationEntry.setIdentifier(identifier);
                identificationEntry.setManuallyVerified(manuallyVerified);
                peak.addTarget((IPeakTarget)identificationEntry);
            }
            catch (ReferenceMustNotBeNullException e) {
                logger.warn((Object)e);
            }
            ++i;
        }
    }

    private void readMassSpectrumIdentificationTargets(DataInputStream dataInputStream, IScanMSD massSpectrum, IProgressMonitor monitor) throws IOException {
        int numberOfMassSpectrumTargets = dataInputStream.readInt();
        int i = 1;
        while (i <= numberOfMassSpectrumTargets) {
            String identifier = this.readString(dataInputStream);
            boolean manuallyVerified = dataInputStream.readBoolean();
            String casNumber = this.readString(dataInputStream);
            String comments = this.readString(dataInputStream);
            String referenceIdentifier = this.readString(dataInputStream);
            String miscellaneous = this.readString(dataInputStream);
            String database = this.readString(dataInputStream);
            String contributor = this.readString(dataInputStream);
            String name = this.readString(dataInputStream);
            HashSet<String> synonyms = new HashSet<String>();
            int numberOfSynonyms = dataInputStream.readInt();
            int j = 0;
            while (j < numberOfSynonyms) {
                synonyms.add(this.readString(dataInputStream));
                ++j;
            }
            String formula = this.readString(dataInputStream);
            String smiles = this.readString(dataInputStream);
            String inChI = this.readString(dataInputStream);
            double molWeight = dataInputStream.readDouble();
            float matchFactor = dataInputStream.readFloat();
            float matchFactorDirect = dataInputStream.readFloat();
            float reverseMatchFactor = dataInputStream.readFloat();
            float reverseMatchFactorDirect = dataInputStream.readFloat();
            float probability = dataInputStream.readFloat();
            boolean isMatch = dataInputStream.readBoolean();
            MassSpectrumLibraryInformation libraryInformation = new MassSpectrumLibraryInformation();
            libraryInformation.setCasNumber(casNumber);
            libraryInformation.setComments(comments);
            libraryInformation.setReferenceIdentifier(referenceIdentifier);
            libraryInformation.setMiscellaneous(miscellaneous);
            libraryInformation.setDatabase(database);
            libraryInformation.setContributor(contributor);
            libraryInformation.setName(name);
            libraryInformation.setSynonyms(synonyms);
            libraryInformation.setFormula(formula);
            libraryInformation.setSmiles(smiles);
            libraryInformation.setInChI(inChI);
            libraryInformation.setMolWeight(molWeight);
            MassSpectrumComparisonResult comparisonResult = new MassSpectrumComparisonResult(matchFactor, reverseMatchFactor, matchFactorDirect, reverseMatchFactorDirect, probability);
            comparisonResult.setMatch(isMatch);
            try {
                MassSpectrumTarget identificationEntry = new MassSpectrumTarget((ILibraryInformation)libraryInformation, (IComparisonResult)comparisonResult);
                identificationEntry.setIdentifier(identifier);
                identificationEntry.setManuallyVerified(manuallyVerified);
                massSpectrum.addTarget((IMassSpectrumTarget)identificationEntry);
            }
            catch (ReferenceMustNotBeNullException e) {
                logger.warn((Object)e);
            }
            ++i;
        }
    }

    private void readPeakQuantitationEntries(DataInputStream dataInputStream, IPeakMSD peak, IProgressMonitor monitor) throws IOException {
        int numberOfQuantitationEntries = dataInputStream.readInt();
        int i = 1;
        while (i <= numberOfQuantitationEntries) {
            QuantitationEntry quantitationEntry;
            String name = this.readString(dataInputStream);
            String chemicalClass = this.readString(dataInputStream);
            double concentration = dataInputStream.readDouble();
            String concentrationUnit = this.readString(dataInputStream);
            double area = dataInputStream.readDouble();
            String calibrationMethod = this.readString(dataInputStream);
            boolean usedCrossZero = dataInputStream.readBoolean();
            String description = this.readString(dataInputStream);
            boolean isMSD = dataInputStream.readBoolean();
            if (isMSD) {
                double ion = dataInputStream.readDouble();
                quantitationEntry = new QuantitationEntryMSD(name, concentration, concentrationUnit, area, ion);
            } else {
                quantitationEntry = new QuantitationEntry(name, concentration, concentrationUnit, area);
            }
            quantitationEntry.setChemicalClass(chemicalClass);
            quantitationEntry.setCalibrationMethod(calibrationMethod);
            quantitationEntry.setUsedCrossZero(usedCrossZero);
            quantitationEntry.setDescription(description);
            peak.addQuantitationEntry((IQuantitationEntry)quantitationEntry);
            ++i;
        }
    }

    private void readArea(ZipFile zipFile, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws IOException {
        DataInputStream dataInputStream = this.getDataInputStream(zipFile, "MSD/CHROMATOGRAM/AREA");
        String chromatogramIntegratorDescription = this.readString(dataInputStream);
        List<IIntegrationEntry> chromatogramIntegrationEntries = this.readIntegrationEntries(dataInputStream);
        chromatogram.setChromatogramIntegratedArea(chromatogramIntegrationEntries, chromatogramIntegratorDescription);
        String backgroundIntegratorDescription = this.readString(dataInputStream);
        List<IIntegrationEntry> backgroundIntegrationEntries = this.readIntegrationEntries(dataInputStream);
        chromatogram.setBackgroundIntegratedArea(backgroundIntegrationEntries, backgroundIntegratorDescription);
        dataInputStream.close();
    }

    private void readIdentification(ZipFile zipFile, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws IOException {
        DataInputStream dataInputStream = this.getDataInputStream(zipFile, "MSD/CHROMATOGRAM/IDENTIFICATION");
        int numberOfTargets = dataInputStream.readInt();
        int i = 1;
        while (i <= numberOfTargets) {
            String identifier = this.readString(dataInputStream);
            boolean manuallyVerified = dataInputStream.readBoolean();
            String casNumber = this.readString(dataInputStream);
            String comments = this.readString(dataInputStream);
            String referenceIdentifier = this.readString(dataInputStream);
            String miscellaneous = this.readString(dataInputStream);
            String database = this.readString(dataInputStream);
            String contributor = this.readString(dataInputStream);
            String name = this.readString(dataInputStream);
            HashSet<String> synonyms = new HashSet<String>();
            int numberOfSynonyms = dataInputStream.readInt();
            int j = 0;
            while (j < numberOfSynonyms) {
                synonyms.add(this.readString(dataInputStream));
                ++j;
            }
            String formula = this.readString(dataInputStream);
            String smiles = this.readString(dataInputStream);
            String inChI = this.readString(dataInputStream);
            double molWeight = dataInputStream.readDouble();
            float matchFactor = dataInputStream.readFloat();
            float matchFactorDirect = dataInputStream.readFloat();
            float reverseMatchFactor = dataInputStream.readFloat();
            float reverseMatchFactorDirect = dataInputStream.readFloat();
            float probability = dataInputStream.readFloat();
            boolean isMatch = dataInputStream.readBoolean();
            ChromatogramLibraryInformation libraryInformation = new ChromatogramLibraryInformation();
            libraryInformation.setCasNumber(casNumber);
            libraryInformation.setComments(comments);
            libraryInformation.setReferenceIdentifier(referenceIdentifier);
            libraryInformation.setMiscellaneous(miscellaneous);
            libraryInformation.setDatabase(database);
            libraryInformation.setContributor(contributor);
            libraryInformation.setName(name);
            libraryInformation.setSynonyms(synonyms);
            libraryInformation.setFormula(formula);
            libraryInformation.setSmiles(smiles);
            libraryInformation.setInChI(inChI);
            libraryInformation.setMolWeight(molWeight);
            ChromatogramComparisonResult comparisonResult = new ChromatogramComparisonResult(matchFactor, reverseMatchFactor, matchFactorDirect, reverseMatchFactorDirect, probability);
            comparisonResult.setMatch(isMatch);
            try {
                ChromatogramTarget identificationEntry = new ChromatogramTarget((ILibraryInformation)libraryInformation, (IComparisonResult)comparisonResult);
                identificationEntry.setIdentifier(identifier);
                identificationEntry.setManuallyVerified(manuallyVerified);
                chromatogram.addTarget((IChromatogramTargetMSD)identificationEntry);
            }
            catch (ReferenceMustNotBeNullException e) {
                logger.warn((Object)e);
            }
            ++i;
        }
        dataInputStream.close();
    }

    private void readHistory(ZipFile zipFile, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws IOException {
        DataInputStream dataInputStream = this.getDataInputStream(zipFile, "MSD/CHROMATOGRAM/HISTORY");
        IEditHistory editHistory = chromatogram.getEditHistory();
        int numberOfEntries = dataInputStream.readInt();
        int i = 1;
        while (i <= numberOfEntries) {
            long time = dataInputStream.readLong();
            String description = this.readString(dataInputStream);
            Date date = new Date(time);
            EditInformation editInformation = new EditInformation(date, description);
            editHistory.add((IEditInformation)editInformation);
            ++i;
        }
        dataInputStream.close();
    }

    private void readMiscellaneous(ZipFile zipFile, IChromatogramMSD chromatogram, IProgressMonitor monitor) throws IOException {
        DataInputStream dataInputStream = this.getDataInputStream(zipFile, "MSD/CHROMATOGRAM/MISC");
        long time = dataInputStream.readLong();
        String miscInfo = this.readString(dataInputStream);
        String miscInfoSeparated = this.readString(dataInputStream);
        String dataName = this.readString(dataInputStream);
        String operator = this.readString(dataInputStream);
        Date date = new Date(time);
        chromatogram.setDate(date);
        chromatogram.setMiscInfo(miscInfo);
        chromatogram.setMiscInfoSeparated(miscInfoSeparated);
        chromatogram.setDataName(dataName);
        chromatogram.setOperator(operator);
        dataInputStream.close();
    }

    private IPeakMassSpectrum readPeakMassSpectrum(DataInputStream dataInputStream, IIonTransitionSettings ionTransitionSettings, IProgressMonitor monitor) throws IOException {
        short massSpectrometer = dataInputStream.readShort();
        short massSpectrumType = dataInputStream.readShort();
        double precursorIon = dataInputStream.readDouble();
        PeakMassSpectrum massSpectrum = new PeakMassSpectrum();
        massSpectrum.setMassSpectrometer(massSpectrometer);
        massSpectrum.setMassSpectrumType(massSpectrumType);
        massSpectrum.setPrecursorIon(precursorIon);
        this.readNormalMassSpectrum((IScanMSD)massSpectrum, dataInputStream, ionTransitionSettings, monitor);
        return massSpectrum;
    }

    private void readNormalMassSpectrum(IScanMSD massSpectrum, DataInputStream dataInputStream, IIonTransitionSettings ionTransitionSettings, IProgressMonitor monitor) throws IOException {
        int retentionTime = dataInputStream.readInt();
        int retentionTimeColumn1 = dataInputStream.readInt();
        int retentionTimeColumn2 = dataInputStream.readInt();
        float retentionIndex = dataInputStream.readFloat();
        if (dataInputStream.readBoolean()) {
            int size = dataInputStream.readInt();
            int i = 0;
            while (i < size) {
                RetentionIndexType retentionIndexType = RetentionIndexType.valueOf((String)this.readString(dataInputStream));
                float retentionIndexAdditional = dataInputStream.readFloat();
                massSpectrum.setRetentionIndex(retentionIndexType, retentionIndexAdditional);
                ++i;
            }
        }
        int timeSegmentId = dataInputStream.readInt();
        int cycleNumber = dataInputStream.readInt();
        massSpectrum.setRetentionTime(retentionTime);
        massSpectrum.setRetentionTimeColumn1(retentionTimeColumn1);
        massSpectrum.setRetentionTimeColumn2(retentionTimeColumn2);
        massSpectrum.setRetentionIndex(retentionIndex);
        massSpectrum.setTimeSegmentId(timeSegmentId);
        massSpectrum.setCycleNumber(cycleNumber);
        int numberOfIons = dataInputStream.readInt();
        int i = 1;
        while (i <= numberOfIons) {
            try {
                IVendorIon ion = this.readIon(dataInputStream, ionTransitionSettings);
                massSpectrum.addIon((IIon)ion);
            }
            catch (AbundanceLimitExceededException e) {
                logger.warn((Object)e);
            }
            catch (IonLimitExceededException e) {
                logger.warn((Object)e);
            }
            catch (IonTransitionIsNullException e) {
                logger.warn((Object)e);
            }
            ++i;
        }
        this.readMassSpectrumIdentificationTargets(dataInputStream, massSpectrum, monitor);
    }

    private IVendorIon readIon(DataInputStream dataInputStream, IIonTransitionSettings ionTransitionSettings) throws IOException, AbundanceLimitExceededException, IonLimitExceededException, IonTransitionIsNullException {
        VendorIon ion;
        double mz = dataInputStream.readDouble();
        float abundance = dataInputStream.readFloat();
        int transition = dataInputStream.readInt();
        if (transition == 0) {
            ion = new VendorIon(mz, abundance);
        } else {
            String compoundName = this.readString(dataInputStream);
            double filter1FirstIon = dataInputStream.readDouble();
            double filter1LastIon = dataInputStream.readDouble();
            double filter3FirstIon = dataInputStream.readDouble();
            double filter3LastIon = dataInputStream.readDouble();
            double collisionEnergy = dataInputStream.readDouble();
            double filter1Resolution = dataInputStream.readDouble();
            double filter3Resolution = dataInputStream.readDouble();
            int transitionGroup = dataInputStream.readInt();
            int dwell = dataInputStream.readInt();
            IIonTransition ionTransition = ionTransitionSettings.getIonTransition(compoundName, filter1FirstIon, filter1LastIon, filter3FirstIon, filter3LastIon, collisionEnergy, filter1Resolution, filter3Resolution, transitionGroup);
            ionTransition.setDwell(dwell);
            ion = new VendorIon(mz, abundance, ionTransition);
        }
        return ion;
    }

    private boolean isValidFileFormat(ZipFile zipFile) throws IOException {
        boolean isValid = false;
        DataInputStream dataInputStream = this.getDataInputStream(zipFile, "VERSION");
        String version = this.readString(dataInputStream);
        if (version.equals("1.1.0.0")) {
            isValid = true;
        }
        dataInputStream.close();
        return isValid;
    }
}

