/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.ui.provider;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class FileExplorerContentProvider
implements ITreeContentProvider {
    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof File) {
            File file = (File)parentElement;
            return this.getFiles(file);
        }
        return File.listRoots();
    }

    public Object getParent(Object element) {
        File file;
        File parentFile;
        if (element instanceof File && (parentFile = (file = (File)element).getParentFile()).canRead() && !parentFile.isHidden()) {
            return parentFile;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof File) {
            File file = (File)element;
            return this.hasChildren(file);
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public File[] getFiles(File parentFile) {
        ArrayList<File> files = new ArrayList<File>();
        if (parentFile.isDirectory() && parentFile.canRead()) {
            File updatedParentFile = new File(parentFile.toString());
            File[] fileList = updatedParentFile.listFiles();
            if (fileList != null) {
                File[] fileArray = fileList;
                int n = fileList.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (!file.isHidden()) {
                        files.add(file);
                    }
                    ++n2;
                }
                Object[] allFiles = new File[files.size()];
                files.toArray(allFiles);
                Arrays.sort(allFiles);
                return allFiles;
            }
            return null;
        }
        return null;
    }

    public boolean hasChildren(File parentFile) {
        ArrayList<File> files = new ArrayList<File>();
        if (parentFile.isDirectory() && parentFile.canRead()) {
            File[] fileList = parentFile.listFiles();
            if (fileList != null) {
                File[] fileArray = parentFile.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (!file.isHidden()) {
                        files.add(file);
                    }
                    ++n2;
                }
                return files.size() > 0;
            }
            return false;
        }
        return false;
    }
}

