/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.ui.editors;

import java.io.File;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.io.CalibrationFileReader;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.io.CalibrationFileWriter;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.ui.editors.PageCalibration;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.MultiPageEditorPart;

public class EditorCalibration
extends MultiPageEditorPart {
    private PageCalibration pageCalibration;
    private File file;
    private boolean isDirty = false;
    private boolean initialize = true;

    protected void createPages() {
        this.pageCalibration = new PageCalibration(this.getContainer());
        int pageIndex = this.addPage((Control)this.pageCalibration.getControl());
        this.setPageText(pageIndex, "Retention Index Calibration (*.cal)");
        this.setDirty(true);
    }

    public void doSave(IProgressMonitor monitor) {
        CalibrationFileWriter calibrationFileWriter = new CalibrationFileWriter();
        calibrationFileWriter.write(this.file, this.pageCalibration.getRetentionIndexEntries());
        this.setDirty(false);
    }

    public void doSaveAs() {
        FileDialog fileDialog = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
        fileDialog.setText("Save the *.cal file.");
        fileDialog.setFilterExtensions(new String[]{"*.cal"});
        fileDialog.setFilterNames(new String[]{"AMDIS Calibration *.cal"});
        String pathRetentionIndexFile = fileDialog.open();
        if (pathRetentionIndexFile != null) {
            File file = new File(pathRetentionIndexFile);
            CalibrationFileWriter calibrationFileWriter = new CalibrationFileWriter();
            calibrationFileWriter.write(file, this.pageCalibration.getRetentionIndexEntries());
            this.setDirty(false);
        }
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void setFocus() {
        if (this.initialize) {
            this.initialize = false;
            CalibrationFileReader calibrationFileReader = new CalibrationFileReader();
            List retentionIndexEntries = calibrationFileReader.parse(this.file);
            this.pageCalibration.showData(retentionIndexEntries);
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        String fileName = input.getName();
        fileName = fileName.substring(0, fileName.length() - 4);
        this.setPartName(fileName);
        if (!(input instanceof IFileEditorInput)) {
            throw new PartInitException("The file could't be loaded.");
        }
        IFileEditorInput fileEditorInput = (IFileEditorInput)input;
        this.file = fileEditorInput.getFile().getLocation().toFile();
    }

    public void dispose() {
        super.dispose();
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
        this.firePropertyChange(257);
    }
}

