/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.ui.internal.runnables;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.impl.AlkanePatternDetectorCSD;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.impl.AlkanePatternDetectorMSD;
import org.eclipse.chemclipse.chromatogram.xxd.calculator.supplier.amdiscalri.ui.wizards.IRetentionIndexWizardElements;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class ImportChromatogramRunnable
implements IRunnableWithProgress {
    private IRetentionIndexWizardElements wizardElements;
    private IChromatogram chromatogram;

    public ImportChromatogramRunnable(IRetentionIndexWizardElements wizardElements) {
        this.wizardElements = wizardElements;
    }

    public IChromatogram getChromatogram() {
        return this.chromatogram;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        String pathRetentionIndexFile = "";
        if (this.wizardElements.isUseExistingRetentionIndexFile()) {
            pathRetentionIndexFile = this.wizardElements.getPathRetentionIndexFile();
        }
        boolean useAlreadyDetectedPeaks = this.wizardElements.isUseAlreadyDetectedPeaks();
        if (this.wizardElements.isUseMassSpectrometryData()) {
            String chromatogramPath = (String)this.wizardElements.getChromatogramWizardElementsMSD().getSelectedChromatograms().get(0);
            AlkanePatternDetectorMSD alkanePatternDetector = new AlkanePatternDetectorMSD();
            this.chromatogram = alkanePatternDetector.parseChromatogram(chromatogramPath, pathRetentionIndexFile, useAlreadyDetectedPeaks, monitor);
        } else {
            String chromatogramPath = (String)this.wizardElements.getChromatogramWizardElementsCSD().getSelectedChromatograms().get(0);
            AlkanePatternDetectorCSD alkanePatternDetector = new AlkanePatternDetectorCSD();
            this.chromatogram = alkanePatternDetector.parseChromatogram(chromatogramPath, pathRetentionIndexFile, useAlreadyDetectedPeaks, monitor);
        }
    }
}

