/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.index;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.index.IDataSetIndex;
import org.eclipse.birt.data.engine.impl.index.IOrderedIntSet;
import org.eclipse.birt.data.engine.impl.index.IOrderedIntSetIterator;
import org.eclipse.birt.data.engine.impl.index.SerializableBirtHash;

public class DataSetInMemoryStringIndex
extends HashMap
implements IDataSetIndex {
    public DataSetInMemoryStringIndex(RAInputStream indexStream, RAInputStream valueStream) throws IOException {
        DataInputStream dis = new DataInputStream((InputStream)indexStream);
        int size = IOUtil.readInt((InputStream)indexStream);
        int i = 0;
        while (i < size) {
            Object keyValue;
            long offset = IOUtil.readLong((DataInputStream)dis);
            if ((long)SerializableBirtHash.NULL_VALUE_OFFSET == offset) {
                super.put(null, new WrapperedValue(null, IOUtil.readIntList((DataInputStream)dis)));
            } else if ((long)SerializableBirtHash.NOT_HASH_VALUE_OFFSET == offset) {
                keyValue = IOUtil.readString((DataInputStream)dis);
                super.put(keyValue, new WrapperedValue((String)keyValue, IOUtil.readIntList((DataInputStream)dis)));
            } else {
                keyValue = IOUtil.readInt((InputStream)dis);
                super.put(keyValue, new WrapperedValue(valueStream, IOUtil.readIntList((DataInputStream)dis), offset));
            }
            ++i;
        }
    }

    @Override
    public IOrderedIntSet getKeyIndex(Object key, int searchType) throws DataException {
        ArrayList<Integer> fastSet = new ArrayList<Integer>();
        for (int i : this.getKeyIndex1(key, searchType)) {
            fastSet.add(i);
        }
        Collections.sort(fastSet);
        return new OrderedIntSet(fastSet);
    }

    public Set<Integer> getKeyIndex1(Object key, int searchType) throws DataException {
        if (searchType != 1 && searchType != 22) {
            throw new UnsupportedOperationException();
        }
        if (searchType == 1) {
            return this.getKeyIndex(key);
        }
        List candidate = (List)key;
        HashSet<Integer> result = new HashSet<Integer>();
        for (Object eachKey : candidate) {
            result.addAll(this.getKeyIndex(eachKey));
        }
        return result;
    }

    private Set<Integer> getKeyIndex(Object key) throws DataException {
        Object result = this.getWrappedKey(key);
        if (result == null) {
            return new HashSet<Integer>();
        }
        return ((WrapperedValue)result).getIndex();
    }

    public String getKeyValue(Object key) {
        Object result;
        block3: {
            try {
                result = this.getWrappedKey(key);
                if (result != null) break block3;
                return null;
            }
            catch (DataException dataException) {
                return null;
            }
        }
        return ((WrapperedValue)result).getKeyValue();
    }

    private Object getWrappedKey(Object key) throws DataException {
        Object result = null;
        if (key == null) {
            result = this.get(null);
        } else if (key instanceof String && (result = this.get(key)) == null && (result = this.get(key.hashCode())) instanceof WrapperedValue) {
            if (key.equals(((WrapperedValue)result).getKeyValue())) {
                return result;
            }
            result = null;
        }
        if (result == null) {
            result = this.get(key);
        }
        return result;
    }

    @Override
    public boolean supportFilter(int filterType) throws DataException {
        return filterType == 1 || filterType == 22;
    }

    @Override
    public Object[] getAllKeyValues() throws DataException {
        Object[] values = this.values().toArray();
        Object[] keys = new Object[values.length];
        int i = 0;
        while (i < values.length) {
            keys[i] = ((WrapperedValue)values[i]).getKeyValue();
            ++i;
        }
        return keys;
    }

    @Override
    public IOrderedIntSet getAllKeyRows() throws DataException {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Object[] values = this.values().toArray();
        int i = 0;
        while (i < values.length) {
            Iterator iterator = ((WrapperedValue)values[i]).getIndex().iterator();
            arrayList.add((Integer)iterator.next());
            ++i;
        }
        Collections.sort(arrayList);
        return new OrderedIntSet(arrayList);
    }

    private class OrderedIntSet
    implements IOrderedIntSet {
        private List values;

        public OrderedIntSet(List values) {
            this.values = values;
        }

        @Override
        public IOrderedIntSetIterator iterator() {
            return new IOrderedIntSetIterator(){
                int i = 0;

                @Override
                public boolean hasNext() {
                    return OrderedIntSet.this.values.size() <= this.i;
                }

                @Override
                public int next() {
                    int result = (Integer)OrderedIntSet.this.values.get(this.i);
                    ++this.i;
                    return result;
                }
            };
        }

        @Override
        public boolean isEmpty() {
            return this.values.isEmpty();
        }

        @Override
        public int size() {
            return this.values.size();
        }
    }

    private static class WrapperedValue {
        private long keyOffset;
        private RAInputStream keyStream;
        private Set index = new HashSet();
        private Object keyValue;

        WrapperedValue(RAInputStream keyStream, List index, long keyOffset) {
            this.keyOffset = keyOffset;
            this.keyStream = keyStream;
            this.index.addAll(index);
        }

        WrapperedValue(String keyValue, List index) {
            this.keyValue = keyValue;
            this.index.addAll(index);
        }

        public Set getIndex() {
            return this.index;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getKeyValue() throws DataException {
            Object result;
            block12: {
                try {
                    if (this.keyValue != null) {
                        if (this.keyValue instanceof String) {
                            return (String)this.keyValue;
                        }
                        if (this.keyValue instanceof SoftReference && (result = (String)((SoftReference)this.keyValue).get()) != null) {
                            return result;
                        }
                    }
                    if (this.keyStream != null) break block12;
                    return null;
                }
                catch (IOException e) {
                    throw new DataException(e.getLocalizedMessage(), e);
                }
            }
            result = this.keyStream;
            synchronized (result) {
                if (this.keyValue != null) {
                    String result2;
                    if (this.keyValue instanceof String) {
                        return (String)this.keyValue;
                    }
                    if (this.keyValue instanceof SoftReference && (result2 = (String)((SoftReference)this.keyValue).get()) != null) {
                        return result2;
                    }
                }
                this.keyStream.seek(this.keyOffset);
                this.keyValue = new SoftReference<String>(IOUtil.readString((DataInputStream)new DataInputStream((InputStream)this.keyStream)));
            }
            return (String)((SoftReference)this.keyValue).get();
        }
    }
}

