/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.aggregation.function;

import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.GregorianCalendar;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.data.engine.api.timefunction.IPeriodsFunction;
import org.eclipse.birt.data.engine.api.timefunction.TimeMember;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.function.AbstractMDX;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.function.TimeMemberUtil;

public class TrailingFunction
extends AbstractMDX
implements IPeriodsFunction {
    private String offsetLevel = "";
    private int offset = 0;
    private boolean isMoveForward = false;

    public TrailingFunction(String levelType, int offset) {
        this.offsetLevel = levelType;
        this.offset = offset;
        this.isMoveForward = offset > 0;
    }

    private Calendar adjustStartDate(Calendar curDate, String calculateUnit) {
        Calendar startDate = (Calendar)curDate.clone();
        if (calculateUnit.equals("year")) {
            if (this.isMoveForward) {
                this.setToYearStart(startDate);
            } else {
                this.setToYearEnd(startDate);
            }
        } else if (calculateUnit.equals("quarter")) {
            if (this.isMoveForward) {
                this.setToQuarterStart(startDate);
            } else {
                this.setToQuarterEnd(startDate);
            }
        } else if (calculateUnit.equals("month")) {
            if (this.isMoveForward) {
                this.setToMonthStart(startDate);
            } else {
                this.setToMonthEnd(startDate);
            }
        }
        return startDate;
    }

    private Calendar getEndDate(Calendar startDate, String calculateUnit) {
        Calendar endDate = (Calendar)startDate.clone();
        if (calculateUnit.equals("year")) {
            if (this.isMoveForward) {
                this.setToYearEnd(endDate);
            } else {
                this.setToYearStart(endDate);
            }
        } else if (calculateUnit.equals("quarter")) {
            if (this.isMoveForward) {
                this.setToQuarterEnd(endDate);
            } else {
                this.setToQuarterStart(endDate);
            }
        } else if (calculateUnit.equals("month")) {
            if (this.isMoveForward) {
                this.setToMonthEnd(endDate);
            } else {
                this.setToMonthStart(endDate);
            }
        } else if (calculateUnit.equals("week")) {
            if (this.isMoveForward) {
                this.setToWeekEnd(endDate);
            } else {
                this.setToWeekStart(endDate);
            }
        }
        if (this.offsetLevel.equals("year")) {
            endDate.add(1, this.offset);
        } else if (this.offsetLevel.equals("quarter")) {
            endDate.add(2, this.offset * 3);
        } else if (this.offsetLevel.equals("month")) {
            endDate.add(2, this.offset);
        } else if (this.offsetLevel.equals("week-of-month")) {
            endDate.add(3, this.offset);
        } else if (this.offsetLevel.equals("week-of-year")) {
            endDate.add(3, this.offset);
        } else if (this.offsetLevel.equals("day-of-month")) {
            endDate.add(5, this.offset);
        } else if (this.offsetLevel.equals("day-of-week")) {
            endDate.add(5, this.offset);
        } else if (this.offsetLevel.equals("day-of-year")) {
            endDate.add(5, this.offset);
        }
        return endDate;
    }

    private List<Calendar> moveAStep(Calendar curDate, Calendar endDate, String unit, String extraWeekLevel) {
        ArrayList<Calendar> times = new ArrayList<Calendar>();
        int step = this.isMoveForward ? 1 : -1;
        times.add((Calendar)curDate.clone());
        if (unit.equals("year")) {
            if (this.isMoveForward) {
                this.setToYearStart(curDate);
            } else {
                this.setToYearEnd(curDate);
            }
            curDate.add(1, step);
        } else if (unit.equals("quarter")) {
            if (this.isMoveForward) {
                this.setToQuarterStart(curDate);
            } else {
                this.setToQuarterEnd(curDate);
            }
            curDate.add(2, step * 3);
        } else if (unit.equals("month")) {
            if (this.isMoveForward) {
                this.setToMonthStart(curDate);
            } else {
                this.setToMonthEnd(curDate);
            }
            curDate.add(2, step);
        } else if (unit.equals("week")) {
            Calendar tmpDate = (Calendar)curDate.clone();
            if (this.isMoveForward) {
                if (extraWeekLevel != null) {
                    tmpDate.set(7, 7);
                    if (tmpDate.after((Object)endDate)) {
                        tmpDate = endDate;
                    }
                    if ((tmpDate = this.getExtraWeek(tmpDate, curDate, extraWeekLevel)) != null) {
                        times.add(tmpDate);
                    }
                }
                this.setToWeekStart(curDate);
                curDate.set(7, 1);
            } else {
                if (extraWeekLevel != null) {
                    tmpDate.set(7, 1);
                    if (tmpDate.before((Object)endDate)) {
                        tmpDate = endDate;
                    }
                    if ((tmpDate = this.getExtraWeek(tmpDate, curDate, extraWeekLevel)) != null) {
                        times.add(tmpDate);
                    }
                }
                this.setToWeekEnd(curDate);
                curDate.set(7, 7);
            }
            curDate.add(3, step);
        } else if (unit.equals("day")) {
            curDate.add(5, step);
        }
        return times;
    }

    private Calendar getExtraWeek(Calendar date1, Calendar date2, String extraWeekLevel) {
        if (extraWeekLevel.equals("week-of-month") && date1.get(2) != date2.get(2)) {
            return date1;
        }
        if (extraWeekLevel.equals("week-of-year") && date1.get(1) != date2.get(1)) {
            return date1;
        }
        return null;
    }

    @Override
    public List<TimeMember> getResult(TimeMember member) {
        ArrayList<TimeMember> timeMembers = new ArrayList<TimeMember>();
        String[] levelTypes = member.getLevelType();
        int[] startValues = member.getMemberValue();
        GregorianCalendar curDate = new GregorianCalendar(TimeMemberUtil.getTimeZone(), TimeMemberUtil.getDefaultLocale());
        curDate.clear();
        String calculateUnit = this.translateToCal((Calendar)curDate, levelTypes, startValues);
        Calendar startDate = this.adjustStartDate((Calendar)curDate, calculateUnit);
        Calendar endDate = this.getEndDate(startDate, calculateUnit);
        curDate = (Calendar)startDate.clone();
        boolean end = false;
        String extraWeekLevel = calculateUnit.equals("week") ? this.getExtraWeekLevel(levelTypes) : null;
        while (!end) {
            List<Calendar> times = this.moveAStep((Calendar)curDate, endDate, calculateUnit, extraWeekLevel);
            int i = 0;
            while (i < times.size()) {
                int[] fillDateTmp = this.getValueFromCal(times.get(i), levelTypes);
                TimeMember timeMember = new TimeMember(fillDateTmp, levelTypes);
                timeMembers.add(timeMember);
                ++i;
            }
            if (this.isMoveForward) {
                end = !curDate.before((Object)endDate);
                continue;
            }
            boolean bl = end = !curDate.after((Object)endDate);
        }
        return timeMembers;
    }

    private String getExtraWeekLevel(String[] levelTypes) {
        String result = "week-of-year";
        String[] stringArray = levelTypes;
        int n = levelTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String level = stringArray[n2];
            if (level.equals("week-of-month") || level.equals("quarter") || level.equals("month")) {
                result = "week-of-month";
            }
            ++n2;
        }
        return result;
    }

    private void setToYearStart(Calendar cal) {
        cal.set(6, 1);
    }

    private void setToYearEnd(Calendar cal) {
        this.setToYearStart(cal);
        cal.add(1, 1);
        cal.add(5, -1);
    }

    private void setToQuarterStart(Calendar cal) {
        int quarter = cal.get(2) / 3;
        cal.set(2, quarter * 3);
        cal.set(5, 1);
    }

    private void setToQuarterEnd(Calendar cal) {
        this.setToQuarterStart(cal);
        cal.add(2, 3);
        cal.add(5, -1);
    }

    private void setToMonthStart(Calendar cal) {
        cal.set(5, 1);
    }

    private void setToMonthEnd(Calendar cal) {
        this.setToMonthStart(cal);
        cal.add(2, 1);
        cal.add(5, -1);
    }

    private void setToWeekStart(Calendar cal) {
        cal.set(7, 1);
    }

    private void setToWeekEnd(Calendar cal) {
        cal.set(7, 7);
    }
}

