/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.misc;

import java.util.ArrayList;
import java.util.List;

public class PermuteArray {
    private int level = 0;
    private int[] data;
    private int[] iter;
    private int[] valk;
    private int[] ret;

    public PermuteArray(int N) {
        this.iter = new int[N];
        this.valk = new int[N];
        this.data = new int[N];
        this.ret = new int[N];
        int i = 0;
        while (i < this.data.length) {
            this.data[i] = -1;
            ++i;
        }
    }

    public int sgn() {
        int total = 0;
        int i = 0;
        while (i < this.ret.length) {
            int val = this.ret[i];
            int j = i + 1;
            while (j < this.ret.length) {
                if (val > this.ret[j]) {
                    ++total;
                }
                ++j;
            }
            ++i;
        }
        if (total % 2 == 1) {
            return -1;
        }
        return 1;
    }

    public static int fact(int N) {
        int ret = 1;
        while (N > 0) {
            ret *= N--;
        }
        return ret;
    }

    public static List<int[]> createList(int N) {
        int[] data = new int[N];
        int i = 0;
        while (i < data.length) {
            data[i] = -1;
            ++i;
        }
        ArrayList<int[]> ret = new ArrayList<int[]>();
        PermuteArray.createList(data, 0, -1, ret);
        return ret;
    }

    private static void createList(int[] data, int k, int level, List<int[]> ret) {
        data[k] = level;
        if (level < data.length - 1) {
            int i = 0;
            while (i < data.length) {
                if (data[i] == -1) {
                    PermuteArray.createList(data, i, level + 1, ret);
                }
                ++i;
            }
        } else {
            int[] copy = new int[data.length];
            System.arraycopy(data, 0, copy, 0, data.length);
            ret.add(copy);
        }
        data[k] = -1;
    }

    public int[] next() {
        boolean hasNewPerm = false;
        block0: while (this.level >= 0) {
            int i = this.iter[this.level];
            while (i < this.data.length) {
                int n = this.level++;
                this.iter[n] = this.iter[n] + 1;
                if (this.data[i] == -1) {
                    this.data[i] = this.level - 1;
                    if (this.level >= this.data.length) {
                        hasNewPerm = true;
                        System.arraycopy(this.data, 0, this.ret, 0, this.ret.length);
                        --this.level;
                        this.data[i] = -1;
                        break block0;
                    }
                    this.valk[this.level] = i;
                }
                i = this.iter[this.level];
            }
            this.data[this.valk[this.level]] = -1;
            this.iter[this.level] = 0;
            --this.level;
        }
        if (hasNewPerm) {
            return this.ret;
        }
        return null;
    }
}

