/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.io;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.impl.adt.AgedNode;
import ca.odell.glazedlists.impl.adt.AgedNodeComparator;
import ca.odell.glazedlists.impl.adt.SparseList;
import ca.odell.glazedlists.impl.adt.SparseListNode;
import ca.odell.glazedlists.impl.adt.barcode2.Element;
import ca.odell.glazedlists.impl.adt.barcode2.SimpleTree;
import ca.odell.glazedlists.util.concurrent.Lock;
import ca.odell.glazedlists.util.concurrent.ReadWriteLock;

public class CachingList
extends TransformedList {
    private SimpleTree<AgedNode> cache;
    private SparseList indexTree;
    private int cacheHits;
    private int cacheMisses;
    private int currentSize = 0;
    private int maxSize = 0;
    private int lastKnownSize = 0;

    public CachingList(EventList source, int maxSize) {
        super(source);
        this.readWriteLock = new CacheLock(this.readWriteLock);
        this.maxSize = maxSize;
        this.cache = new SimpleTree(new AgedNodeComparator());
        this.indexTree = new SparseList();
        this.indexTree.addNulls(0, source.size());
        source.addListEventListener(this);
        this.lastKnownSize = source.size();
    }

    public final int size() {
        return this.source.size();
    }

    public final Object get(int index) {
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException("cannot get from tree of size " + this.size() + " at " + index);
        }
        this.preFetch(index);
        return this.fetch(index, true);
    }

    protected final Object fetch(int index, boolean recordHitsOrMisses) {
        Object value = null;
        Element cacheNode = (Element)this.indexTree.get(index);
        if (cacheNode != null) {
            if (recordHitsOrMisses) {
                ++this.cacheHits;
            }
            AgedNode agedNode = (AgedNode)cacheNode.get();
            value = agedNode.getValue();
            this.cache.remove(cacheNode);
            SparseListNode indexNode = agedNode.getIndexNode();
            indexNode.setValue(this.cache.addInSortedOrder((byte)1, agedNode, 1));
        } else {
            if (recordHitsOrMisses) {
                ++this.cacheMisses;
            }
            if (this.currentSize >= this.maxSize) {
                Element<AgedNode> oldestInCache = this.cache.get(0);
                this.cache.remove(oldestInCache);
                AgedNode oldAgedNode = oldestInCache.get();
                SparseListNode oldIndexNode = oldAgedNode.getIndexNode();
                this.indexTree.set(oldIndexNode.getIndex(), (Object)null);
                --this.currentSize;
            }
            value = this.source.get(index);
            this.indexTree.set(index, Boolean.TRUE);
            SparseListNode indexNode = this.indexTree.getNode(index);
            AgedNode agedNode = new AgedNode(indexNode, value);
            indexNode.setValue(this.cache.addInSortedOrder((byte)1, agedNode, 1));
            ++this.currentSize;
        }
        return value;
    }

    protected void preFetch(int index) {
    }

    protected boolean isWritable() {
        return true;
    }

    public final int getCacheHits() {
        return this.cacheHits;
    }

    public final int getCacheMisses() {
        return this.cacheMisses;
    }

    public final float getCacheHitRatio() {
        if (this.cacheHits + this.cacheMisses == 0) {
            return 0.0f;
        }
        return (float)this.cacheHits / (float)(this.cacheHits + this.cacheMisses);
    }

    public final void listChanged(ListEvent listChanges) {
        this.updates.beginEvent();
        while (listChanges.next()) {
            int index = listChanges.getIndex();
            int changeType = listChanges.getType();
            Element cacheNode = null;
            if (index < this.lastKnownSize) {
                cacheNode = (Element)this.indexTree.get(index);
            }
            if (changeType == 2) {
                this.indexTree.add(index, (Object)null);
            } else if (changeType == 0) {
                if (cacheNode != null) {
                    this.cache.remove(cacheNode);
                    --this.currentSize;
                }
                this.indexTree.remove(index);
            } else if (changeType == 1 && cacheNode != null) {
                this.cache.remove(cacheNode);
                --this.currentSize;
            }
            this.updates.addChange(changeType, index);
        }
        this.lastKnownSize = this.source.size();
        this.updates.commitEvent();
    }

    private static class CacheLock
    implements ReadWriteLock {
        private ReadWriteLock sourceLock;

        public CacheLock(ReadWriteLock sourceLock) {
            this.sourceLock = sourceLock;
        }

        public Lock readLock() {
            return this.writeLock();
        }

        public Lock writeLock() {
            return this.sourceLock.writeLock();
        }
    }
}

