/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.swt.ui.support;

import org.eclipse.chemclipse.numeric.statistics.Calculations;

public class PlotSeries {
    private double[] xSeries = new double[]{0.0};
    private double[] ySeries = new double[]{0.0};
    private double xMin = 0.0;
    private double xMax = 0.0;
    private double yMin = 0.0;
    private double yMax = 0.0;

    public PlotSeries(double[] xSeries, double[] ySeries) {
        if (xSeries != null && ySeries != null) {
            this.xSeries = xSeries;
            this.ySeries = ySeries;
            this.xMax = Calculations.getMax((double[])xSeries);
            this.yMax = Calculations.getMax((double[])ySeries);
        }
    }

    public double getXMin() {
        return this.xMin;
    }

    public double getXMax() {
        return this.xMax;
    }

    public double getYMin() {
        return this.yMin;
    }

    public double getYMax() {
        return this.yMax;
    }

    public double[] getXSeries() {
        return this.xSeries;
    }

    public double[] getYSeries() {
        return this.ySeries;
    }

    public double getStartRetentionTimeInMinutes() {
        double result = this.xSeries == null || this.xSeries.length < 1 ? 0.0 : this.xSeries[0] / 60000.0;
        return result;
    }

    public double getStopRetentionTimeInMinutes() {
        double result = this.xSeries == null || this.xSeries.length < 1 ? 0.0 : this.xSeries[this.xSeries.length - 1] / 60000.0;
        return result;
    }
}

