/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.interpolation;

import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.interpolation.BicubicSplineInterpolatingFunction;
import org.apache.commons.math3.analysis.interpolation.BivariateGridInterpolator;
import org.apache.commons.math3.analysis.interpolation.SplineInterpolator;
import org.apache.commons.math3.analysis.polynomials.PolynomialSplineFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NoDataException;
import org.apache.commons.math3.exception.NonMonotonicSequenceException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.util.MathArrays;

@Deprecated
public class BicubicSplineInterpolator
implements BivariateGridInterpolator {
    private final boolean initializeDerivatives;

    public BicubicSplineInterpolator() {
        this(false);
    }

    public BicubicSplineInterpolator(boolean initializeDerivatives) {
        this.initializeDerivatives = initializeDerivatives;
    }

    @Override
    public BicubicSplineInterpolatingFunction interpolate(double[] xval, double[] yval, double[][] fval) throws NoDataException, DimensionMismatchException, NonMonotonicSequenceException, NumberIsTooSmallException {
        if (xval.length == 0 || yval.length == 0 || fval.length == 0) {
            throw new NoDataException();
        }
        if (xval.length != fval.length) {
            throw new DimensionMismatchException(xval.length, fval.length);
        }
        MathArrays.checkOrder(xval);
        MathArrays.checkOrder(yval);
        int xLen = xval.length;
        int yLen = yval.length;
        double[][] fX = new double[yLen][xLen];
        int i = 0;
        while (i < xLen) {
            if (fval[i].length != yLen) {
                throw new DimensionMismatchException(fval[i].length, yLen);
            }
            int j = 0;
            while (j < yLen) {
                fX[j][i] = fval[i][j];
                ++j;
            }
            ++i;
        }
        SplineInterpolator spInterpolator = new SplineInterpolator();
        PolynomialSplineFunction[] ySplineX = new PolynomialSplineFunction[yLen];
        int j = 0;
        while (j < yLen) {
            ySplineX[j] = spInterpolator.interpolate(xval, fX[j]);
            ++j;
        }
        PolynomialSplineFunction[] xSplineY = new PolynomialSplineFunction[xLen];
        int i2 = 0;
        while (i2 < xLen) {
            xSplineY[i2] = spInterpolator.interpolate(yval, fval[i2]);
            ++i2;
        }
        double[][] dFdX = new double[xLen][yLen];
        int j2 = 0;
        while (j2 < yLen) {
            UnivariateFunction f = ySplineX[j2].derivative();
            int i3 = 0;
            while (i3 < xLen) {
                dFdX[i3][j2] = f.value(xval[i3]);
                ++i3;
            }
            ++j2;
        }
        double[][] dFdY = new double[xLen][yLen];
        int i4 = 0;
        while (i4 < xLen) {
            UnivariateFunction f = xSplineY[i4].derivative();
            int j3 = 0;
            while (j3 < yLen) {
                dFdY[i4][j3] = f.value(yval[j3]);
                ++j3;
            }
            ++i4;
        }
        double[][] d2FdXdY = new double[xLen][yLen];
        int i5 = 0;
        while (i5 < xLen) {
            int nI = this.nextIndex(i5, xLen);
            int pI = this.previousIndex(i5);
            int j4 = 0;
            while (j4 < yLen) {
                int nJ = this.nextIndex(j4, yLen);
                int pJ = this.previousIndex(j4);
                d2FdXdY[i5][j4] = (fval[nI][nJ] - fval[nI][pJ] - fval[pI][nJ] + fval[pI][pJ]) / ((xval[nI] - xval[pI]) * (yval[nJ] - yval[pJ]));
                ++j4;
            }
            ++i5;
        }
        return new BicubicSplineInterpolatingFunction(xval, yval, fval, dFdX, dFdY, d2FdXdY, this.initializeDerivatives);
    }

    private int nextIndex(int i, int max) {
        int index = i + 1;
        return index < max ? index : index - 1;
    }

    private int previousIndex(int i) {
        int index = i - 1;
        return index >= 0 ? index : 0;
    }
}

