/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.linsol.qr;

import org.ejml.alg.dense.decompose.CTriangularSolver;
import org.ejml.alg.dense.decompose.qr.QRDecompositionHouseholderColumn_CD64;
import org.ejml.alg.dense.decompose.qr.QrHelperFunctions_CD64;
import org.ejml.alg.dense.linsol.LinearSolverAbstract_CD64;
import org.ejml.data.CDenseMatrix64F;
import org.ejml.ops.CSpecializedOps;

public class LinearSolverQrHouseCol_CD64
extends LinearSolverAbstract_CD64 {
    private QRDecompositionHouseholderColumn_CD64 decomposer;
    private CDenseMatrix64F a = new CDenseMatrix64F(1, 1);
    private CDenseMatrix64F temp = new CDenseMatrix64F(1, 1);
    protected int maxRows = -1;
    protected int maxCols = -1;
    private double[][] QR;
    private CDenseMatrix64F R = new CDenseMatrix64F(1, 1);
    private double[] gammas;

    public LinearSolverQrHouseCol_CD64() {
        this.decomposer = new QRDecompositionHouseholderColumn_CD64();
    }

    public void setMaxSize(int maxRows, int maxCols) {
        this.maxRows = maxRows;
        this.maxCols = maxCols;
    }

    @Override
    public boolean setA(CDenseMatrix64F A) {
        if (A.numRows < A.numCols) {
            throw new IllegalArgumentException("Can't solve for wide systems.  More variables than equations.");
        }
        if (A.numRows > this.maxRows || A.numCols > this.maxCols) {
            this.setMaxSize(A.numRows, A.numCols);
        }
        this.R.reshape(A.numCols, A.numCols);
        this.a.reshape(A.numRows, 1);
        this.temp.reshape(A.numRows, 1);
        this._setA(A);
        if (!this.decomposer.decompose(A)) {
            return false;
        }
        this.gammas = this.decomposer.getGammas();
        this.QR = this.decomposer.getQR();
        this.decomposer.getR(this.R, true);
        return true;
    }

    @Override
    public double quality() {
        return CSpecializedOps.qualityTriangular(this.R);
    }

    @Override
    public void solve(CDenseMatrix64F B, CDenseMatrix64F X) {
        if (X.numRows != this.numCols) {
            throw new IllegalArgumentException("Unexpected dimensions for X: X rows = " + X.numRows + " expected = " + this.numCols);
        }
        if (B.numRows != this.numRows || B.numCols != X.numCols) {
            throw new IllegalArgumentException("Unexpected dimensions for B");
        }
        int BnumCols = B.numCols;
        int colB = 0;
        while (colB < BnumCols) {
            int indexB;
            int i = 0;
            while (i < this.numRows) {
                indexB = (i * BnumCols + colB) * 2;
                this.a.data[i * 2] = B.data[indexB];
                this.a.data[i * 2 + 1] = B.data[indexB + 1];
                ++i;
            }
            int n = 0;
            while (n < this.numCols) {
                double[] u = this.QR[n];
                double realVV = u[n * 2];
                double imagVV = u[n * 2 + 1];
                u[n * 2] = 1.0;
                u[n * 2 + 1] = 0.0;
                QrHelperFunctions_CD64.rank1UpdateMultR(this.a, u, 0, this.gammas[n], 0, n, this.numRows, this.temp.data);
                u[n * 2] = realVV;
                u[n * 2 + 1] = imagVV;
                ++n;
            }
            CTriangularSolver.solveU(this.R.data, this.a.data, this.numCols);
            i = 0;
            while (i < this.numCols) {
                indexB = (i * BnumCols + colB) * 2;
                X.data[indexB] = this.a.data[i * 2];
                X.data[indexB + 1] = this.a.data[i * 2 + 1];
                ++i;
            }
            ++colB;
        }
    }

    @Override
    public boolean modifiesA() {
        return false;
    }

    @Override
    public boolean modifiesB() {
        return false;
    }

    @Override
    public QRDecompositionHouseholderColumn_CD64 getDecomposition() {
        return this.decomposer;
    }
}

