/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.identifier.library;

import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.identifier.exceptions.NoIdentifierAvailableException;
import org.eclipse.chemclipse.chromatogram.msd.identifier.library.ILibraryService;
import org.eclipse.chemclipse.chromatogram.msd.identifier.library.ILibraryServiceSupport;
import org.eclipse.chemclipse.chromatogram.msd.identifier.library.LibraryServiceSupplier;
import org.eclipse.chemclipse.chromatogram.msd.identifier.library.LibraryServiceSupport;
import org.eclipse.chemclipse.chromatogram.msd.identifier.processing.ILibraryServiceProcessingInfo;
import org.eclipse.chemclipse.chromatogram.msd.identifier.processing.LibraryServiceProcessingInfo;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.msd.model.core.IMassSpectra;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.MessageType;
import org.eclipse.chemclipse.processing.core.ProcessingMessage;
import org.eclipse.chemclipse.processing.core.exceptions.TypeCastException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;

public class LibraryService {
    private static final Logger logger = Logger.getLogger(LibraryService.class);
    private static final String EXTENSION_POINT = "org.eclipse.chemclipse.chromatogram.msd.identifier.libraryService";
    private static final String NO_IDENTIFIER_AVAILABLE = "There is no suitable library service available";

    private LibraryService() {
    }

    public static ILibraryServiceProcessingInfo identify(IIdentificationTarget identificationTarget, String identifierId, IProgressMonitor monitor) {
        ILibraryService libraryService = LibraryService.getLibraryService(identifierId);
        ILibraryServiceProcessingInfo processingInfo = libraryService != null ? libraryService.identify(identificationTarget, monitor) : LibraryService.getNoIdentifierAvailableProcessingInfo();
        return processingInfo;
    }

    public static ILibraryServiceProcessingInfo identify(IIdentificationTarget identificationTarget, IProgressMonitor monitor) {
        ILibraryServiceProcessingInfo processingInfo = new LibraryServiceProcessingInfo();
        ILibraryServiceSupport libraryServiceSupport = LibraryService.getLibraryServiceSupport();
        try {
            List<String> availableIdentifierIds = libraryServiceSupport.getAvailableIdentifierIds();
            IMassSpectra massSpectra = null;
            for (String identifierId : availableIdentifierIds) {
                ILibraryService libraryService = LibraryService.getLibraryService(identifierId);
                if (libraryService == null) continue;
                try {
                    processingInfo = libraryService.identify(identificationTarget, monitor);
                    massSpectra = processingInfo.getMassSpectra();
                    if (massSpectra.size() <= 0) continue;
                    break;
                }
                catch (TypeCastException typeCastException) {}
            }
            if (massSpectra == null || massSpectra.size() == 0) {
                processingInfo = LibraryService.getNoIdentifierAvailableProcessingInfo();
            }
        }
        catch (NoIdentifierAvailableException noIdentifierAvailableException) {
            processingInfo = LibraryService.getNoIdentifierAvailableProcessingInfo();
        }
        return processingInfo;
    }

    public static ILibraryServiceSupport getLibraryServiceSupport() {
        IConfigurationElement[] extensions;
        LibraryServiceSupport identifierSupport = new LibraryServiceSupport();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensions = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            LibraryServiceSupplier supplier = new LibraryServiceSupplier();
            supplier.setId(element.getAttribute("id"));
            supplier.setDescription(element.getAttribute("description"));
            supplier.setIdentifierName(element.getAttribute("identifierName"));
            identifierSupport.add(supplier);
            ++n2;
        }
        return identifierSupport;
    }

    private static ILibraryService getLibraryService(String identifierId) {
        IConfigurationElement element = LibraryService.getConfigurationElement(identifierId);
        ILibraryService instance = null;
        if (element != null) {
            try {
                instance = (ILibraryService)element.createExecutableExtension("identifier");
            }
            catch (CoreException e) {
                logger.warn((Object)e);
            }
        }
        return instance;
    }

    private static IConfigurationElement getConfigurationElement(String filterId) {
        IConfigurationElement[] elements;
        if ("".equals(filterId)) {
            return null;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getAttribute("id").equals(filterId)) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    private static ILibraryServiceProcessingInfo getNoIdentifierAvailableProcessingInfo() {
        LibraryServiceProcessingInfo processingInfo = new LibraryServiceProcessingInfo();
        ProcessingMessage processingMessage = new ProcessingMessage(MessageType.ERROR, "Library Service", NO_IDENTIFIER_AVAILABLE);
        processingInfo.addMessage((IProcessingMessage)processingMessage);
        return processingInfo;
    }
}

