/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import org.eclipse.chemclipse.chromatogram.msd.process.model.IChromatogramProcessEntry;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.io.IBatchProcessJobWriter;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.model.IBatchProcessJob;
import org.eclipse.chemclipse.chromatogram.xxd.report.model.IChromatogramReportSupplierEntry;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotWriteableException;
import org.eclipse.chemclipse.converter.model.IChromatogramInputEntry;
import org.eclipse.chemclipse.converter.model.IChromatogramOutputEntry;
import org.eclipse.core.runtime.IProgressMonitor;

public class BatchProcessJobWriter
implements IBatchProcessJobWriter {
    @Override
    public void writeBatchProcessJob(File file, IBatchProcessJob batchProcessJob, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotWriteableException, IOException, XMLStreamException {
        XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        XMLEventWriter eventWriter = xmlOutputFactory.createXMLEventWriter(bufferedOutputStream, "UTF-8");
        XMLEventFactory eventFactory = XMLEventFactory.newInstance();
        eventWriter.add(eventFactory.createStartDocument());
        StartElement chromatogramStart = eventFactory.createStartElement("", "", "BatchProcessJob");
        eventWriter.add(chromatogramStart);
        this.writeBatchProcessJobHeader(eventWriter, eventFactory, batchProcessJob);
        this.writeComment(eventWriter, eventFactory, "Load the following chromatograms.");
        this.writeChromatogramInputEntries(eventWriter, eventFactory, batchProcessJob.getChromatogramInputEntries());
        this.writeComment(eventWriter, eventFactory, "Process each chromatogram with the listed methods.");
        this.writeChromatogramProcessEntries(eventWriter, eventFactory, batchProcessJob.getChromatogramProcessEntries());
        this.writeComment(eventWriter, eventFactory, "Write each processed chromatogram to the given output formats.");
        this.writeChromatogramOutputEntries(eventWriter, eventFactory, batchProcessJob.getChromatogramOutputEntries());
        this.writeComment(eventWriter, eventFactory, "Process each chromatogram with the listed report suppliers.");
        this.writeChromatogramReportEntries(eventWriter, eventFactory, batchProcessJob.getChromatogramReportEntries());
        EndElement chromatogramEnd = eventFactory.createEndElement("", "", "BatchProcessJob");
        eventWriter.add(chromatogramEnd);
        eventWriter.add(eventFactory.createEndDocument());
        bufferedOutputStream.flush();
        eventWriter.flush();
        bufferedOutputStream.close();
        eventWriter.close();
    }

    private void writeComment(XMLEventWriter eventWriter, XMLEventFactory eventFactory, String comment) throws XMLStreamException {
        Comment batchJobInfo = eventFactory.createComment(comment);
        eventWriter.add(batchJobInfo);
    }

    private void writeBatchProcessJobHeader(XMLEventWriter eventWriter, XMLEventFactory eventFactory, IBatchProcessJob batchProcessJob) throws XMLStreamException {
        StartElement headerStart = eventFactory.createStartElement("", "", "Header");
        EndElement headerEnd = eventFactory.createEndElement("", "", "Header");
        eventWriter.add(headerStart);
        eventWriter.add(headerEnd);
    }

    private void writeChromatogramInputEntries(XMLEventWriter eventWriter, XMLEventFactory eventFactory, List<IChromatogramInputEntry> inputEntries) throws XMLStreamException {
        StartElement entriesStart = eventFactory.createStartElement("", "", "InputEntries");
        EndElement entriesEnd = eventFactory.createEndElement("", "", "InputEntries");
        eventWriter.add(entriesStart);
        for (IChromatogramInputEntry inputEntry : inputEntries) {
            this.writeChromatogramInputEntry(eventWriter, eventFactory, inputEntry);
        }
        eventWriter.add(entriesEnd);
    }

    private void writeChromatogramInputEntry(XMLEventWriter eventWriter, XMLEventFactory eventFactory, IChromatogramInputEntry inputEntry) throws XMLStreamException {
        StartElement entryStart = eventFactory.createStartElement("", "", "InputEntry");
        EndElement entryEnd = eventFactory.createEndElement("", "", "InputEntry");
        Characters inputFile = eventFactory.createCData(inputEntry.getInputFile());
        eventWriter.add(entryStart);
        eventWriter.add(inputFile);
        eventWriter.add(entryEnd);
    }

    private void writeChromatogramProcessEntries(XMLEventWriter eventWriter, XMLEventFactory eventFactory, List<IChromatogramProcessEntry> processEntries) throws XMLStreamException {
        StartElement entriesStart = eventFactory.createStartElement("", "", "ProcessEntries");
        EndElement entriesEnd = eventFactory.createEndElement("", "", "ProcessEntries");
        eventWriter.add(entriesStart);
        for (IChromatogramProcessEntry processEntry : processEntries) {
            this.writeChromatogramProcessEntry(eventWriter, eventFactory, processEntry);
        }
        eventWriter.add(entriesEnd);
    }

    private void writeChromatogramProcessEntry(XMLEventWriter eventWriter, XMLEventFactory eventFactory, IChromatogramProcessEntry processEntry) throws XMLStreamException {
        StartElement entryStart = eventFactory.createStartElement("", "", "ProcessEntry");
        EndElement entryEnd = eventFactory.createEndElement("", "", "ProcessEntry");
        Attribute processorType = eventFactory.createAttribute("processorType", processEntry.getProcessCategory());
        Attribute processorId = eventFactory.createAttribute("processorId", processEntry.getProcessorId());
        eventWriter.add(entryStart);
        eventWriter.add(processorType);
        eventWriter.add(processorId);
        eventWriter.add(entryEnd);
    }

    private void writeChromatogramOutputEntries(XMLEventWriter eventWriter, XMLEventFactory eventFactory, List<IChromatogramOutputEntry> outputEntries) throws XMLStreamException {
        StartElement entriesStart = eventFactory.createStartElement("", "", "OutputEntries");
        EndElement entriesEnd = eventFactory.createEndElement("", "", "OutputEntries");
        eventWriter.add(entriesStart);
        for (IChromatogramOutputEntry outputEntry : outputEntries) {
            this.writeChromatogramOutputEntry(eventWriter, eventFactory, outputEntry);
        }
        eventWriter.add(entriesEnd);
    }

    private void writeChromatogramOutputEntry(XMLEventWriter eventWriter, XMLEventFactory eventFactory, IChromatogramOutputEntry outputEntry) throws XMLStreamException {
        StartElement entryStart = eventFactory.createStartElement("", "", "OutputEntry");
        EndElement entryEnd = eventFactory.createEndElement("", "", "OutputEntry");
        Attribute converterId = eventFactory.createAttribute("converterId", outputEntry.getConverterId());
        Characters outputFolder = eventFactory.createCData(outputEntry.getOutputFolder());
        eventWriter.add(entryStart);
        eventWriter.add(converterId);
        eventWriter.add(outputFolder);
        eventWriter.add(entryEnd);
    }

    private void writeChromatogramReportEntries(XMLEventWriter eventWriter, XMLEventFactory eventFactory, List<IChromatogramReportSupplierEntry> reportEntries) throws XMLStreamException {
        StartElement entriesStart = eventFactory.createStartElement("", "", "ReportEntries");
        EndElement entriesEnd = eventFactory.createEndElement("", "", "ReportEntries");
        eventWriter.add(entriesStart);
        for (IChromatogramReportSupplierEntry reportEntry : reportEntries) {
            this.writeChromatogramReportEntry(eventWriter, eventFactory, reportEntry);
        }
        eventWriter.add(entriesEnd);
    }

    private void writeChromatogramReportEntry(XMLEventWriter eventWriter, XMLEventFactory eventFactory, IChromatogramReportSupplierEntry reportEntry) throws XMLStreamException {
        StartElement entryStart = eventFactory.createStartElement("", "", "ReportEntry");
        EndElement entryEnd = eventFactory.createEndElement("", "", "ReportEntry");
        Attribute converterId = eventFactory.createAttribute("reportSupplierId", reportEntry.getReportSupplierId());
        Characters reportFolderOrFile = eventFactory.createCData(reportEntry.getReportFolderOrFile());
        eventWriter.add(entryStart);
        eventWriter.add(converterId);
        eventWriter.add(reportFolderOrFile);
        eventWriter.add(entryEnd);
    }
}

