/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.chemclipse.internal.io;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipFile;
import org.eclipse.chemclipse.converter.exceptions.FileIsEmptyException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotReadableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.core.IPeakIntensityValues;
import org.eclipse.chemclipse.model.core.IPeaks;
import org.eclipse.chemclipse.model.core.PeakType;
import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.model.exceptions.PeakException;
import org.eclipse.chemclipse.model.exceptions.ReferenceMustNotBeNullException;
import org.eclipse.chemclipse.model.identifier.IComparisonResult;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.model.identifier.PeakComparisonResult;
import org.eclipse.chemclipse.model.identifier.PeakLibraryInformation;
import org.eclipse.chemclipse.model.implementation.PeakIntensityValues;
import org.eclipse.chemclipse.model.implementation.Peaks;
import org.eclipse.chemclipse.model.targets.IPeakTarget;
import org.eclipse.chemclipse.model.targets.PeakTarget;
import org.eclipse.chemclipse.msd.converter.io.IPeakReader;
import org.eclipse.chemclipse.msd.converter.processing.peak.IPeakImportConverterProcessingInfo;
import org.eclipse.chemclipse.msd.converter.processing.peak.PeakImportConverterProcessingInfo;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.internal.io.AbstractZipReader;
import org.eclipse.chemclipse.msd.converter.supplier.chemclipse.model.chromatogram.VendorIon;
import org.eclipse.chemclipse.msd.model.core.IIntegrationEntryMSD;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IPeakModelMSD;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;
import org.eclipse.chemclipse.msd.model.implementation.IntegrationEntryMSD;
import org.eclipse.chemclipse.msd.model.implementation.PeakMSD;
import org.eclipse.chemclipse.msd.model.implementation.PeakMassSpectrum;
import org.eclipse.chemclipse.msd.model.implementation.PeakModelMSD;
import org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.internal.support.MassSpectrometer;
import org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.internal.support.MassSpectrumType;
import org.eclipse.core.runtime.IProgressMonitor;

public class PeakReader_0701
extends AbstractZipReader
implements IPeakReader {
    private static final Logger logger = Logger.getLogger(PeakReader_0701.class);

    public IPeakImportConverterProcessingInfo read(File file, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        PeakImportConverterProcessingInfo processingInfo = new PeakImportConverterProcessingInfo();
        try (ZipFile zipFile = new ZipFile(file);){
            IPeaks peaks = this.readPeaksFromZipFile(zipFile, monitor);
            processingInfo.setPeaks(peaks);
        }
        return processingInfo;
    }

    private IPeaks readPeaksFromZipFile(ZipFile zipFile, IProgressMonitor monitor) throws IOException {
        Peaks peaks = new Peaks();
        DataInputStream dataInputStream = this.getDataInputStream(zipFile, "CHROMATOGRAM/PEAKS");
        int numberOfPeaks = dataInputStream.readInt();
        int i = 1;
        while (i <= numberOfPeaks) {
            monitor.subTask("Import Peak: " + i);
            try {
                IPeakMSD peak = this.readPeak(dataInputStream, monitor);
                peaks.addPeak((IPeak)peak);
            }
            catch (IllegalArgumentException e) {
                logger.warn((Object)e);
            }
            catch (PeakException e) {
                logger.warn((Object)e);
            }
            ++i;
        }
        dataInputStream.close();
        return peaks;
    }

    private IPeakMSD readPeak(DataInputStream dataInputStream, IProgressMonitor monitor) throws IOException, IllegalArgumentException, PeakException {
        String detectorDescription = this.readString(dataInputStream);
        String integratorDescription = this.readString(dataInputStream);
        String modelDescription = this.readString(dataInputStream);
        PeakType peakType = PeakType.valueOf((String)this.readString(dataInputStream));
        float startBackgroundAbundance = dataInputStream.readFloat();
        float stopBackgroundAbundance = dataInputStream.readFloat();
        IPeakMassSpectrum peakMaximum = this.readPeakMassSpectrum(dataInputStream);
        int numberOfRetentionTimes = dataInputStream.readInt();
        PeakIntensityValues intensityValues = new PeakIntensityValues(Float.MAX_VALUE);
        int i = 1;
        while (i <= numberOfRetentionTimes) {
            int retentionTime = dataInputStream.readInt();
            float relativeIntensity = dataInputStream.readFloat();
            intensityValues.addIntensityValue(retentionTime, relativeIntensity);
            ++i;
        }
        intensityValues.normalize();
        PeakModelMSD peakModel = new PeakModelMSD(peakMaximum, (IPeakIntensityValues)intensityValues, startBackgroundAbundance, stopBackgroundAbundance);
        PeakMSD peak = new PeakMSD((IPeakModelMSD)peakModel);
        peak.setDetectorDescription(detectorDescription);
        peak.setIntegratorDescription(integratorDescription);
        peak.setModelDescription(modelDescription);
        peak.setPeakType(peakType);
        List<IIntegrationEntryMSD> integrationEntries = this.readIntegrationEntries(dataInputStream);
        peak.setIntegratedArea(integrationEntries, integratorDescription);
        this.readPeakIdentificationTargets(dataInputStream, (IPeakMSD)peak, monitor);
        return peak;
    }

    private IPeakMassSpectrum readPeakMassSpectrum(DataInputStream dataInputStream) throws IOException {
        String massSpectrometer = this.readString(dataInputStream);
        String massSpectrumType = this.readString(dataInputStream);
        PeakMassSpectrum massSpectrum = new PeakMassSpectrum();
        massSpectrum.setMassSpectrometer(this.getMassSpectrometerValue(massSpectrometer));
        massSpectrum.setMassSpectrumType(this.getMassSpectrumTypeValue(massSpectrumType));
        int retentionTime = dataInputStream.readInt();
        float retentionIndex = dataInputStream.readFloat();
        massSpectrum.setRetentionTime(retentionTime);
        massSpectrum.setRetentionIndex(retentionIndex);
        int numberOfIons = dataInputStream.readInt();
        int i = 1;
        while (i <= numberOfIons) {
            try {
                double mz = dataInputStream.readDouble();
                float abundance = dataInputStream.readFloat();
                VendorIon ion = new VendorIon(mz, abundance);
                massSpectrum.addIon((IIon)ion);
            }
            catch (AbundanceLimitExceededException e) {
                logger.warn((Object)e);
            }
            catch (IonLimitExceededException e) {
                logger.warn((Object)e);
            }
            ++i;
        }
        return massSpectrum;
    }

    private List<IIntegrationEntryMSD> readIntegrationEntries(DataInputStream dataInputStream) throws IOException {
        ArrayList<IIntegrationEntryMSD> integrationEntries = new ArrayList<IIntegrationEntryMSD>();
        int numberOfIntegrationEntries = dataInputStream.readInt();
        int i = 1;
        while (i <= numberOfIntegrationEntries) {
            double ion = dataInputStream.readDouble();
            double integratedArea = dataInputStream.readDouble();
            IntegrationEntryMSD integrationEntry = new IntegrationEntryMSD(ion, integratedArea);
            integrationEntries.add((IIntegrationEntryMSD)integrationEntry);
            ++i;
        }
        return integrationEntries;
    }

    private void readPeakIdentificationTargets(DataInputStream dataInputStream, IPeakMSD peak, IProgressMonitor monitor) throws IOException {
        int numberOfPeakTargets = dataInputStream.readInt();
        int i = 1;
        while (i <= numberOfPeakTargets) {
            String identifier = this.readString(dataInputStream);
            String casNumber = this.readString(dataInputStream);
            String comments = this.readString(dataInputStream);
            String miscellaneous = this.readString(dataInputStream);
            String name = this.readString(dataInputStream);
            float matchFactor = dataInputStream.readFloat();
            float reverseMatchFactor = dataInputStream.readFloat();
            float probability = dataInputStream.readFloat();
            PeakLibraryInformation libraryInformation = new PeakLibraryInformation();
            libraryInformation.setCasNumber(casNumber);
            libraryInformation.setComments(comments);
            libraryInformation.setMiscellaneous(miscellaneous);
            libraryInformation.setName(name);
            PeakComparisonResult comparisonResult = new PeakComparisonResult(matchFactor, reverseMatchFactor, 0.0f, 0.0f, probability);
            try {
                PeakTarget identificationEntry = new PeakTarget((ILibraryInformation)libraryInformation, (IComparisonResult)comparisonResult);
                identificationEntry.setIdentifier(identifier);
                peak.addTarget((IPeakTarget)identificationEntry);
            }
            catch (ReferenceMustNotBeNullException e) {
                logger.warn((Object)e);
            }
            ++i;
        }
    }

    private short getMassSpectrometerValue(String massSpectrometer) {
        MassSpectrometer detector = MassSpectrometer.valueOf(massSpectrometer);
        int value = 1;
        if (detector == MassSpectrometer.MS2) {
            value = 2;
        } else if (detector == MassSpectrometer.MS3) {
            value = 3;
        }
        return (short)value;
    }

    private short getMassSpectrumTypeValue(String massSpectrumType) {
        MassSpectrumType msType = MassSpectrumType.valueOf(massSpectrumType);
        short value = 0;
        if (msType == MassSpectrumType.PROFILE) {
            value = 1;
        }
        return value;
    }
}

