/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.rcp.app.ui.addons;

import java.util.Collection;
import javax.annotation.PostConstruct;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class ModelSupportAddon {
    private static MApplication mApplication;
    private static EModelService eModelService;
    private static EPartService ePartService;
    private static IEventBroker eventBroker;
    private static IEclipseContext eclipseContext;

    @PostConstruct
    public void postConstruct(MApplication application, EModelService modelService, EPartService partService, IEventBroker broker, IEclipseContext context) {
        mApplication = application;
        eModelService = modelService;
        ePartService = partService;
        eventBroker = broker;
        eclipseContext = context;
    }

    public static MApplication getApplication() {
        return mApplication;
    }

    public static EModelService getModelService() {
        return eModelService;
    }

    public static EPartService getPartService() {
        return ePartService;
    }

    public static IEventBroker getEventBroker() {
        return eventBroker;
    }

    public static IEclipseContext getEclipseContext() {
        return eclipseContext;
    }

    public static void removeEditorsFromPartStack() {
        if (mApplication != null && eModelService != null && ePartService != null) {
            MPartStack partStack = (MPartStack)eModelService.find("org.eclipse.e4.primaryDataStack", (MUIElement)mApplication);
            Collection parts = ePartService.getParts();
            for (MPart part : parts) {
                if (part.getObject() == null) continue;
                part.setToBeRendered(false);
                part.setVisible(false);
                partStack.getChildren().remove(part);
            }
        }
    }

    public static boolean saveDirtyParts() {
        return ePartService.saveAll(true);
    }
}

