/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.converter.supplier.mzml.internal.io;

import java.util.HashMap;
import java.util.Map;

public class ChromatogramSupport {
    private double parentIon;
    private double collisionEnergy;
    private double daughterIon;
    private Map<Integer, Float> retentionTimeIntensities = new HashMap<Integer, Float>();

    public ChromatogramSupport(Number[] numbersRetentionTimeInMinutes, Number[] numbersIntensity) {
        int size = numbersRetentionTimeInMinutes.length;
        int i = 0;
        while (i < size) {
            int retentionTime = (int)(numbersRetentionTimeInMinutes[i].doubleValue() * 60000.0);
            float intensity = numbersIntensity[i].floatValue();
            this.retentionTimeIntensities.put(retentionTime, Float.valueOf(intensity));
            ++i;
        }
    }

    public double getParentIon() {
        return this.parentIon;
    }

    public void setParentIon(double parentIon) {
        this.parentIon = parentIon;
    }

    public double getCollisionEnergy() {
        return this.collisionEnergy;
    }

    public void setCollisionEnergy(double collisionEnergy) {
        this.collisionEnergy = collisionEnergy;
    }

    public double getDaughterIon() {
        return this.daughterIon;
    }

    public void setDaughterIon(double daughterIon) {
        this.daughterIon = daughterIon;
    }

    public Map<Integer, Float> getRetentionTimeIntensities() {
        return this.retentionTimeIntensities;
    }
}

