/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.comparison.massspectrum;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.comparison.exceptions.NoMassSpectrumComparatorAvailableException;
import org.eclipse.chemclipse.chromatogram.msd.comparison.massspectrum.IMassSpectrumComparatorSupport;
import org.eclipse.chemclipse.chromatogram.msd.comparison.massspectrum.IMassSpectrumComparisonSupplier;

public class MassSpectrumComparatorSupport
implements IMassSpectrumComparatorSupport {
    private List<IMassSpectrumComparisonSupplier> suppliers = new ArrayList<IMassSpectrumComparisonSupplier>();

    protected void add(IMassSpectrumComparisonSupplier supplier) {
        this.suppliers.add(supplier);
    }

    @Override
    public String getConverterId(int index) throws NoMassSpectrumComparatorAvailableException {
        this.areConvertersStored();
        if (index < 0 || index > this.suppliers.size() - 1) {
            throw new NoMassSpectrumComparatorAvailableException("There is no mass spectrum comparator available with the following id: " + index + ".");
        }
        IMassSpectrumComparisonSupplier supplier = this.suppliers.get(index);
        return supplier.getId();
    }

    @Override
    public IMassSpectrumComparisonSupplier getMassSpectrumComparisonSupplier(String converterId) throws NoMassSpectrumComparatorAvailableException {
        IMassSpectrumComparisonSupplier comparisonSupplier = null;
        this.areConvertersStored();
        if (converterId == null || converterId.equals("")) {
            throw new NoMassSpectrumComparatorAvailableException("There is no mass spectrum comparator available with the following id: " + converterId + ".");
        }
        for (IMassSpectrumComparisonSupplier supplier : this.suppliers) {
            if (!supplier.getId().equals(converterId)) continue;
            comparisonSupplier = supplier;
            break;
        }
        if (comparisonSupplier == null) {
            throw new NoMassSpectrumComparatorAvailableException("There is no mass spectrum comparator available with the following id: " + converterId + ".");
        }
        return comparisonSupplier;
    }

    @Override
    public List<String> getAvailableComparatorIds() throws NoMassSpectrumComparatorAvailableException {
        this.areConvertersStored();
        ArrayList<String> availableConverters = new ArrayList<String>();
        for (IMassSpectrumComparisonSupplier supplier : this.suppliers) {
            availableConverters.add(supplier.getId());
        }
        return availableConverters;
    }

    @Override
    public String[] getComparatorNames() throws NoMassSpectrumComparatorAvailableException {
        this.areConvertersStored();
        ArrayList<String> comparatorNames = new ArrayList<String>();
        for (IMassSpectrumComparisonSupplier supplier : this.suppliers) {
            comparatorNames.add(supplier.getComparatorName());
        }
        return comparatorNames.toArray(new String[comparatorNames.size()]);
    }

    private void areConvertersStored() throws NoMassSpectrumComparatorAvailableException {
        if (this.suppliers.size() < 1) {
            throw new NoMassSpectrumComparatorAvailableException();
        }
    }
}

