/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.viewsupport;

import java.net.URISyntaxException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementLinks;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.viewers.StyledString;

public class BindingLinkedLabelComposer
extends JavaElementLinks.JavaElementLinkedLabelComposer {
    private static final String PARAMETER_ELLIPSIS_LABEL = "(...)";
    private static final String ANON_TYPE_TAIL = "() {...}";
    private static final String LAMBDA_LABEL = "() -&gt; {...}";
    private static final String MISSING_LABEL = "MISSING";
    private static final String INIT_NAME = "";
    private static final long M_ALL_QUALIFIED = 129L;
    private static final long IS_POST_QUALIFICATION = Long.MIN_VALUE;
    private static final long TP_BOUNDS = 0x4000000000000000L;
    private IJavaElement fEnclosingElement;
    private boolean fIsFromSource;

    public BindingLinkedLabelComposer(IJavaElement enclosingElement, StringBuffer buffer, boolean isFromSource) {
        super(enclosingElement, buffer);
        this.fEnclosingElement = enclosingElement;
        this.fIsFromSource = isFromSource;
    }

    public void appendBindingLabel(IBinding binding, long flags) {
        switch (binding.getKind()) {
            case 4: {
                this.appendMethodBindingLabel((IMethodBinding)binding, flags);
                return;
            }
            case 2: {
                this.appendTypeBindingLabel((ITypeBinding)binding, flags | 0x4000000000000000L);
                return;
            }
            case 3: {
                this.appendVariableLabel((IVariableBinding)binding, flags);
                return;
            }
            case 1: {
                this.appendPackageLabel((IPackageBinding)binding, flags);
            }
        }
    }

    private void appendMethodBindingLabel(IMethodBinding method, long flags) {
        ITypeBinding[] typeParameters;
        long qualificationFlags = flags & (0x1002000000000L | JavaElementLabels.ALL_FULLY_QUALIFIED | 0x80000L);
        qualificationFlags |= 0x4000000000000000L;
        if (BindingLinkedLabelComposer.getFlag(flags, 0x100000L)) {
            flags |= 0x100L;
        }
        flags &= 0xBFFFFFFFFFEFFFFFL;
        IMethodBinding origMethod = method;
        IBinding declaringMember = method.getDeclaringMember();
        if (declaringMember != null) {
            if (this.isEnclosingElement(method.getJavaElement())) {
                method = method.getMethodDeclaration();
            } else {
                this.appendLambdaLabel(method, flags);
                return;
            }
        }
        if (!BindingLinkedLabelComposer.getFlag(flags, 0x1000000000000L)) {
            method = method.getMethodDeclaration();
        }
        if (this.fIsFromSource) {
            flags &= 0xFFFFFFFFFFFBFFFFL;
        }
        boolean isInitializer = method.getName().equals(INIT_NAME);
        if (BindingLinkedLabelComposer.getFlag(flags, 4L) && (typeParameters = method.getTypeParameters()).length > 0) {
            this.appendTypeArgumentsBindingLabel(typeParameters, null, flags | 0x4000000000000000L);
            this.fBuffer.append(' ');
        }
        if (BindingLinkedLabelComposer.getFlag(flags, 64L) && !method.isConstructor() && !isInitializer) {
            this.appendTypeBindingLabel(method.getReturnType(), flags);
            this.fBuffer.append(' ');
        }
        if (BindingLinkedLabelComposer.getFlag(flags, 524416L)) {
            this.appendTypeBindingLabel(method.getDeclaringClass(), qualificationFlags);
            this.fBuffer.append('.');
        }
        if (isInitializer) {
            this.fBuffer.append(JavaUIMessages.JavaElementLabels_initializer);
        } else {
            this.appendNameLink((IBinding)method, (IBinding)origMethod);
        }
        if (!isInitializer) {
            ITypeBinding[] types;
            if (BindingLinkedLabelComposer.getFlag(flags, 0x200000L) && method.isConstructor()) {
                this.appendTypeArgumentsBindingLabel(method.getTypeArguments(), null, flags);
            }
            this.fBuffer.append('(');
            if (BindingLinkedLabelComposer.getFlag(flags, 3L)) {
                int i;
                types = null;
                int nParams = 0;
                boolean renderVarargs = false;
                boolean isPolymorphic = false;
                IMethod iMethod = this.getIMethod(method);
                if (BindingLinkedLabelComposer.getFlag(flags, 1L)) {
                    types = method.getParameterTypes();
                    nParams = types.length;
                    renderVarargs = method.isVarargs();
                    if (BindingLinkedLabelComposer.getFlag(flags, 0x1000000000000L) && iMethod != null && iMethod.isResolved() && iMethod.getParameterTypes().length == 1 && JavaModelUtil.isPolymorphicSignature(iMethod)) {
                        renderVarargs = false;
                        isPolymorphic = true;
                    }
                }
                String[] names = null;
                if (BindingLinkedLabelComposer.getFlag(flags, 2L) && iMethod != null) {
                    try {
                        names = iMethod.getParameterNames();
                    }
                    catch (JavaModelException e) {
                        JavaPlugin.log(e);
                    }
                    if (!isPolymorphic) {
                        if (types == null) {
                            nParams = names.length;
                        } else if (nParams != names.length) {
                            if (types.length > names.length) {
                                nParams = names.length;
                                ITypeBinding[] typesWithoutSyntheticParams = new ITypeBinding[nParams];
                                System.arraycopy(types, types.length - nParams, typesWithoutSyntheticParams, 0, nParams);
                                types = typesWithoutSyntheticParams;
                            } else {
                                names = null;
                            }
                        }
                    }
                }
                IAnnotationBinding[][] parameterAnnotations = null;
                if (nParams > 0 && BindingLinkedLabelComposer.getFlag(flags, 0x10000000000000L)) {
                    parameterAnnotations = new IAnnotationBinding[nParams][];
                    i = 0;
                    while (i < nParams) {
                        parameterAnnotations[i] = method.getParameterAnnotations(i);
                        ++i;
                    }
                }
                i = 0;
                while (i < nParams) {
                    if (i > 0) {
                        this.fBuffer.append(JavaElementLabels.COMMA_STRING);
                    }
                    if (parameterAnnotations != null && i < parameterAnnotations.length) {
                        this.appendAnnotationLabels(parameterAnnotations[i], flags);
                    }
                    if (types != null) {
                        ITypeBinding paramSig = types[i];
                        if (renderVarargs && i == nParams - 1) {
                            int newDim = paramSig.getDimensions() - 1;
                            this.appendTypeBindingLabel(paramSig.getElementType(), flags);
                            int k = 0;
                            while (k < newDim) {
                                this.fBuffer.append('[').append(']');
                                ++k;
                            }
                            this.fBuffer.append("...");
                        } else {
                            this.appendTypeBindingLabel(paramSig, flags);
                        }
                    }
                    if (names != null) {
                        if (types != null) {
                            this.fBuffer.append(' ');
                        }
                        if (isPolymorphic) {
                            this.fBuffer.append(String.valueOf(names[0]) + i);
                        } else {
                            this.fBuffer.append(names[i]);
                        }
                    }
                    ++i;
                }
            } else if (method.getParameterTypes().length > 0) {
                this.fBuffer.append("...");
            }
            this.fBuffer.append(')');
            if (BindingLinkedLabelComposer.getFlag(flags, 16L) && (types = method.getExceptionTypes()).length > 0) {
                this.fBuffer.append(" throws ");
                int i = 0;
                while (i < types.length) {
                    if (i > 0) {
                        this.fBuffer.append(JavaElementLabels.COMMA_STRING);
                    }
                    this.appendTypeBindingLabel(types[i], flags);
                    ++i;
                }
            }
            if (BindingLinkedLabelComposer.getFlag(flags, 8L)) {
                int offset = this.fBuffer.length();
                if (method.isParameterizedMethod()) {
                    this.appendTypeArgumentsBindingLabel(method.getTypeArguments(), String.valueOf(' '), flags);
                } else {
                    this.appendTypeArgumentsBindingLabel(method.getTypeParameters(), String.valueOf(' '), flags | 0x4000000000000000L);
                }
                if (BindingLinkedLabelComposer.getFlag(flags, 0x80000000000000L) && offset != this.fBuffer.length()) {
                    this.fBuffer.setStyle(offset, this.fBuffer.length() - offset, StyledString.DECORATIONS_STYLER);
                }
            }
        }
        if (BindingLinkedLabelComposer.getFlag(flags, 256L)) {
            this.fBuffer.append(JavaElementLabels.CONCAT_STRING);
            if (declaringMember != null && origMethod != method) {
                this.appendLambdaLabel(origMethod, qualificationFlags | JavaElementLabels.ALL_FULLY_QUALIFIED);
                this.fBuffer.append(' ');
                this.appendTypeBindingLabel(origMethod.getMethodDeclaration().getDeclaringClass(), -9223372036854775679L);
            } else {
                this.appendTypeBindingLabel(method.getDeclaringClass(), this.getPostQualificationFlags(flags));
            }
        }
    }

    private void appendVariableLabel(IVariableBinding variable, long flags) {
        long qualificationFlags = flags & (0x1002000000000L | JavaElementLabels.ALL_FULLY_QUALIFIED | 0x80000L);
        qualificationFlags |= 0x4000000000000000L;
        if (this.fIsFromSource) {
            flags &= 0xFFFFFFFFFFFBFFFFL;
        }
        if (BindingLinkedLabelComposer.getFlag(flags, 0x100000L)) {
            flags |= 0x20000L;
        }
        if (BindingLinkedLabelComposer.getFlag(flags &= 0xBFFFFFFFFFEFFFFFL, 32768L) && !Flags.isEnum((int)variable.getModifiers())) {
            this.appendTypeBindingLabel(variable.getType(), flags);
            this.fBuffer.append(' ');
        }
        if (BindingLinkedLabelComposer.getFlag(flags, 65536L)) {
            this.appendVariableQualification(variable, qualificationFlags);
            this.fBuffer.append('.');
        }
        if (variable.isField()) {
            this.appendNameLink((IBinding)variable, (IBinding)variable);
        } else {
            this.fBuffer.append(variable.getName());
        }
        if (BindingLinkedLabelComposer.getFlag(flags, 131072L)) {
            this.fBuffer.append(JavaElementLabels.CONCAT_STRING);
            this.appendVariableQualification(variable, this.getPostQualificationFlags(qualificationFlags));
        }
    }

    private void appendVariableQualification(IVariableBinding variable, long flags) {
        if (variable.isField()) {
            this.appendTypeBindingLabel(variable.getDeclaringClass(), flags);
        } else {
            IMethodBinding declaringMethod = variable.getDeclaringMethod();
            if (declaringMethod != null) {
                IBinding declaringMember = declaringMethod.getDeclaringMember();
                if (declaringMember != null) {
                    this.appendLambdaLabel(declaringMethod, flags);
                    this.fBuffer.append(' ');
                    this.appendMethodBindingLabel(declaringMethod.getMethodDeclaration(), flags & 0x1002000000000L | 0x81L);
                } else {
                    this.appendMethodBindingLabel(declaringMethod, flags | 0x81L);
                }
            } else {
                IJavaElement element = variable.getJavaElement();
                if (element != null && element.getParent() != null) {
                    this.appendElementLabel(element.getParent(), flags);
                } else {
                    this.fBuffer.append(MISSING_LABEL);
                }
            }
        }
    }

    private void appendLambdaLabel(IMethodBinding lambdaBinding, long flags) {
        long qualificationFlags = flags & (0x1002000000000L | JavaElementLabels.ALL_FULLY_QUALIFIED);
        if (this.fIsFromSource) {
            flags &= 0xFFFFFFFFFFFBFFFFL;
        }
        if (BindingLinkedLabelComposer.getFlag(flags, 262272L)) {
            this.appendBindingLabel(lambdaBinding.getDeclaringMember(), qualificationFlags);
            this.fBuffer.append('.');
            this.fBuffer.append(LAMBDA_LABEL);
        } else {
            IMethodBinding sam = lambdaBinding.getMethodDeclaration();
            this.appendMethodBindingLabel(sam, flags & (JavaElementLabels.ALL_POST_QUALIFIED ^ 0xFFFFFFFFFFFFFFFFL));
        }
        if (BindingLinkedLabelComposer.getFlag(flags, 0x100100L)) {
            this.fBuffer.append(JavaElementLabels.CONCAT_STRING);
            this.appendBindingLabel(lambdaBinding.getDeclaringMember(), qualificationFlags |= JavaElementLabels.ALL_FULLY_QUALIFIED);
            this.fBuffer.append('.');
            this.fBuffer.append(LAMBDA_LABEL);
            this.fBuffer.append(' ');
            this.appendTypeBindingLabel(lambdaBinding.getDeclaringClass(), flags & (0x1002000000000L | JavaElementLabels.ALL_FULLY_QUALIFIED) | Long.MIN_VALUE);
        }
    }

    private void appendTypeBindingLabel(ITypeBinding typeBinding, long flags) {
        IBinding declaringMember;
        long typeRefFlags = flags & (JavaElementLabels.ALL_POST_QUALIFIED ^ 0xFFFFFFFFFFFFFFFFL);
        if (this.fIsFromSource) {
            typeRefFlags &= (JavaElementLabels.ALL_FULLY_QUALIFIED | 0x4000000000000000L) ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if ((declaringMember = typeBinding.getDeclaringMember()) != null && BindingLinkedLabelComposer.getFlag(flags, 786432L)) {
            long qualificationFlags = flags;
            if (BindingLinkedLabelComposer.getFlag(flags, 262144L)) {
                qualificationFlags |= JavaElementLabels.ALL_FULLY_QUALIFIED;
            } else if (BindingLinkedLabelComposer.getFlag(flags, 524288L)) {
                qualificationFlags |= 0x10080L;
            }
            this.appendBindingLabel(declaringMember, qualificationFlags);
            this.fBuffer.append('.');
            flags &= 0xFFFFFFFFFFF3FF7FL;
        }
        if (!typeBinding.isArray()) {
            this.appendAnnotationLabels(typeBinding.getTypeAnnotations(), typeRefFlags);
        }
        if (typeBinding.isPrimitive()) {
            this.fBuffer.append(typeBinding.getName());
        } else if (typeBinding.isArray()) {
            this.appendTypeBindingLabel(typeBinding.getElementType(), flags);
            IAnnotationBinding[] typeAnnotations = typeBinding.getTypeAnnotations();
            if (typeAnnotations.length > 0) {
                this.fBuffer.append(' ');
                this.appendAnnotationLabels(typeAnnotations, typeRefFlags);
            }
            int dim = typeBinding.getDimensions();
            while (dim > 0) {
                this.fBuffer.append('[').append(']');
                --dim;
            }
        } else if (typeBinding.isClass() || typeBinding.isInterface() || typeBinding.isEnum()) {
            this.fBuffer.append(this.getTypeLink(typeBinding, flags));
            if (BindingLinkedLabelComposer.getFlag(flags, 0x200000L)) {
                ITypeBinding[] typeArguments = typeBinding.getTypeArguments();
                if (typeArguments.length > 0) {
                    this.appendTypeArgumentsBindingLabel(typeArguments, null, typeRefFlags);
                } else {
                    ITypeBinding[] typeParameters = typeBinding.getTypeParameters();
                    this.appendTypeArgumentsBindingLabel(typeParameters, null, typeRefFlags | 0x4000000000000000L);
                }
            }
        } else if (typeBinding.isParameterizedType()) {
            this.fBuffer.append(this.getTypeLink(typeBinding.getTypeDeclaration(), flags));
            this.fBuffer.append(this.getLT());
            ITypeBinding[] typeArguments = typeBinding.getTypeArguments();
            int i = 0;
            while (i < typeArguments.length) {
                if (i > 0) {
                    this.fBuffer.append(JavaElementLabels.COMMA_STRING);
                }
                this.appendTypeBindingLabel(typeArguments[i], typeRefFlags);
                ++i;
            }
            this.fBuffer.append(this.getGT());
        } else {
            if (typeBinding.isTypeVariable()) {
                ITypeBinding[] bounds;
                this.appendNameLink((IBinding)typeBinding, (IBinding)typeBinding);
                if (BindingLinkedLabelComposer.getFlag(flags, 0x4000000000000000L) && this.hasRelevantBound(bounds = typeBinding.getTypeBounds())) {
                    this.fBuffer.append(" extends ");
                    int i = 0;
                    while (i < bounds.length) {
                        if (i > 0) {
                            this.fBuffer.append(" &amp; ");
                        }
                        this.appendTypeBindingLabel(bounds[i], (typeRefFlags | 0x200000L) & 0xBFFFFFFFFFFFFFFFL);
                        ++i;
                    }
                }
                if (BindingLinkedLabelComposer.getFlag(flags, 0x400000L)) {
                    this.fBuffer.append(JavaElementLabels.CONCAT_STRING);
                    if (typeBinding.getDeclaringClass() != null) {
                        this.appendTypeBindingLabel(typeBinding.getDeclaringClass(), this.getPostQualificationFlags(flags) & 0xFFFFFFFFFFDFFFFFL);
                    } else {
                        this.appendMethodBindingLabel(typeBinding.getDeclaringMethod(), this.getPostQualificationFlags(flags) & 0xFFFFFFFFFFFFFFF7L);
                    }
                }
                return;
            }
            if (typeBinding.isAnnotation()) {
                this.fBuffer.append(this.getTypeLink(typeBinding, flags));
            } else if (typeBinding.isWildcardType()) {
                ITypeBinding bound = typeBinding.getBound();
                if (bound == null || bound.getSuperclass() == null) {
                    this.fBuffer.append('?');
                } else {
                    if (typeBinding.isUpperbound()) {
                        this.fBuffer.append("? extends ");
                    } else {
                        this.fBuffer.append("? super ");
                    }
                    this.appendTypeBindingLabel(bound, typeRefFlags);
                }
            } else if (typeBinding.isCapture()) {
                this.appendTypeBindingLabel(typeBinding.getWildcard(), flags);
            }
        }
        if (BindingLinkedLabelComposer.getFlag(flags, 0x100000L)) {
            IBinding declaringBinding = typeBinding.getDeclaringMember();
            if (declaringBinding == null) {
                declaringBinding = typeBinding.getDeclaringMethod();
                if (declaringBinding == null) {
                    declaringBinding = typeBinding.getDeclaringClass();
                }
                if (declaringBinding == null) {
                    declaringBinding = typeBinding.getPackage();
                }
            }
            if (declaringBinding != null) {
                this.fBuffer.append(JavaElementLabels.CONCAT_STRING);
                this.appendBindingLabel(declaringBinding, this.getPostQualificationFlags(flags) & 0xFFFFFFFFFFFFFFFEL);
            }
        }
    }

    private void appendTypeArgumentsBindingLabel(ITypeBinding[] parameters, String separator, long flags) {
        if (parameters.length > 0) {
            if (separator != null) {
                this.fBuffer.append(separator);
            }
            this.fBuffer.append(this.getLT());
            int i = 0;
            while (i < parameters.length) {
                if (i > 0) {
                    this.fBuffer.append(JavaElementLabels.COMMA_STRING);
                }
                this.appendTypeBindingLabel(parameters[i], flags);
                ++i;
            }
            this.fBuffer.append(this.getGT());
        }
    }

    private void appendAnnotationLabels(IAnnotationBinding[] annotationBindings, long flags) {
        int i = 0;
        while (i < annotationBindings.length) {
            this.appendAnnotationLabel(annotationBindings[i], flags);
            this.fBuffer.append(' ');
            ++i;
        }
    }

    private void appendAnnotationLabel(IAnnotationBinding annotation, long flags) {
        this.fBuffer.append('@');
        this.appendTypeBindingLabel(annotation.getAnnotationType(), flags);
        IMemberValuePairBinding[] memberValuePairs = annotation.getDeclaredMemberValuePairs();
        if (memberValuePairs.length == 0) {
            return;
        }
        if (this.fIsFromSource) {
            flags &= 0xFFFFFFFFFFFBFFFFL;
        }
        this.fBuffer.append('(');
        int i = 0;
        while (i < memberValuePairs.length) {
            if (i > 0) {
                this.fBuffer.append(JavaElementLabels.COMMA_STRING);
            }
            IMemberValuePairBinding memberValuePair = memberValuePairs[i];
            this.fBuffer.append(this.getMemberName(this.fEnclosingElement, annotation.getName(), memberValuePair.getName()));
            this.fBuffer.append('=');
            long valueFlags = flags & ((0x8040L | JavaElementLabels.ALL_POST_QUALIFIED) ^ 0xFFFFFFFFFFFFFFFFL);
            this.appendAnnotationValue(annotation, memberValuePair.getValue(), valueFlags);
            ++i;
        }
        this.fBuffer.append(')');
    }

    private void appendAnnotationValue(IAnnotationBinding annotation, Object value, long flags) {
        if (value instanceof Object[]) {
            this.fBuffer.append('{');
            Object[] values = (Object[])value;
            int j = 0;
            while (j < values.length) {
                if (j > 0) {
                    this.fBuffer.append(JavaElementLabels.COMMA_STRING);
                }
                value = values[j];
                this.appendAnnotationValue(annotation, value, flags);
                ++j;
            }
            this.fBuffer.append('}');
        } else if (value instanceof ITypeBinding) {
            this.appendTypeBindingLabel((ITypeBinding)value, flags);
            this.fBuffer.append(".class");
        } else if (value instanceof String) {
            this.fBuffer.append(this.htmlEscape(ASTNodes.getEscapedStringLiteral((String)value)));
        } else if (value instanceof IVariableBinding) {
            this.appendVariableLabel((IVariableBinding)value, flags);
        } else if (value instanceof IAnnotationBinding) {
            this.appendAnnotationLabel((IAnnotationBinding)value, flags);
        } else if (value instanceof Character) {
            this.fBuffer.append(ASTNodes.getEscapedCharacterLiteral(((Character)value).charValue()));
        } else {
            this.fBuffer.append(String.valueOf(value));
        }
    }

    private void appendPackageLabel(IPackageBinding binding, long flags) {
        this.appendAnnotationLabels(binding.getAnnotations(), flags);
        String qualifiedName = binding.getName();
        if (qualifiedName.length() > 0) {
            IJavaElement packageElement = binding.getJavaElement();
            try {
                String uri = JavaElementLinks.createURI("eclipse-javadoc", packageElement);
                this.fBuffer.append(JavaElementLinks.createHeaderLink(uri, qualifiedName));
            }
            catch (URISyntaxException e) {
                JavaPlugin.log(e);
                this.fBuffer.append(qualifiedName);
            }
        } else {
            this.fBuffer.append("(default package)");
        }
    }

    private boolean hasRelevantBound(ITypeBinding[] bounds) {
        if (bounds != null) {
            int i = 0;
            while (i < bounds.length) {
                if (bounds[i].isInterface() || bounds[i].getSuperclass() != null) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private long getPostQualificationFlags(long flags) {
        flags |= JavaElementLabels.ALL_FULLY_QUALIFIED | 1L | Long.MIN_VALUE;
        flags &= JavaElementLabels.ALL_POST_QUALIFIED ^ 0xFFFFFFFFFFFFFFFFL;
        return flags &= 0xFFFFFFFFFFDFFFB9L;
    }

    private void appendNameLink(IBinding binding, IBinding origBinding) {
        try {
            IJavaElement javaElement = origBinding.getJavaElement();
            if (!this.isEnclosingElement(javaElement)) {
                IJavaElement element = binding.getJavaElement();
                if (element == null) {
                    element = this.fEnclosingElement;
                }
                String uri = JavaElementLinks.createURI("eclipse-javadoc", element);
                String title = this.getLinkTitle(binding);
                title = title != null ? Messages.format(JavaUIMessages.JavaElementLinks_title, title) : INIT_NAME;
                this.fBuffer.append(JavaElementLinks.createHeaderLink(uri, binding.getName(), title));
                return;
            }
        }
        catch (URISyntaxException e) {
            JavaPlugin.log(e);
        }
        this.fBuffer.append(binding.getName());
    }

    private String getLinkTitle(IBinding binding) {
        if (binding instanceof ITypeBinding) {
            IMethodBinding declaringMethod = ((ITypeBinding)binding).getDeclaringMethod();
            String title = null;
            ITypeBinding declaringClass = null;
            if (declaringMethod != null) {
                title = String.valueOf('.') + declaringMethod.getName() + PARAMETER_ELLIPSIS_LABEL;
                declaringClass = declaringMethod.getDeclaringClass();
            } else {
                declaringClass = ((ITypeBinding)binding).getDeclaringClass();
            }
            if (declaringClass != null) {
                String typeName = this.getTypeName(declaringClass, JavaElementLabels.ALL_FULLY_QUALIFIED);
                return title != null ? String.valueOf(typeName) + title : typeName;
            }
        } else {
            if (binding instanceof IMethodBinding) {
                return this.getTypeName(((IMethodBinding)binding).getDeclaringClass(), JavaElementLabels.ALL_FULLY_QUALIFIED);
            }
            if (binding instanceof IVariableBinding) {
                return this.getTypeName(((IVariableBinding)binding).getDeclaringClass(), JavaElementLabels.ALL_FULLY_QUALIFIED);
            }
        }
        return null;
    }

    private String getTypeLink(ITypeBinding typeBinding, long flags) {
        if (this.isEnclosingElement(typeBinding.getJavaElement())) {
            return this.getTypeName(typeBinding, flags);
        }
        typeBinding = typeBinding.getTypeDeclaration();
        String typeName = this.getTypeName(typeBinding, flags);
        String qualifiedName = this.getTypeName(typeBinding, 262144L);
        String title = INIT_NAME;
        int qualifierLength = qualifiedName.length() - typeName.length() - 1;
        if (qualifierLength > 0) {
            if (qualifiedName.endsWith(typeName)) {
                title = qualifiedName.substring(0, qualifierLength);
                title = Messages.format(JavaUIMessages.JavaElementLinks_title, title);
            } else {
                title = qualifiedName;
            }
        }
        try {
            String uri = JavaElementLinks.createURI("eclipse-javadoc", this.fEnclosingElement, qualifiedName, null, null);
            return JavaElementLinks.createHeaderLink(uri, typeName, title);
        }
        catch (URISyntaxException e) {
            JavaPlugin.log(e);
            return typeName;
        }
    }

    private String getTypeName(ITypeBinding typeBinding, long flags) {
        ITypeBinding declaringClass;
        if (typeBinding.isLocal()) {
            StringBuilder buf = new StringBuilder();
            IMethodBinding declaringMethod = typeBinding.getDeclaringMethod();
            if (BindingLinkedLabelComposer.getFlag(flags, 786432L)) {
                if (declaringMethod != null) {
                    buf.append(this.getTypeName(declaringMethod.getDeclaringClass(), flags));
                    buf.append('.');
                    buf.append(declaringMethod.getName());
                    if (declaringMethod.getParameterTypes().length > 0) {
                        buf.append(PARAMETER_ELLIPSIS_LABEL);
                    } else {
                        buf.append("()");
                    }
                } else {
                    buf.append(this.getTypeName(typeBinding.getDeclaringClass(), flags));
                    IBinding declaringMember = typeBinding.getDeclaringMember();
                    if (declaringMember != null) {
                        buf.append('.');
                        if (declaringMember instanceof ITypeBinding) {
                            buf.append(this.getTypeName((ITypeBinding)declaringMember, flags));
                        } else {
                            String name = declaringMember.getName();
                            if (name.equals(INIT_NAME)) {
                                buf.append(JavaUIMessages.JavaElementLabels_initializer);
                            } else {
                                buf.append(name);
                            }
                        }
                    }
                }
                buf.append('.');
            }
            if (typeBinding.isAnonymous()) {
                buf.append("new ");
                ITypeBinding[] interfaces = typeBinding.getInterfaces();
                if (interfaces.length > 0) {
                    buf.append(interfaces[0].getName());
                } else if (typeBinding.getSuperclass() != null) {
                    buf.append(typeBinding.getSuperclass().getName());
                } else {
                    buf.append(MISSING_LABEL);
                }
                buf.append(ANON_TYPE_TAIL);
            } else {
                buf.append(typeBinding.getName());
            }
            return buf.toString();
        }
        if (BindingLinkedLabelComposer.getFlag(flags, 262144L)) {
            return typeBinding.getQualifiedName();
        }
        if (BindingLinkedLabelComposer.getFlag(flags, 524288L) && (declaringClass = typeBinding.getDeclaringClass()) != null) {
            StringBuilder buf = new StringBuilder(this.getTypeName(declaringClass, flags));
            buf.append('.');
            buf.append(typeBinding.getName());
            return buf.toString();
        }
        return typeBinding.getName();
    }

    private IMethod getIMethod(IMethodBinding method) {
        IJavaElement element = method.getJavaElement();
        if (element == null || element.getElementType() != 9) {
            return null;
        }
        IMethod iMethod = (IMethod)element;
        if (this.isEnclosingElement((IJavaElement)iMethod)) {
            return (IMethod)this.fEnclosingElement;
        }
        return iMethod;
    }

    private boolean isEnclosingElement(IJavaElement element) {
        if (element == null) {
            return false;
        }
        if (element.equals(this.fEnclosingElement)) {
            return true;
        }
        String enclosingKey = null;
        switch (this.fEnclosingElement.getElementType()) {
            case 7: {
                if (((IType)this.fEnclosingElement).isLambda() && element.getElementType() == 9) {
                    try {
                        IJavaElement[] children = ((IType)this.fEnclosingElement).getChildren();
                        if (children == null || children.length != 1 || children[0].getElementType() != 9) break;
                        enclosingKey = ((IMethod)children[0]).getKey();
                    }
                    catch (JavaModelException javaModelException) {}
                    break;
                }
                enclosingKey = ((IType)this.fEnclosingElement).getKey();
                break;
            }
            case 9: {
                enclosingKey = ((IMethod)this.fEnclosingElement).getKey();
            }
        }
        if (enclosingKey != null) {
            switch (element.getElementType()) {
                case 7: {
                    return enclosingKey.equals(((IType)element).getKey());
                }
                case 9: {
                    return enclosingKey.equals(((IMethod)element).getKey());
                }
            }
        }
        return false;
    }

    private String htmlEscape(String escaped) {
        return escaped.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }
}

