/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.widgets.examples;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.SchemeBorder;
import org.eclipse.nebula.visualization.widgets.figures.MeterFigure;
import org.eclipse.nebula.visualization.xygraph.util.XYGraphMediaFactory;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class MeterExample {
    private static int counter = 0;

    public static void main(String[] args) {
        Shell shell = new Shell();
        shell.setSize(300, 150);
        shell.open();
        LightweightSystem lws = new LightweightSystem((Canvas)shell);
        final MeterFigure meterFigure = new MeterFigure();
        meterFigure.setBackgroundColor(XYGraphMediaFactory.getInstance().getColor(255, 255, 255));
        meterFigure.setBorder((Border)new SchemeBorder(SchemeBorder.SCHEMES.ETCHED));
        meterFigure.setRange(-100.0, 100.0);
        meterFigure.setLoLevel(-50.0);
        meterFigure.setLoloLevel(-80.0);
        meterFigure.setHiLevel(60.0);
        meterFigure.setHihiLevel(80.0);
        meterFigure.setMajorTickMarkStepHint(50);
        lws.setContents((IFigure)meterFigure);
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
        ScheduledFuture<?> future = scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        int n = counter;
                        counter = n + 1;
                        meterFigure.setValue(Math.sin((double)n / 10.0) * 100.0);
                    }
                });
            }
        }, 100L, 100L, TimeUnit.MILLISECONDS);
        Display display = Display.getDefault();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        future.cancel(true);
        scheduler.shutdown();
    }
}

