/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import net.sf.saxon.AugmentedSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.CommentStripper;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Sender;
import net.sf.saxon.event.StartTagBuffer;
import net.sf.saxon.functions.ExecutableFunctionLibrary;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.UserFunction;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.style.LiteralResultElement;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StyleNodeFactory;
import net.sf.saxon.style.StylesheetStripper;
import net.sf.saxon.style.UseWhenFilter;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.CompilerInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.DocumentImpl;
import net.sf.saxon.tree.TreeBuilder;
import org.xml.sax.XMLReader;

public class PreparedStylesheet
implements Templates,
Serializable {
    private Executable executable;
    private transient Configuration config;
    private NamePool targetNamePool;
    private transient StyleNodeFactory nodeFactory;
    private int errorCount = 0;
    private HashMap nextStylesheetCache;
    private transient ErrorListener errorListener;
    private transient URIResolver uriResolver;
    private boolean compileWithTracing;

    protected PreparedStylesheet(Configuration config, CompilerInfo info) {
        this.config = config;
        this.errorListener = info.getErrorListener();
        this.uriResolver = info.getURIResolver();
        this.compileWithTracing = info.isCompileWithTracing();
    }

    public static PreparedStylesheet compile(Source source, Configuration config, CompilerInfo info) throws TransformerConfigurationException {
        PreparedStylesheet pss = new PreparedStylesheet(config, info);
        pss.prepare(source);
        return pss;
    }

    public Transformer newTransformer() {
        Controller c = new Controller(this.config, this.executable);
        c.setPreparedStylesheet(this);
        return c;
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setTargetNamePool(NamePool pool) {
        this.targetNamePool = pool;
    }

    public NamePool getTargetNamePool() {
        if (this.targetNamePool == null) {
            return this.config.getNamePool();
        }
        return this.targetNamePool;
    }

    public StyleNodeFactory getStyleNodeFactory() {
        return this.nodeFactory;
    }

    protected void prepare(Source styleSource) throws TransformerConfigurationException {
        block5: {
            this.nodeFactory = new StyleNodeFactory(this.config, this.errorListener);
            try {
                DocumentImpl doc = PreparedStylesheet.loadStylesheetModule(styleSource, this.config, this.config.getNamePool(), this.nodeFactory);
                this.setStylesheetDocument(doc, this.nodeFactory);
            }
            catch (XPathException e) {
                try {
                    this.errorListener.fatalError(e);
                }
                catch (TransformerException e2) {
                    // empty catch block
                }
                if (this.errorCount != 0) break block5;
                ++this.errorCount;
            }
        }
        if (this.errorCount > 0) {
            throw new TransformerConfigurationException("Failed to compile stylesheet. " + this.errorCount + (this.errorCount == 1 ? " error " : " errors ") + "detected.");
        }
    }

    public static DocumentImpl loadStylesheetModule(Source styleSource, Configuration config, NamePool localNamePool, StyleNodeFactory nodeFactory) throws XPathException {
        TreeBuilder styleBuilder = new TreeBuilder();
        PipelineConfiguration pipe = config.makePipelineConfiguration();
        styleBuilder.setPipelineConfiguration(pipe);
        styleBuilder.setSystemId(styleSource.getSystemId());
        styleBuilder.setNodeFactory(nodeFactory);
        styleBuilder.setLineNumbering(true);
        StartTagBuffer startTagBuffer = new StartTagBuffer();
        UseWhenFilter useWhenFilter = new UseWhenFilter(startTagBuffer);
        useWhenFilter.setUnderlyingReceiver(styleBuilder);
        startTagBuffer.setUnderlyingReceiver(useWhenFilter);
        StylesheetStripper styleStripper = new StylesheetStripper();
        styleStripper.setStylesheetRules(localNamePool);
        styleStripper.setUnderlyingReceiver(startTagBuffer);
        CommentStripper commentStripper = new CommentStripper();
        commentStripper.setUnderlyingReceiver(styleStripper);
        Sender sender = new Sender(pipe);
        AugmentedSource aug = AugmentedSource.makeAugmentedSource(styleSource);
        aug.setSchemaValidationMode(4);
        aug.setDTDValidationMode(4);
        aug.setLineNumbering(true);
        if (aug.getXMLReader() == null && Configuration.getPlatform().isJava()) {
            XMLReader styleParser = config.getStyleParser();
            aug.setXMLReader(styleParser);
            sender.send(aug, commentStripper);
            config.reuseStyleParser(styleParser);
        } else {
            sender.send(aug, commentStripper);
        }
        DocumentImpl doc = (DocumentImpl)styleBuilder.getCurrentRoot();
        styleBuilder.reset();
        if (aug.isPleaseCloseAfterUse()) {
            aug.close();
        }
        return doc;
    }

    public static PreparedStylesheet loadCompiledStylesheet(Configuration config, String fileName) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(new FileInputStream(fileName));
        return PreparedStylesheet.loadCompiledStylesheet(config, ois);
    }

    public static PreparedStylesheet loadCompiledStylesheet(Configuration config, ObjectInputStream ois) throws IOException, ClassNotFoundException {
        PreparedStylesheet sheet = (PreparedStylesheet)ois.readObject();
        ois.close();
        NamePool compiledNamePool = sheet.getTargetNamePool();
        sheet.setConfiguration(config);
        sheet.getExecutable().setConfiguration(config);
        config.setNamePool(compiledNamePool);
        NamePool.setDefaultNamePool(compiledNamePool);
        return sheet;
    }

    protected void setStylesheetDocument(DocumentImpl doc, StyleNodeFactory snFactory) throws XPathException {
        DocumentImpl styleDoc = doc;
        this.nodeFactory = snFactory;
        StyleElement topnode = (StyleElement)styleDoc.getDocumentElement();
        if (topnode instanceof LiteralResultElement) {
            styleDoc = ((LiteralResultElement)topnode).makeStylesheet(this, snFactory);
        }
        if (!(styleDoc.getDocumentElement() instanceof XSLStylesheet)) {
            throw new XPathException("Outermost element of stylesheet is not xsl:stylesheet or xsl:transform or literal result element");
        }
        XSLStylesheet top = (XSLStylesheet)styleDoc.getDocumentElement();
        if (this.config.isVersionWarning() && top.getVersion().equals(BigDecimal.valueOf(1L))) {
            try {
                TransformerException w = new TransformerException("Running an XSLT 1.0 stylesheet with an XSLT 2.0 processor");
                w.setLocator(topnode);
                this.config.getErrorListener().warning(w);
            }
            catch (TransformerException e) {
                throw XPathException.makeXPathException(e);
            }
        }
        top.setPreparedStylesheet(this);
        try {
            top.preprocess();
        }
        catch (XPathException e) {
            Throwable e2 = e.getException();
            if (e2 instanceof XPathException) {
                try {
                    this.errorListener.fatalError((XPathException)e2);
                }
                catch (TransformerException e3) {
                    // empty catch block
                }
            }
            throw e;
        }
        this.executable = top.compileStylesheet();
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public boolean isCompileWithTracing() {
        return this.compileWithTracing;
    }

    public Properties getOutputProperties() {
        Properties details = this.executable.getDefaultOutputProperties();
        return new Properties(details);
    }

    public void reportError(TransformerException err) throws TransformerException {
        ++this.errorCount;
        if (err instanceof XPathException) {
            if (!((XPathException)err).hasBeenReported()) {
                try {
                    this.errorListener.fatalError(err);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ((XPathException)err).setHasBeenReported();
            }
        } else {
            this.errorListener.fatalError(err);
        }
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public void reportWarning(TransformerException err) {
        try {
            this.errorListener.warning(err);
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }

    public PreparedStylesheet getCachedStylesheet(String href, String baseURI) {
        URI abs = null;
        try {
            abs = new URI(baseURI).resolve(href);
        }
        catch (URISyntaxException err) {
            // empty catch block
        }
        PreparedStylesheet result = null;
        if (abs != null && this.nextStylesheetCache != null) {
            result = (PreparedStylesheet)this.nextStylesheetCache.get(abs);
        }
        return result;
    }

    public void putCachedStylesheet(String href, String baseURI, PreparedStylesheet pss) {
        URI abs = null;
        try {
            abs = new URI(baseURI).resolve(href);
        }
        catch (URISyntaxException err) {
            // empty catch block
        }
        if (abs != null) {
            if (this.nextStylesheetCache == null) {
                this.nextStylesheetCache = new HashMap(4);
            }
            this.nextStylesheetCache.put(abs, pss);
        }
    }

    public URIResolver getURIResolver() {
        return this.uriResolver;
    }

    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    public void explain(ExpressionPresenter presenter) {
        presenter.startElement("stylesheet");
        this.getExecutable().getKeyManager().explainKeys(presenter);
        this.getExecutable().explainGlobalVariables(presenter);
        this.getExecutable().getRuleManager().explainTemplateRules(presenter);
        this.getExecutable().explainNamedTemplates(presenter);
        FunctionLibraryList libList = (FunctionLibraryList)this.getExecutable().getFunctionLibrary();
        List libraryList = libList.getLibraryList();
        presenter.startElement("functions");
        for (int i = 0; i < libraryList.size(); ++i) {
            FunctionLibrary lib = (FunctionLibrary)libraryList.get(i);
            if (!(lib instanceof ExecutableFunctionLibrary)) continue;
            Iterator f = ((ExecutableFunctionLibrary)lib).iterateFunctions();
            while (f.hasNext()) {
                UserFunction func = (UserFunction)f.next();
                presenter.startElement("function");
                presenter.emitAttribute("name", func.getFunctionName().getDisplayName());
                presenter.emitAttribute("line", func.getLineNumber() + "");
                presenter.emitAttribute("module", func.getSystemId());
                func.getBody().explain(presenter);
                presenter.endElement();
            }
        }
        presenter.endElement();
        presenter.endElement();
    }
}

