/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.io;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.database.IQuantDatabase;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.database.QuantDatabase;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IIntegrationEntry;
import org.eclipse.chemclipse.model.core.IPeakIntensityValues;
import org.eclipse.chemclipse.model.core.PeakType;
import org.eclipse.chemclipse.model.core.RetentionIndexType;
import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.model.exceptions.PeakException;
import org.eclipse.chemclipse.model.exceptions.ReferenceMustNotBeNullException;
import org.eclipse.chemclipse.model.identifier.IComparisonResult;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.model.identifier.PeakComparisonResult;
import org.eclipse.chemclipse.model.identifier.PeakLibraryInformation;
import org.eclipse.chemclipse.model.implementation.PeakIntensityValues;
import org.eclipse.chemclipse.model.implementation.QuantitationEntry;
import org.eclipse.chemclipse.model.quantitation.CalibrationMethod;
import org.eclipse.chemclipse.model.quantitation.IQuantitationEntry;
import org.eclipse.chemclipse.model.quantitation.IRetentionIndexWindow;
import org.eclipse.chemclipse.model.quantitation.IRetentionTimeWindow;
import org.eclipse.chemclipse.model.quantitation.RetentionIndexWindow;
import org.eclipse.chemclipse.model.quantitation.RetentionTimeWindow;
import org.eclipse.chemclipse.model.targets.IPeakTarget;
import org.eclipse.chemclipse.model.targets.PeakTarget;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IIonTransition;
import org.eclipse.chemclipse.msd.model.core.IIonTransitionSettings;
import org.eclipse.chemclipse.msd.model.core.IPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IPeakModelMSD;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;
import org.eclipse.chemclipse.msd.model.core.identifier.massspectrum.IMassSpectrumTarget;
import org.eclipse.chemclipse.msd.model.core.identifier.massspectrum.MassSpectrumComparisonResult;
import org.eclipse.chemclipse.msd.model.core.identifier.massspectrum.MassSpectrumLibraryInformation;
import org.eclipse.chemclipse.msd.model.core.identifier.massspectrum.MassSpectrumTarget;
import org.eclipse.chemclipse.msd.model.core.quantitation.ConcentrationResponseEntryMSD;
import org.eclipse.chemclipse.msd.model.core.quantitation.IConcentrationResponseEntryMSD;
import org.eclipse.chemclipse.msd.model.core.quantitation.IQuantitationCompoundMSD;
import org.eclipse.chemclipse.msd.model.core.quantitation.IQuantitationPeakMSD;
import org.eclipse.chemclipse.msd.model.core.quantitation.IQuantitationSignalMSD;
import org.eclipse.chemclipse.msd.model.core.quantitation.QuantitationSignalMSD;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;
import org.eclipse.chemclipse.msd.model.exceptions.IonTransitionIsNullException;
import org.eclipse.chemclipse.msd.model.implementation.IntegrationEntryMSD;
import org.eclipse.chemclipse.msd.model.implementation.Ion;
import org.eclipse.chemclipse.msd.model.implementation.IonTransitionSettings;
import org.eclipse.chemclipse.msd.model.implementation.PeakMSD;
import org.eclipse.chemclipse.msd.model.implementation.PeakMassSpectrum;
import org.eclipse.chemclipse.msd.model.implementation.PeakModelMSD;
import org.eclipse.chemclipse.msd.model.implementation.QuantitationCompoundMSD;
import org.eclipse.chemclipse.msd.model.implementation.QuantitationEntryMSD;
import org.eclipse.chemclipse.msd.model.implementation.QuantitationPeakMSD;
import org.eclipse.chemclipse.msd.model.implementation.ScanMSD;

public class QuantDatabaseReader {
    private static final Logger logger = Logger.getLogger(QuantDatabaseReader.class);

    public static IQuantDatabase read(File file) throws Exception {
        QuantDatabase quantDatabase = new QuantDatabase();
        DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
        int size = dataInputStream.readInt();
        int i = 0;
        while (i < size) {
            String name = QuantDatabaseReader.readString(dataInputStream);
            String concentrationUnit = QuantDatabaseReader.readString(dataInputStream);
            CalibrationMethod calibrationMethod = CalibrationMethod.valueOf((String)QuantDatabaseReader.readString(dataInputStream));
            String chemicalClass = QuantDatabaseReader.readString(dataInputStream);
            boolean crossZero = dataInputStream.readBoolean();
            boolean useTIC = dataInputStream.readBoolean();
            List<IQuantitationPeakMSD> quantitationPeaks = QuantDatabaseReader.readQuantitationPeaks(dataInputStream);
            List<IConcentrationResponseEntryMSD> concentrationResponseEntriesMSD = QuantDatabaseReader.readConcentrationResponseEntries(dataInputStream);
            List<IQuantitationSignalMSD> quantitationSignalsMSD = QuantDatabaseReader.readQuantitationSignals(dataInputStream);
            IRetentionIndexWindow retentionIndexWindow = QuantDatabaseReader.readRetentionIndexWindow(dataInputStream);
            IRetentionTimeWindow retentionTimeWindow = QuantDatabaseReader.readRetentionTimeWindow(dataInputStream);
            QuantitationCompoundMSD quantitationCompound = new QuantitationCompoundMSD(name, concentrationUnit, retentionTimeWindow.getRetentionTime());
            quantitationCompound.setCalibrationMethod(calibrationMethod);
            quantitationCompound.setChemicalClass(chemicalClass);
            quantitationCompound.setUseCrossZero(crossZero);
            quantitationCompound.setUseTIC(useTIC);
            quantitationCompound.getRetentionIndexWindow().setAllowedNegativeDeviation(retentionIndexWindow.getAllowedNegativeDeviation());
            quantitationCompound.getRetentionIndexWindow().setAllowedPositiveDeviation(retentionIndexWindow.getAllowedPositiveDeviation());
            quantitationCompound.getRetentionIndexWindow().setRetentionIndex(retentionIndexWindow.getRetentionIndex());
            quantitationCompound.getRetentionTimeWindow().setAllowedNegativeDeviation(retentionTimeWindow.getAllowedNegativeDeviation());
            quantitationCompound.getRetentionTimeWindow().setAllowedPositiveDeviation(retentionTimeWindow.getAllowedPositiveDeviation());
            quantitationCompound.getConcentrationResponseEntriesMSD().addAll(concentrationResponseEntriesMSD);
            quantitationCompound.getQuantitationSignalsMSD().addAll(quantitationSignalsMSD);
            quantDatabase.addQuantitationCompound((IQuantitationCompoundMSD)quantitationCompound);
            quantDatabase.getQuantitationPeaks((IQuantitationCompoundMSD)quantitationCompound).addAll(quantitationPeaks);
            ++i;
        }
        return quantDatabase;
    }

    private static List<IQuantitationPeakMSD> readQuantitationPeaks(DataInputStream dataInputStream) throws Exception {
        ArrayList<IQuantitationPeakMSD> quantitationPeaks = new ArrayList<IQuantitationPeakMSD>();
        IonTransitionSettings ionTransitionSettings = new IonTransitionSettings();
        int size = dataInputStream.readInt();
        int i = 0;
        while (i < size) {
            double concentration = dataInputStream.readDouble();
            String concentrationUnit = QuantDatabaseReader.readString(dataInputStream);
            IPeakMSD referencePeakMSD = QuantDatabaseReader.readPeak(dataInputStream, (IIonTransitionSettings)ionTransitionSettings);
            QuantitationPeakMSD quantitationPeak = new QuantitationPeakMSD(referencePeakMSD, concentration, concentrationUnit);
            quantitationPeaks.add((IQuantitationPeakMSD)quantitationPeak);
            ++i;
        }
        return quantitationPeaks;
    }

    private static List<IConcentrationResponseEntryMSD> readConcentrationResponseEntries(DataInputStream dataInputStream) throws Exception {
        ArrayList<IConcentrationResponseEntryMSD> concentrationResponseEntriesMSD = new ArrayList<IConcentrationResponseEntryMSD>();
        int size = dataInputStream.readInt();
        int i = 0;
        while (i < size) {
            double ion = dataInputStream.readDouble();
            double concentration = dataInputStream.readDouble();
            double response = dataInputStream.readDouble();
            ConcentrationResponseEntryMSD concentrationResponseEntryMSD = new ConcentrationResponseEntryMSD(ion, concentration, response);
            concentrationResponseEntriesMSD.add((IConcentrationResponseEntryMSD)concentrationResponseEntryMSD);
            ++i;
        }
        return concentrationResponseEntriesMSD;
    }

    private static List<IQuantitationSignalMSD> readQuantitationSignals(DataInputStream dataInputStream) throws Exception {
        ArrayList<IQuantitationSignalMSD> quantitationSignalsMSD = new ArrayList<IQuantitationSignalMSD>();
        int size = dataInputStream.readInt();
        int i = 0;
        while (i < size) {
            double ion = dataInputStream.readDouble();
            float relativeResponse = dataInputStream.readFloat();
            double uncertainty = dataInputStream.readDouble();
            boolean use = dataInputStream.readBoolean();
            QuantitationSignalMSD quantitationSignalMSD = new QuantitationSignalMSD(ion, relativeResponse, uncertainty, use);
            quantitationSignalsMSD.add((IQuantitationSignalMSD)quantitationSignalMSD);
            ++i;
        }
        return quantitationSignalsMSD;
    }

    private static IRetentionIndexWindow readRetentionIndexWindow(DataInputStream dataInputStream) throws Exception {
        RetentionIndexWindow retentionIndexWindow = new RetentionIndexWindow();
        retentionIndexWindow.setAllowedNegativeDeviation(dataInputStream.readFloat());
        retentionIndexWindow.setAllowedPositiveDeviation(dataInputStream.readFloat());
        retentionIndexWindow.setRetentionIndex(dataInputStream.readFloat());
        return retentionIndexWindow;
    }

    private static IRetentionTimeWindow readRetentionTimeWindow(DataInputStream dataInputStream) throws Exception {
        RetentionTimeWindow retentionTimeWindow = new RetentionTimeWindow();
        retentionTimeWindow.setAllowedNegativeDeviation(dataInputStream.readFloat());
        retentionTimeWindow.setAllowedPositiveDeviation(dataInputStream.readFloat());
        retentionTimeWindow.setRetentionTime(dataInputStream.readInt());
        return retentionTimeWindow;
    }

    private static IPeakMSD readPeak(DataInputStream dataInputStream, IIonTransitionSettings ionTransitionSettings) throws IOException, IllegalArgumentException, PeakException {
        String detectorDescription = QuantDatabaseReader.readString(dataInputStream);
        String quantifierDescription = QuantDatabaseReader.readString(dataInputStream);
        boolean activeForAnalysis = dataInputStream.readBoolean();
        String integratorDescription = QuantDatabaseReader.readString(dataInputStream);
        String modelDescription = QuantDatabaseReader.readString(dataInputStream);
        PeakType peakType = PeakType.valueOf((String)QuantDatabaseReader.readString(dataInputStream));
        int suggestedNumberOfComponents = dataInputStream.readInt();
        float startBackgroundAbundance = dataInputStream.readFloat();
        float stopBackgroundAbundance = dataInputStream.readFloat();
        IPeakMassSpectrum peakMaximum = QuantDatabaseReader.readPeakMassSpectrum(dataInputStream, ionTransitionSettings);
        int numberOfRetentionTimes = dataInputStream.readInt();
        PeakIntensityValues intensityValues = new PeakIntensityValues(Float.MAX_VALUE);
        int i = 1;
        while (i <= numberOfRetentionTimes) {
            int retentionTime = dataInputStream.readInt();
            float relativeIntensity = dataInputStream.readFloat();
            intensityValues.addIntensityValue(retentionTime, relativeIntensity);
            ++i;
        }
        intensityValues.normalize();
        PeakModelMSD peakModel = new PeakModelMSD(peakMaximum, (IPeakIntensityValues)intensityValues, startBackgroundAbundance, stopBackgroundAbundance);
        PeakMSD peak = new PeakMSD((IPeakModelMSD)peakModel);
        peak.setDetectorDescription(detectorDescription);
        peak.setQuantifierDescription(quantifierDescription);
        peak.setActiveForAnalysis(activeForAnalysis);
        peak.setIntegratorDescription(integratorDescription);
        peak.setModelDescription(modelDescription);
        peak.setPeakType(peakType);
        peak.setSuggestedNumberOfComponents(suggestedNumberOfComponents);
        List<IIntegrationEntry> integrationEntries = QuantDatabaseReader.readIntegrationEntries(dataInputStream);
        peak.setIntegratedArea(integrationEntries, integratorDescription);
        QuantDatabaseReader.readPeakIdentificationTargets(dataInputStream, (IPeakMSD)peak);
        QuantDatabaseReader.readPeakQuantitationEntries(dataInputStream, (IPeakMSD)peak);
        boolean readOptimizedMassSpectrum = dataInputStream.readBoolean();
        if (readOptimizedMassSpectrum) {
            ScanMSD optimizedMassSpectrum = new ScanMSD();
            QuantDatabaseReader.readNormalMassSpectrum((IScanMSD)optimizedMassSpectrum, dataInputStream, ionTransitionSettings);
            peakMaximum.setOptimizedMassSpectrum((IScanMSD)optimizedMassSpectrum);
        }
        return peak;
    }

    private static IPeakMassSpectrum readPeakMassSpectrum(DataInputStream dataInputStream, IIonTransitionSettings ionTransitionSettings) throws IOException {
        short massSpectrometer = dataInputStream.readShort();
        short massSpectrumType = dataInputStream.readShort();
        double precursorIon = dataInputStream.readDouble();
        PeakMassSpectrum massSpectrum = new PeakMassSpectrum();
        massSpectrum.setMassSpectrometer(massSpectrometer);
        massSpectrum.setMassSpectrumType(massSpectrumType);
        massSpectrum.setPrecursorIon(precursorIon);
        QuantDatabaseReader.readNormalMassSpectrum((IScanMSD)massSpectrum, dataInputStream, ionTransitionSettings);
        return massSpectrum;
    }

    private static void readNormalMassSpectrum(IScanMSD massSpectrum, DataInputStream dataInputStream, IIonTransitionSettings ionTransitionSettings) throws IOException {
        int retentionTime = dataInputStream.readInt();
        int retentionTimeColumn1 = dataInputStream.readInt();
        int retentionTimeColumn2 = dataInputStream.readInt();
        float retentionIndex = dataInputStream.readFloat();
        if (dataInputStream.readBoolean()) {
            int size = dataInputStream.readInt();
            int i = 0;
            while (i < size) {
                RetentionIndexType retentionIndexType = RetentionIndexType.valueOf((String)QuantDatabaseReader.readString(dataInputStream));
                float retentionIndexAdditional = dataInputStream.readFloat();
                massSpectrum.setRetentionIndex(retentionIndexType, retentionIndexAdditional);
                ++i;
            }
        }
        int timeSegmentId = dataInputStream.readInt();
        int cycleNumber = dataInputStream.readInt();
        massSpectrum.setRetentionTime(retentionTime);
        massSpectrum.setRetentionTimeColumn1(retentionTimeColumn1);
        massSpectrum.setRetentionTimeColumn2(retentionTimeColumn2);
        massSpectrum.setRetentionIndex(retentionIndex);
        massSpectrum.setTimeSegmentId(timeSegmentId);
        massSpectrum.setCycleNumber(cycleNumber);
        int numberOfIons = dataInputStream.readInt();
        int i = 1;
        while (i <= numberOfIons) {
            try {
                IIon ion = QuantDatabaseReader.readIon(dataInputStream, ionTransitionSettings);
                massSpectrum.addIon(ion);
            }
            catch (AbundanceLimitExceededException e) {
                logger.warn((Object)e);
            }
            catch (IonLimitExceededException e) {
                logger.warn((Object)e);
            }
            catch (IonTransitionIsNullException e) {
                logger.warn((Object)e);
            }
            ++i;
        }
        QuantDatabaseReader.readMassSpectrumIdentificationTargets(dataInputStream, massSpectrum);
    }

    private static IIon readIon(DataInputStream dataInputStream, IIonTransitionSettings ionTransitionSettings) throws IOException, AbundanceLimitExceededException, IonLimitExceededException, IonTransitionIsNullException {
        Ion ion;
        double mz = dataInputStream.readDouble();
        float abundance = dataInputStream.readFloat();
        int transition = dataInputStream.readInt();
        if (transition == 0) {
            ion = new Ion(mz, abundance);
        } else {
            String compoundName = QuantDatabaseReader.readString(dataInputStream);
            double filter1FirstIon = dataInputStream.readDouble();
            double filter1LastIon = dataInputStream.readDouble();
            double filter3FirstIon = dataInputStream.readDouble();
            double filter3LastIon = dataInputStream.readDouble();
            double collisionEnergy = dataInputStream.readDouble();
            double filter1Resolution = dataInputStream.readDouble();
            double filter3Resolution = dataInputStream.readDouble();
            int transitionGroup = dataInputStream.readInt();
            int dwell = dataInputStream.readInt();
            IIonTransition ionTransition = ionTransitionSettings.getIonTransition(compoundName, filter1FirstIon, filter1LastIon, filter3FirstIon, filter3LastIon, collisionEnergy, filter1Resolution, filter3Resolution, transitionGroup);
            ionTransition.setDwell(dwell);
            ion = new Ion(mz, abundance, ionTransition);
        }
        return ion;
    }

    private static void readMassSpectrumIdentificationTargets(DataInputStream dataInputStream, IScanMSD massSpectrum) throws IOException {
        int numberOfMassSpectrumTargets = dataInputStream.readInt();
        int i = 1;
        while (i <= numberOfMassSpectrumTargets) {
            String identifier = QuantDatabaseReader.readString(dataInputStream);
            boolean manuallyVerified = dataInputStream.readBoolean();
            String casNumber = QuantDatabaseReader.readString(dataInputStream);
            String comments = QuantDatabaseReader.readString(dataInputStream);
            String referenceIdentifier = QuantDatabaseReader.readString(dataInputStream);
            String miscellaneous = QuantDatabaseReader.readString(dataInputStream);
            String database = QuantDatabaseReader.readString(dataInputStream);
            String contributor = QuantDatabaseReader.readString(dataInputStream);
            String name = QuantDatabaseReader.readString(dataInputStream);
            HashSet<String> synonyms = new HashSet<String>();
            int numberOfSynonyms = dataInputStream.readInt();
            int j = 0;
            while (j < numberOfSynonyms) {
                synonyms.add(QuantDatabaseReader.readString(dataInputStream));
                ++j;
            }
            String formula = QuantDatabaseReader.readString(dataInputStream);
            String smiles = QuantDatabaseReader.readString(dataInputStream);
            String inChI = QuantDatabaseReader.readString(dataInputStream);
            double molWeight = dataInputStream.readDouble();
            float matchFactor = dataInputStream.readFloat();
            float matchFactorDirect = dataInputStream.readFloat();
            float reverseMatchFactor = dataInputStream.readFloat();
            float reverseMatchFactorDirect = dataInputStream.readFloat();
            float probability = dataInputStream.readFloat();
            boolean isMatch = dataInputStream.readBoolean();
            MassSpectrumLibraryInformation libraryInformation = new MassSpectrumLibraryInformation();
            libraryInformation.setCasNumber(casNumber);
            libraryInformation.setComments(comments);
            libraryInformation.setReferenceIdentifier(referenceIdentifier);
            libraryInformation.setMiscellaneous(miscellaneous);
            libraryInformation.setDatabase(database);
            libraryInformation.setContributor(contributor);
            libraryInformation.setName(name);
            libraryInformation.setSynonyms(synonyms);
            libraryInformation.setFormula(formula);
            libraryInformation.setSmiles(smiles);
            libraryInformation.setInChI(inChI);
            libraryInformation.setMolWeight(molWeight);
            MassSpectrumComparisonResult comparisonResult = new MassSpectrumComparisonResult(matchFactor, reverseMatchFactor, matchFactorDirect, reverseMatchFactorDirect, probability);
            comparisonResult.setMatch(isMatch);
            try {
                MassSpectrumTarget identificationEntry = new MassSpectrumTarget((ILibraryInformation)libraryInformation, (IComparisonResult)comparisonResult);
                identificationEntry.setIdentifier(identifier);
                identificationEntry.setManuallyVerified(manuallyVerified);
                massSpectrum.addTarget((IMassSpectrumTarget)identificationEntry);
            }
            catch (ReferenceMustNotBeNullException e) {
                logger.warn((Object)e);
            }
            ++i;
        }
    }

    private static List<IIntegrationEntry> readIntegrationEntries(DataInputStream dataInputStream) throws IOException {
        ArrayList<IIntegrationEntry> integrationEntries = new ArrayList<IIntegrationEntry>();
        int numberOfIntegrationEntries = dataInputStream.readInt();
        int i = 1;
        while (i <= numberOfIntegrationEntries) {
            double ion = dataInputStream.readDouble();
            double integratedArea = dataInputStream.readDouble();
            IntegrationEntryMSD integrationEntry = new IntegrationEntryMSD(ion, integratedArea);
            integrationEntries.add((IIntegrationEntry)integrationEntry);
            ++i;
        }
        return integrationEntries;
    }

    private static void readPeakIdentificationTargets(DataInputStream dataInputStream, IPeakMSD peak) throws IOException {
        int numberOfPeakTargets = dataInputStream.readInt();
        int i = 1;
        while (i <= numberOfPeakTargets) {
            String identifier = QuantDatabaseReader.readString(dataInputStream);
            boolean manuallyVerified = dataInputStream.readBoolean();
            String casNumber = QuantDatabaseReader.readString(dataInputStream);
            String comments = QuantDatabaseReader.readString(dataInputStream);
            String referenceIdentifier = QuantDatabaseReader.readString(dataInputStream);
            String miscellaneous = QuantDatabaseReader.readString(dataInputStream);
            String database = QuantDatabaseReader.readString(dataInputStream);
            String contributor = QuantDatabaseReader.readString(dataInputStream);
            String name = QuantDatabaseReader.readString(dataInputStream);
            HashSet<String> synonyms = new HashSet<String>();
            int numberOfSynonyms = dataInputStream.readInt();
            int j = 0;
            while (j < numberOfSynonyms) {
                synonyms.add(QuantDatabaseReader.readString(dataInputStream));
                ++j;
            }
            String formula = QuantDatabaseReader.readString(dataInputStream);
            String smiles = QuantDatabaseReader.readString(dataInputStream);
            String inChI = QuantDatabaseReader.readString(dataInputStream);
            double molWeight = dataInputStream.readDouble();
            float matchFactor = dataInputStream.readFloat();
            float matchFactorDirect = dataInputStream.readFloat();
            float reverseMatchFactor = dataInputStream.readFloat();
            float reverseMatchFactorDirect = dataInputStream.readFloat();
            float probability = dataInputStream.readFloat();
            boolean isMatch = dataInputStream.readBoolean();
            PeakLibraryInformation libraryInformation = new PeakLibraryInformation();
            libraryInformation.setCasNumber(casNumber);
            libraryInformation.setComments(comments);
            libraryInformation.setReferenceIdentifier(referenceIdentifier);
            libraryInformation.setMiscellaneous(miscellaneous);
            libraryInformation.setDatabase(database);
            libraryInformation.setContributor(contributor);
            libraryInformation.setName(name);
            libraryInformation.setSynonyms(synonyms);
            libraryInformation.setFormula(formula);
            libraryInformation.setSmiles(smiles);
            libraryInformation.setInChI(inChI);
            libraryInformation.setMolWeight(molWeight);
            PeakComparisonResult comparisonResult = new PeakComparisonResult(matchFactor, reverseMatchFactor, matchFactorDirect, reverseMatchFactorDirect, probability);
            comparisonResult.setMatch(isMatch);
            try {
                PeakTarget identificationEntry = new PeakTarget((ILibraryInformation)libraryInformation, (IComparisonResult)comparisonResult);
                identificationEntry.setIdentifier(identifier);
                identificationEntry.setManuallyVerified(manuallyVerified);
                peak.addTarget((IPeakTarget)identificationEntry);
            }
            catch (ReferenceMustNotBeNullException e) {
                logger.warn((Object)e);
            }
            ++i;
        }
    }

    private static void readPeakQuantitationEntries(DataInputStream dataInputStream, IPeakMSD peak) throws IOException {
        int numberOfQuantitationEntries = dataInputStream.readInt();
        int i = 1;
        while (i <= numberOfQuantitationEntries) {
            QuantitationEntry quantitationEntry;
            String name = QuantDatabaseReader.readString(dataInputStream);
            String chemicalClass = QuantDatabaseReader.readString(dataInputStream);
            double concentration = dataInputStream.readDouble();
            String concentrationUnit = QuantDatabaseReader.readString(dataInputStream);
            double area = dataInputStream.readDouble();
            String calibrationMethod = QuantDatabaseReader.readString(dataInputStream);
            boolean usedCrossZero = dataInputStream.readBoolean();
            String description = QuantDatabaseReader.readString(dataInputStream);
            boolean isMSD = dataInputStream.readBoolean();
            if (isMSD) {
                double ion = dataInputStream.readDouble();
                quantitationEntry = new QuantitationEntryMSD(name, concentration, concentrationUnit, area, ion);
            } else {
                quantitationEntry = new QuantitationEntry(name, concentration, concentrationUnit, area);
            }
            quantitationEntry.setChemicalClass(chemicalClass);
            quantitationEntry.setCalibrationMethod(calibrationMethod);
            quantitationEntry.setUsedCrossZero(usedCrossZero);
            quantitationEntry.setDescription(description);
            peak.addQuantitationEntry((IQuantitationEntry)quantitationEntry);
            ++i;
        }
    }

    private static String readString(DataInputStream dataInputStream) throws IOException {
        int length = dataInputStream.readInt();
        StringBuilder builder = new StringBuilder();
        int i = 1;
        while (i <= length) {
            builder.append(String.valueOf(dataInputStream.readChar()));
            ++i;
        }
        return builder.toString();
    }
}

