/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.manual.ui.swt;

import org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.manual.ui.swt.ManualExtendedPeakUI;
import org.eclipse.chemclipse.csd.model.core.IChromatogramPeakCSD;
import org.eclipse.chemclipse.csd.model.core.selection.ChromatogramSelectionCSD;
import org.eclipse.chemclipse.csd.model.core.selection.IChromatogramSelectionCSD;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.selection.ChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class ManualDetectedPeakUI
extends Composite {
    private IPeak peak;
    private IChromatogramSelection chromatogramSelection;
    private Button buttonAdd;
    private ManualExtendedPeakUI manualExtendedPeakUI;

    public ManualDetectedPeakUI(Composite parent, int style) {
        super(parent, style);
        this.initialize(parent);
    }

    public void update(IChromatogramSelection chromatogramSelection, IPeak peak) {
        this.chromatogramSelection = chromatogramSelection;
        this.peak = peak;
        this.manualExtendedPeakUI.setPeakAndSelection(peak, chromatogramSelection);
    }

    private void initialize(Composite parent) {
        this.setLayout((Layout)new FillLayout());
        Composite composite = new Composite((Composite)this, 4);
        GridLayout layout = new GridLayout();
        layout.makeColumnsEqualWidth = true;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        Composite buttonbar = new Composite(composite, 4);
        buttonbar.setLayout((Layout)new FillLayout());
        this.buttonAdd = new Button(buttonbar, 0);
        this.buttonAdd.setText("Add Peak");
        this.buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ManualDetectedPeakUI.this.chromatogramSelection != null && ManualDetectedPeakUI.this.peak != null) {
                    if (ManualDetectedPeakUI.this.chromatogramSelection instanceof IChromatogramSelectionMSD && ManualDetectedPeakUI.this.peak instanceof IChromatogramPeakMSD) {
                        ((IChromatogramSelectionMSD)ManualDetectedPeakUI.this.chromatogramSelection).getChromatogramMSD().addPeak((IChromatogramPeakMSD)ManualDetectedPeakUI.this.peak);
                        if (ManualDetectedPeakUI.this.chromatogramSelection instanceof ChromatogramSelectionMSD) {
                            ((ChromatogramSelectionMSD)ManualDetectedPeakUI.this.chromatogramSelection).update(true);
                        }
                    } else if (ManualDetectedPeakUI.this.chromatogramSelection instanceof IChromatogramSelectionCSD && ManualDetectedPeakUI.this.peak instanceof IChromatogramPeakCSD) {
                        ((IChromatogramSelectionCSD)ManualDetectedPeakUI.this.chromatogramSelection).getChromatogramCSD().addPeak((IChromatogramPeakCSD)ManualDetectedPeakUI.this.peak);
                        if (ManualDetectedPeakUI.this.chromatogramSelection instanceof ChromatogramSelectionCSD) {
                            ((ChromatogramSelectionCSD)ManualDetectedPeakUI.this.chromatogramSelection).update(true);
                        }
                    }
                }
            }
        });
        this.manualExtendedPeakUI = new ManualExtendedPeakUI(composite, 2052);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.manualExtendedPeakUI.setLayoutData(gridData);
    }
}

