/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.layer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.cell.TranslatedLayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.layer.ILayerPainter;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.util.IClientAreaProvider;

public class AbstractIndexLayerTransform
extends AbstractLayer
implements IUniqueIndexLayer {
    private IUniqueIndexLayer underlyingLayer;

    public AbstractIndexLayerTransform() {
    }

    public AbstractIndexLayerTransform(IUniqueIndexLayer underlyingLayer) {
        this.setUnderlyingLayer(underlyingLayer);
    }

    protected void setUnderlyingLayer(IUniqueIndexLayer underlyingLayer) {
        if (this.underlyingLayer != null) {
            this.underlyingLayer.removeLayerListener(this);
        }
        this.underlyingLayer = underlyingLayer;
        this.underlyingLayer.setClientAreaProvider(this.getClientAreaProvider());
        this.underlyingLayer.addLayerListener(this);
    }

    protected final IUniqueIndexLayer getUnderlyingLayer() {
        return this.underlyingLayer;
    }

    @Override
    public void dispose() {
        this.underlyingLayer.dispose();
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        this.underlyingLayer.saveState(prefix, properties);
        super.saveState(prefix, properties);
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        super.loadState(prefix, properties);
        this.underlyingLayer.loadState(prefix, properties);
    }

    @Override
    public void configure(ConfigRegistry configRegistry, UiBindingRegistry uiBindingRegistry) {
        super.configure(configRegistry, uiBindingRegistry);
        this.underlyingLayer.configure(configRegistry, uiBindingRegistry);
    }

    @Override
    public ILayerPainter getLayerPainter() {
        return this.layerPainter != null ? this.layerPainter : this.underlyingLayer.getLayerPainter();
    }

    @Override
    public boolean doCommand(ILayerCommand command) {
        if (super.doCommand(command)) {
            return true;
        }
        return this.underlyingLayer.doCommand(command);
    }

    @Override
    public void setClientAreaProvider(IClientAreaProvider clientAreaProvider) {
        super.setClientAreaProvider(clientAreaProvider);
        if (this.underlyingLayer != null) {
            this.underlyingLayer.setClientAreaProvider(clientAreaProvider);
        }
    }

    @Override
    public int getColumnCount() {
        return this.underlyingLayer.getColumnCount();
    }

    @Override
    public int getPreferredColumnCount() {
        return this.underlyingLayer.getPreferredColumnCount();
    }

    @Override
    public int getColumnIndexByPosition(int columnPosition) {
        return this.underlyingLayer.getColumnIndexByPosition(this.localToUnderlyingColumnPosition(columnPosition));
    }

    @Override
    public int localToUnderlyingColumnPosition(int localColumnPosition) {
        return localColumnPosition;
    }

    @Override
    public int underlyingToLocalColumnPosition(ILayer sourceUnderlyingLayer, int underlyingColumnPosition) {
        if (sourceUnderlyingLayer != this.underlyingLayer) {
            return -1;
        }
        return underlyingColumnPosition;
    }

    @Override
    public Collection<Range> underlyingToLocalColumnPositions(ILayer sourceUnderlyingLayer, Collection<Range> underlyingColumnPositionRanges) {
        ArrayList<Range> localColumnPositionRanges = new ArrayList<Range>(underlyingColumnPositionRanges.size());
        for (Range underlyingColumnPositionRange : underlyingColumnPositionRanges) {
            localColumnPositionRanges.add(new Range(this.underlyingToLocalColumnPosition(sourceUnderlyingLayer, underlyingColumnPositionRange.start), this.underlyingToLocalColumnPosition(sourceUnderlyingLayer, underlyingColumnPositionRange.end)));
        }
        return localColumnPositionRanges;
    }

    @Override
    public int getColumnPositionByIndex(int columnIndex) {
        return this.underlyingToLocalColumnPosition(this.underlyingLayer, this.underlyingLayer.getColumnPositionByIndex(columnIndex));
    }

    @Override
    public int getWidth() {
        return this.underlyingLayer.getWidth();
    }

    @Override
    public int getPreferredWidth() {
        return this.underlyingLayer.getPreferredWidth();
    }

    @Override
    public int getColumnWidthByPosition(int columnPosition) {
        return this.underlyingLayer.getColumnWidthByPosition(this.localToUnderlyingColumnPosition(columnPosition));
    }

    @Override
    public boolean isColumnPositionResizable(int columnPosition) {
        return this.underlyingLayer.isColumnPositionResizable(this.localToUnderlyingColumnPosition(columnPosition));
    }

    @Override
    public int getColumnPositionByX(int x) {
        return this.underlyingLayer.getColumnPositionByX(x);
    }

    @Override
    public int getStartXOfColumnPosition(int columnPosition) {
        return this.underlyingLayer.getStartXOfColumnPosition(this.localToUnderlyingColumnPosition(columnPosition));
    }

    @Override
    public Collection<ILayer> getUnderlyingLayersByColumnPosition(int columnPosition) {
        HashSet<ILayer> underlyingLayers = new HashSet<ILayer>();
        underlyingLayers.add(this.underlyingLayer);
        return underlyingLayers;
    }

    @Override
    public int getRowCount() {
        return this.underlyingLayer.getRowCount();
    }

    @Override
    public int getPreferredRowCount() {
        return this.underlyingLayer.getPreferredRowCount();
    }

    @Override
    public int getRowIndexByPosition(int rowPosition) {
        return this.underlyingLayer.getRowIndexByPosition(this.localToUnderlyingRowPosition(rowPosition));
    }

    @Override
    public int localToUnderlyingRowPosition(int localRowPosition) {
        return localRowPosition;
    }

    @Override
    public int underlyingToLocalRowPosition(ILayer sourceUnderlyingLayer, int underlyingRowPosition) {
        if (sourceUnderlyingLayer != this.underlyingLayer) {
            return -1;
        }
        return underlyingRowPosition;
    }

    @Override
    public Collection<Range> underlyingToLocalRowPositions(ILayer sourceUnderlyingLayer, Collection<Range> underlyingRowPositionRanges) {
        ArrayList<Range> localRowPositionRanges = new ArrayList<Range>(underlyingRowPositionRanges.size());
        for (Range underlyingRowPositionRange : underlyingRowPositionRanges) {
            localRowPositionRanges.add(new Range(this.underlyingToLocalRowPosition(sourceUnderlyingLayer, underlyingRowPositionRange.start), this.underlyingToLocalRowPosition(sourceUnderlyingLayer, underlyingRowPositionRange.end)));
        }
        return localRowPositionRanges;
    }

    @Override
    public int getRowPositionByIndex(int rowIndex) {
        return this.underlyingToLocalRowPosition(this.underlyingLayer, this.underlyingLayer.getRowPositionByIndex(rowIndex));
    }

    @Override
    public int getHeight() {
        return this.underlyingLayer.getHeight();
    }

    @Override
    public int getPreferredHeight() {
        return this.underlyingLayer.getPreferredHeight();
    }

    @Override
    public int getRowHeightByPosition(int rowPosition) {
        return this.underlyingLayer.getRowHeightByPosition(this.localToUnderlyingRowPosition(rowPosition));
    }

    @Override
    public boolean isRowPositionResizable(int rowPosition) {
        return this.underlyingLayer.isRowPositionResizable(this.localToUnderlyingRowPosition(rowPosition));
    }

    @Override
    public int getRowPositionByY(int y) {
        return this.underlyingLayer.getRowPositionByY(y);
    }

    @Override
    public int getStartYOfRowPosition(int rowPosition) {
        return this.underlyingLayer.getStartYOfRowPosition(this.localToUnderlyingRowPosition(rowPosition));
    }

    @Override
    public Collection<ILayer> getUnderlyingLayersByRowPosition(int rowPosition) {
        HashSet<ILayer> underlyingLayers = new HashSet<ILayer>();
        underlyingLayers.add(this.underlyingLayer);
        return underlyingLayers;
    }

    @Override
    public ILayerCell getCellByPosition(int columnPosition, int rowPosition) {
        ILayerCell cell = this.underlyingLayer.getCellByPosition(this.localToUnderlyingColumnPosition(columnPosition), this.localToUnderlyingRowPosition(rowPosition));
        if (cell == null) {
            return null;
        }
        return new TranslatedLayerCell(cell, this, this.underlyingToLocalColumnPosition(this.underlyingLayer, cell.getOriginColumnPosition()), this.underlyingToLocalRowPosition(this.underlyingLayer, cell.getOriginRowPosition()), this.underlyingToLocalColumnPosition(this.underlyingLayer, cell.getColumnPosition()), this.underlyingToLocalRowPosition(this.underlyingLayer, cell.getRowPosition()));
    }

    @Override
    public String getDisplayModeByPosition(int columnPosition, int rowPosition) {
        return this.underlyingLayer.getDisplayModeByPosition(this.localToUnderlyingColumnPosition(columnPosition), this.localToUnderlyingRowPosition(rowPosition));
    }

    @Override
    public LabelStack getConfigLabelsByPosition(int columnPosition, int rowPosition) {
        String regionName;
        LabelStack configLabels = this.underlyingLayer.getConfigLabelsByPosition(this.localToUnderlyingColumnPosition(columnPosition), this.localToUnderlyingRowPosition(rowPosition));
        IConfigLabelAccumulator configLabelAccumulator = this.getConfigLabelAccumulator();
        if (configLabelAccumulator != null) {
            configLabelAccumulator.accumulateConfigLabels(configLabels, columnPosition, rowPosition);
        }
        if ((regionName = this.getRegionName()) != null) {
            configLabels.addLabel(regionName);
        }
        return configLabels;
    }

    @Override
    public Object getDataValueByPosition(int columnPosition, int rowPosition) {
        return this.underlyingLayer.getDataValueByPosition(this.localToUnderlyingColumnPosition(columnPosition), this.localToUnderlyingRowPosition(rowPosition));
    }

    @Override
    public ICellPainter getCellPainter(int columnPosition, int rowPosition, ILayerCell cell, IConfigRegistry configRegistry) {
        return this.underlyingLayer.getCellPainter(columnPosition, rowPosition, cell, configRegistry);
    }

    @Override
    public LabelStack getRegionLabelsByXY(int x, int y) {
        LabelStack regionLabels = this.underlyingLayer.getRegionLabelsByXY(x, y);
        String regionName = this.getRegionName();
        if (regionName != null) {
            regionLabels.addLabel(regionName);
        }
        return regionLabels;
    }

    @Override
    public ILayer getUnderlyingLayerByPosition(int columnPosition, int rowPosition) {
        return this.underlyingLayer;
    }
}

