/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.peak.detector.support;

import org.eclipse.chemclipse.chromatogram.peak.detector.support.IDetectorSlope;
import org.eclipse.chemclipse.numeric.core.IPoint;
import org.eclipse.chemclipse.numeric.geometry.Slope;

public class DetectorSlope
extends Slope
implements IDetectorSlope {
    private int retentionTime;

    public DetectorSlope(IPoint p1, IPoint p2, int retentionTime) {
        super(p1, p2);
        this.retentionTime = retentionTime;
    }

    @Override
    public int getRetentionTime() {
        return this.retentionTime;
    }

    @Override
    public String getDrift() {
        String drift = "0";
        if (this.getSlope() > 0.0) {
            drift = "+";
        } else if (this.getSlope() < 0.0) {
            drift = "-";
        }
        return drift;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        DetectorSlope otherSlope = (DetectorSlope)other;
        return this.getRetentionTime() == otherSlope.getRetentionTime();
    }

    public int hashCode() {
        return 7 * Integer.valueOf(this.retentionTime).hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append(this.getClass().getName());
        builder.append("[");
        builder.append("retentionTime=" + this.retentionTime);
        builder.append("]");
        return builder.toString();
    }
}

