/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.classifier.supplier.wnc.ui.internal.preferences;

import java.util.ArrayList;
import org.eclipse.chemclipse.chromatogram.msd.classifier.supplier.wnc.model.IWncIon;
import org.eclipse.chemclipse.chromatogram.msd.classifier.supplier.wnc.model.IWncIons;
import org.eclipse.chemclipse.chromatogram.msd.classifier.supplier.wnc.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.msd.classifier.supplier.wnc.ui.internal.preferences.WncIonDialog;
import org.eclipse.chemclipse.chromatogram.msd.classifier.supplier.wnc.ui.internal.provider.WncIonContentProvider;
import org.eclipse.chemclipse.chromatogram.msd.classifier.supplier.wnc.ui.internal.provider.WncIonLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class WncIonsListComposite {
    private IWncIons wncIons;
    private Button addButton;
    private Button editButton;
    private Button removeButton;
    private Label label;
    private TableViewer tableViewer;
    private String[] titles = new String[]{"Name", "ion"};
    private int[] bounds = new int[]{100, 100};
    private FontMetrics fontMetrics;
    private static final int WIDTH_HINT = 400;

    public WncIonsListComposite() {
        this.wncIons = PreferenceSupplier.getWNCIons();
    }

    public Control createContents(Composite parent) {
        this.setFontMetrics(parent);
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        gridData.widthHint = 400;
        composite.setLayoutData((Object)gridData);
        this.label = new Label(composite, 16384);
        this.label.setText("Add and remove ions");
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        this.label.setLayoutData((Object)gridData);
        Composite tableComposite = new Composite(composite, 0);
        tableComposite.setLayout((Layout)new FillLayout());
        gridData = new GridData(4, 4, true, true);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        tableComposite.setLayoutData((Object)gridData);
        this.tableViewer = new TableViewer(tableComposite, 67586);
        this.createColumns(this.tableViewer);
        this.tableViewer.setContentProvider((IContentProvider)new WncIonContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new WncIonLabelProvider());
        this.setTableViewerInput();
        this.createButtonGroup(composite);
        return composite;
    }

    private void createColumns(TableViewer tableViewer) {
        int i = 0;
        while (i < this.titles.length) {
            TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, 0);
            TableColumn tableColumn = tableViewerColumn.getColumn();
            tableColumn.setText(this.titles[i]);
            tableColumn.setWidth(this.bounds[i]);
            tableColumn.setResizable(true);
            tableColumn.setMoveable(true);
            ++i;
        }
        Table table = tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
    }

    private void createButtonGroup(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        buttonComposite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        buttonComposite.setLayoutData((Object)gridData);
        this.addButton = new Button(buttonComposite, 8);
        this.addButton.setText("Add");
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IWncIon wncIon;
                Shell shell = Display.getCurrent().getActiveShell();
                WncIonDialog dialog = new WncIonDialog(shell);
                if (dialog.open() == 0 && (wncIon = dialog.getWNCIon()) != null) {
                    WncIonsListComposite.this.wncIons.add(wncIon);
                    WncIonsListComposite.this.setTableViewerInput();
                }
            }
        });
        this.setButtonLayoutData(this.addButton);
        this.editButton = new Button(buttonComposite, 8);
        this.editButton.setText("Edit");
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection structuredSelection = (IStructuredSelection)WncIonsListComposite.this.tableViewer.getSelection();
                Object object = structuredSelection.getFirstElement();
                if (object instanceof IWncIon) {
                    IWncIon wncIon = (IWncIon)object;
                    Shell shell = Display.getCurrent().getActiveShell();
                    WncIonDialog dialog = new WncIonDialog(shell, wncIon);
                    if (dialog.open() == 0 && (wncIon = dialog.getWNCIon()) != null) {
                        WncIonsListComposite.this.wncIons.add(wncIon);
                        WncIonsListComposite.this.setTableViewerInput();
                    }
                }
            }
        });
        this.setButtonLayoutData(this.editButton);
        this.removeButton = new Button(buttonComposite, 8);
        this.removeButton.setText("Remove");
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArrayList<Integer> removeIons = new ArrayList<Integer>();
                IStructuredSelection structuredSelection = (IStructuredSelection)WncIonsListComposite.this.tableViewer.getSelection();
                Object[] objectArray = structuredSelection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (object instanceof IWncIon) {
                        IWncIon wncIon = (IWncIon)object;
                        removeIons.add(wncIon.getIon());
                    }
                    ++n2;
                }
                for (Integer ion : removeIons) {
                    WncIonsListComposite.this.wncIons.remove(ion);
                }
                WncIonsListComposite.this.setTableViewerInput();
            }
        });
        this.setButtonLayoutData(this.removeButton);
    }

    private void setTableViewerInput() {
        this.tableViewer.setInput((Object)this.wncIons);
    }

    private GridData setButtonLayoutData(Button button) {
        GridData data = new GridData(256);
        int widthHint = Dialog.convertHorizontalDLUsToPixels((FontMetrics)this.fontMetrics, (int)61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
        return data;
    }

    private void setFontMetrics(Composite composite) {
        GC gc = new GC((Drawable)composite);
        gc.setFont(composite.getFont());
        this.fontMetrics = gc.getFontMetrics();
        gc.dispose();
    }

    public boolean performOk() {
        PreferenceSupplier.storeWNCIons((IWncIons)this.wncIons);
        return true;
    }
}

