/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.swt.ui.marker;

import java.text.DecimalFormat;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.chemclipse.swt.ui.marker.ISelectedPositionMarker;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.swtchart.ICustomPaintListener;

public class SelectedPositionMarker
implements ICustomPaintListener,
ISelectedPositionMarker {
    private int retentionTimeInMilliseconds;
    private double retentionTime;
    private double abundance;
    private Color foregroundColor;
    private Color backgroundColor;
    private DecimalFormat decimalFormatRetentionTime;
    private DecimalFormat decimalFormatAbundance;
    private StringBuilder stringBuilder;

    public SelectedPositionMarker(Color foregroundColor, Color backgroundColor) {
        if (foregroundColor == null || backgroundColor == null) {
            foregroundColor = Display.getDefault().getSystemColor(15);
            backgroundColor = Display.getDefault().getSystemColor(1);
        }
        this.foregroundColor = foregroundColor;
        this.backgroundColor = backgroundColor;
        this.decimalFormatRetentionTime = ValueFormat.getDecimalFormatEnglish((String)"0.00");
        this.decimalFormatAbundance = ValueFormat.getDecimalFormatEnglish((String)"0");
    }

    public void paintControl(PaintEvent e) {
        e.gc.setForeground(this.foregroundColor);
        e.gc.setBackground(this.backgroundColor);
        if (this.retentionTime > 0.0) {
            this.stringBuilder = new StringBuilder();
            this.stringBuilder.append("RT (min): ");
            this.stringBuilder.append(this.decimalFormatRetentionTime.format(this.retentionTime));
            this.stringBuilder.append(" AB: ");
            this.stringBuilder.append(this.decimalFormatAbundance.format(this.abundance));
            this.stringBuilder.append("\n");
            this.stringBuilder.append("RT (ms): ");
            this.stringBuilder.append(this.retentionTimeInMilliseconds);
            String label = this.stringBuilder.toString();
            e.gc.drawText(label, 10, 10);
        }
    }

    public boolean drawBehindSeries() {
        return false;
    }

    @Override
    public void setActualPosition(int retentionTimeInMilliseconds, double abundance) {
        this.retentionTimeInMilliseconds = retentionTimeInMilliseconds;
        this.retentionTime = this.getRetentionTimeAsMinutes(retentionTimeInMilliseconds);
        this.abundance = abundance;
    }

    private double getRetentionTimeAsMinutes(int retentionTimeInMilliseconds) {
        return (double)retentionTimeInMilliseconds / 60000.0;
    }
}

