/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.EmbeddedImage;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.Image;
import org.eclipse.birt.chart.model.attribute.ImageSourceType;
import org.eclipse.birt.chart.model.attribute.PatternImage;
import org.eclipse.birt.chart.model.attribute.impl.EmbeddedImageImpl;
import org.eclipse.birt.chart.model.attribute.impl.ImageImpl;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.interfaces.IImageServiceProvider;
import org.eclipse.birt.chart.ui.swt.interfaces.IUIServiceProvider;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.core.ui.frameworks.taskwizard.WizardBase;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ImageDialog
extends TrayDialog {
    private static final String DATA_BASE64 = "data:;base64,";
    protected Button embedded;
    protected Button resource;
    protected Button uri;
    protected Button local;
    protected Button browseButton;
    protected Button previewButton;
    protected List list;
    protected Composite inputArea;
    protected ImageCanvas previewCanvas;
    private Text uriEditor;
    private SelectTypeHandle selectedHandle;
    protected Fill fCurrent;
    private boolean bEmbeddedImageEnabled;
    private boolean bResourceImageEnabled;
    private boolean bLocalImageEnabled;
    protected String imageData;
    protected Label title;
    protected ChartWizardContext context;
    private static final ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.ui.extension/swt.composites");
    protected SelectType selectType;

    public ImageDialog(Shell parentShell, Fill fCurrent, ChartWizardContext context, boolean bEmbeddedImageEnabled, boolean bResourceImageEnabled) {
        super(parentShell);
        this.setHelpAvailable(false);
        this.fCurrent = fCurrent;
        this.context = context;
        this.bEmbeddedImageEnabled = bEmbeddedImageEnabled;
        this.bResourceImageEnabled = bResourceImageEnabled;
    }

    public ImageDialog(Shell parentShell, Fill fCurrent, ChartWizardContext context, boolean bEmbeddedImageEnabled, boolean bResourceImageEnabled, boolean bLocalImageEnabled) {
        this(parentShell, fCurrent, context, bEmbeddedImageEnabled, bResourceImageEnabled);
        this.bLocalImageEnabled = bLocalImageEnabled;
    }

    protected Control createContents(Composite parent) {
        Control ct = super.createContents(parent);
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.SelectImage_ID");
        this.initDialog();
        return ct;
    }

    protected Control createDialogArea(Composite parent) {
        Composite topCompostie = (Composite)super.createDialogArea(parent);
        this.createSelectionArea(topCompostie);
        new Label(topCompostie, 258).setLayoutData((Object)new GridData(768));
        Composite composite = new Composite(topCompostie, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.createInputArea(composite);
        this.createPreviewArea(composite);
        new Label(topCompostie, 258).setLayoutData((Object)new GridData(768));
        return topCompostie;
    }

    protected Composite createSelectionArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        label.setText(Messages.getString("ImageDialog.label.SelectImageType"));
        label.setLayoutData((Object)new GridData(2));
        Composite selectionArea = new Composite(composite, 0);
        selectionArea.setLayout((Layout)new FillLayout(512));
        this.uri = new Button(selectionArea, 16);
        this.uri.setText(Messages.getString("ImageDialog.label.URLImage"));
        this.uri.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImageDialog.this.switchTo(SelectType.URI_TYPE);
            }
        });
        if (this.bResourceImageEnabled) {
            this.resource = new Button(selectionArea, 16);
            this.resource.setText(Messages.getString("ImageDialog.Label.ResourceImage"));
            this.resource.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ImageDialog.this.switchTo(SelectType.RESOURCE_TYPE);
                }
            });
        }
        if (this.bEmbeddedImageEnabled) {
            this.embedded = new Button(selectionArea, 16);
            this.embedded.setText(Messages.getString("ImageDialog.label.EmbeddedImage"));
            this.embedded.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ImageDialog.this.switchTo(SelectType.EMBEDDED_TYPE);
                }
            });
        }
        if (this.bLocalImageEnabled) {
            this.local = new Button(selectionArea, 16);
            this.local.setText(Messages.getString("ImageDialog.label.LocalImage"));
            this.local.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ImageDialog.this.switchTo(SelectType.LOCAL_TYPE);
                }
            });
        }
        return selectionArea;
    }

    private void createInputArea(Composite parent) {
        this.inputArea = new Composite(parent, 0);
        GridData gd = new GridData(1840);
        gd.widthHint = 300;
        gd.heightHint = 300;
        this.inputArea.setLayoutData((Object)gd);
        this.inputArea.setLayout((Layout)new GridLayout());
    }

    protected void switchTo(SelectType selectedType) {
        if (selectedType.equals((Object)this.selectType)) {
            return;
        }
        this.selectedHandle = this.getSelectTypeHandle(selectedType);
        this.switchTo(this.selectedHandle);
    }

    protected void switchTo(SelectTypeHandle selectTypeHandle) {
        Control[] controls = this.inputArea.getChildren();
        int i = 0;
        while (i < controls.length) {
            controls[i].dispose();
            ++i;
        }
        this.title = new Label(this.inputArea, 0);
        this.title.setLayoutData((Object)new GridData(768));
        this.selectedHandle.createInputInnerComposite();
        this.inputArea.layout();
        this.updateButtons();
    }

    protected Composite createInnerComposite() {
        Composite innerComp = new Composite(this.inputArea, 0);
        innerComp.setLayoutData((Object)new GridData(128));
        innerComp.setLayout((Layout)new GridLayout(2, false));
        return innerComp;
    }

    private void createURIEditor() {
        this.uriEditor = new Text(this.inputArea, 2052);
        this.uriEditor.setLayoutData((Object)new GridData(768));
        this.uriEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImageDialog.this.updateButtons();
            }
        });
    }

    private void createResourceBrowseButton(Composite innerComp) {
        this.browseButton = new Button(innerComp, 8);
        this.browseButton.setText(Messages.getString("ImageDialog.label.Browse"));
        this.browseButton.setLayoutData((Object)new GridData(128));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    String path = ImageDialog.this.getUIServiceProvider().invoke(11, null, ImageDialog.this.context.getExtendedItem(), Messages.getString("ImageDialog.label.SelectFile"));
                    if (path != null) {
                        ImageDialog.this.uriEditor.setText(path);
                    }
                }
                catch (ChartException e1) {
                    WizardBase.displayException((Throwable)e1);
                }
            }
        });
    }

    protected void createPreviewButton(Composite innerComp) {
        this.previewButton = new Button(innerComp, 8);
        this.previewButton.setText(Messages.getString("ImageDialog.label.Preview"));
        this.previewButton.setLayoutData((Object)new GridData(128));
        this.previewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImageDialog.this.preview();
            }
        });
    }

    private void createPreviewArea(Composite composite) {
        Composite previewArea = new Composite(composite, 2048);
        GridData gd = new GridData(1808);
        gd.widthHint = 250;
        gd.heightHint = 300;
        previewArea.setLayoutData((Object)gd);
        previewArea.setLayout((Layout)new FillLayout());
        this.previewCanvas = new ImageCanvas(previewArea);
    }

    protected void preview() {
        this.selectedHandle.preview();
    }

    protected void okPressed() {
        this.selectedHandle.performOKPressed();
        super.okPressed();
    }

    protected boolean initDialog() {
        this.getShell().setText(Messages.getString("ImageDialog.label.SelectImage"));
        boolean isEmbedded = this.bEmbeddedImageEnabled && (this.fCurrent instanceof EmbeddedImage || this.fCurrent instanceof Image && ((Image)this.fCurrent).getSource() == ImageSourceType.REPORT);
        boolean isResource = this.bResourceImageEnabled && this.fCurrent instanceof Image && ((Image)this.fCurrent).getSource() == ImageSourceType.FILE;
        boolean isLocal = this.bLocalImageEnabled && this.fCurrent instanceof Image && ((Image)this.fCurrent).getSource() == ImageSourceType.STATIC && ((Image)this.fCurrent).getURL() != null && ((Image)this.fCurrent).getURL().indexOf("file:") == 0;
        this.selectType = SelectType.URI_TYPE;
        if (isEmbedded) {
            this.selectType = SelectType.EMBEDDED_TYPE;
        } else if (isResource) {
            this.selectType = SelectType.RESOURCE_TYPE;
        } else if (isLocal) {
            this.selectType = SelectType.LOCAL_TYPE;
        }
        this.selectedHandle = this.getSelectTypeHandle(this.selectType);
        this.selectedHandle.initDialog();
        this.getButton(0).setEnabled(false);
        return true;
    }

    private void initURIEditor() {
        String uri = "";
        if (this.fCurrent instanceof Image && !(this.fCurrent instanceof PatternImage)) {
            uri = ((Image)this.fCurrent).getURL();
            if (this.fCurrent instanceof EmbeddedImage) {
                this.imageData = ((EmbeddedImage)this.fCurrent).getData();
            }
            if (this.selectType == SelectType.URI_TYPE && (((Image)this.fCurrent).getURL().indexOf("file:") == 0 || ((Image)this.fCurrent).getSource() == ImageSourceType.FILE)) {
                uri = "";
            }
        }
        this.uriEditor.setText(uri);
        this.uriEditor.setFocus();
    }

    protected void updateButtons() {
        boolean complete = this.selectedHandle.isComplete();
        this.previewButton.setEnabled(complete);
        this.getButton(0).setEnabled(complete);
    }

    public Fill getResult() {
        return this.fCurrent;
    }

    protected String removeQuote(String string) {
        if (string == null) {
            return "";
        }
        if (string.trim().length() >= 2 && string.trim().startsWith("\"") && string.trim().endsWith("\"")) {
            return string.trim().substring(1, string.trim().length() - 1);
        }
        return string.trim();
    }

    private boolean checkURIEditorTextIsEmpty() {
        return this.uriEditor.getText() != null && this.uriEditor.getText().trim().length() > 0;
    }

    private SelectTypeHandle getSelectTypeHandle(SelectType selectType) {
        switch (selectType) {
            case URI_TYPE: {
                return new URISelectTypeHandleImpl();
            }
            case RESOURCE_TYPE: {
                return new ResourceSelectTypeHandleImpl();
            }
            case EMBEDDED_TYPE: {
                return this.getEmbeddedSelectTypeHandle();
            }
            case LOCAL_TYPE: {
                return new LocalSelectTypeHandleImpl();
            }
        }
        return null;
    }

    protected SelectTypeHandle getEmbeddedSelectTypeHandle() {
        return new EmbeddedSelectTypeHandleImpl();
    }

    protected IUIServiceProvider getUIServiceProvider() {
        return this.context.getUIServiceProvider();
    }

    protected IImageServiceProvider getImageServiceProvider() {
        return this.context.getImageServiceProvider();
    }

    private class EmbeddedSelectTypeHandleImpl
    implements SelectTypeHandle {
        private EmbeddedSelectTypeHandleImpl() {
        }

        @Override
        public void createInputInnerComposite() {
            ImageDialog.this.title.setText(Messages.getString("ImageDialog.label.EnterEmbed"));
            ImageDialog.this.createURIEditor();
            Composite innerComp = ImageDialog.this.createInnerComposite();
            this.createEmbeddedBrowseButton(innerComp);
            ImageDialog.this.createPreviewButton(innerComp);
        }

        @Override
        public void preview() {
            if (this.isComplete()) {
                String uri = ImageDialog.this.removeQuote(ImageDialog.this.uriEditor.getText());
                ImageDialog.this.previewCanvas.updateCanvas(uri);
            }
        }

        @Override
        public boolean isComplete() {
            boolean complete;
            try {
                URL url = new URL(ImageDialog.this.removeQuote(ImageDialog.this.uriEditor.getText().trim()));
                File file = new File(url.getPath());
                complete = file.exists() && file.isAbsolute();
            }
            catch (Exception exception) {
                complete = false;
            }
            return complete;
        }

        @Override
        public void performOKPressed() {
            block13: {
                BufferedInputStream bis = null;
                try {
                    try {
                        ImageDialog.this.fCurrent = EmbeddedImageImpl.create((String)new File(ImageDialog.this.uriEditor.getText().trim()).getName(), (String)ImageDialog.this.imageData);
                        bis = new BufferedInputStream(new URL(ImageDialog.this.uriEditor.getText().trim()).openStream());
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        byte[] buf = new byte[1024];
                        int count = bis.read(buf);
                        while (count != -1) {
                            bos.write(buf, 0, count);
                            count = bis.read(buf);
                        }
                        String data = new String(Base64.encodeBase64((byte[])bos.toByteArray()));
                        ((EmbeddedImage)ImageDialog.this.fCurrent).setData(data);
                    }
                    catch (Exception e) {
                        WizardBase.displayException((Throwable)e);
                        if (bis == null) break block13;
                        try {
                            bis.close();
                        }
                        catch (IOException e2) {
                            WizardBase.displayException((Throwable)e2);
                        }
                    }
                }
                finally {
                    if (bis != null) {
                        try {
                            bis.close();
                        }
                        catch (IOException e) {
                            WizardBase.displayException((Throwable)e);
                        }
                    }
                }
            }
        }

        @Override
        public void initDialog() {
            ImageDialog.this.embedded.setSelection(true);
            ImageDialog.this.switchTo(this);
            ImageDialog.this.initURIEditor();
            String sUrl = ImageDialog.DATA_BASE64 + ImageDialog.this.imageData;
            ImageDialog.this.previewCanvas.updateCanvas(sUrl);
        }

        private void createEmbeddedBrowseButton(Composite innerComp) {
            ImageDialog.this.browseButton = new Button(innerComp, 8);
            ImageDialog.this.browseButton.setText(Messages.getString("ImageDialog.label.Browse"));
            ImageDialog.this.browseButton.setLayoutData((Object)new GridData(128));
            ImageDialog.this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    FileDialog fileChooser = new FileDialog(ImageDialog.this.getShell(), 4096);
                    fileChooser.setText(Messages.getString("ImageDialog.label.SelectFile"));
                    fileChooser.setFilterExtensions(new String[]{"*.gif", "*.jpg", "*.png"});
                    try {
                        String fileName;
                        String fullPath = fileChooser.open();
                        if (fullPath != null && (fileName = fileChooser.getFileName()) != null) {
                            ((EmbeddedSelectTypeHandleImpl)EmbeddedSelectTypeHandleImpl.this).ImageDialog.this.imageData = null;
                            fullPath = new StringBuffer("file:///").append(fullPath).toString();
                            ImageDialog.this.uriEditor.setText(fullPath);
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    protected static class ImageCanvas
    extends Composite
    implements PaintListener {
        private ImageData imageData;

        public ImageCanvas(Composite parent) {
            super(parent, 0);
            this.addPaintListener(this);
        }

        public void updateCanvas(ImageData data) {
            this.imageData = data;
            this.redraw();
        }

        public void updateCanvas(String sUrl) {
            block18: {
                if (sUrl == null) {
                    return;
                }
                InputStream in = null;
                try {
                    try {
                        if (sUrl.startsWith(ImageDialog.DATA_BASE64)) {
                            byte[] buf = Base64.decodeBase64((byte[])sUrl.substring(ImageDialog.DATA_BASE64.length()).getBytes());
                            in = new ByteArrayInputStream(buf);
                        } else {
                            in = new BufferedInputStream(new URL(sUrl).openStream());
                        }
                        ImageData[] datas = new ImageLoader().load(in);
                        if (datas.length > 0) {
                            this.imageData = datas[0];
                        }
                    }
                    catch (Exception e) {
                        this.imageData = null;
                        logger.log(e);
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Exception exception) {}
                        }
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception exception) {}
                    }
                    throw throwable;
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                }
            }
            this.redraw();
        }

        public void paintControl(PaintEvent e) {
            if (this.imageData == null) {
                return;
            }
            GC gc = e.gc;
            Rectangle destRect = this.getClientArea();
            org.eclipse.swt.graphics.Image img = new org.eclipse.swt.graphics.Image(gc.getDevice(), this.imageData);
            Rectangle srcRect = img.getBounds();
            if (srcRect.width > 0 && srcRect.height > 0) {
                int x = 0;
                int y = 0;
                int w = destRect.width;
                int h = destRect.height;
                if (srcRect.width < w && srcRect.height < h) {
                    w = srcRect.width;
                    h = srcRect.height;
                    x = (destRect.width - w) / 2;
                    y = (destRect.height - h) / 2;
                } else if (1.0 * (double)srcRect.width / (double)srcRect.height >= 1.0 * (double)destRect.width / (double)destRect.height) {
                    double rate = 1.0 * (double)w / (double)srcRect.width;
                    h = (int)((double)srcRect.height * rate + 0.5);
                    y = (destRect.height - h) / 2;
                } else {
                    double rate = 1.0 * (double)h / (double)srcRect.height;
                    w = (int)((double)srcRect.width * rate + 0.5);
                    x = (destRect.width - w) / 2;
                }
                gc.drawImage(img, 0, 0, srcRect.width, srcRect.height, x, y, w, h);
            }
            img.dispose();
        }
    }

    private class LocalSelectTypeHandleImpl
    implements SelectTypeHandle {
        private LocalSelectTypeHandleImpl() {
        }

        @Override
        public void initDialog() {
            ImageDialog.this.local.setSelection(true);
            ImageDialog.this.switchTo(this);
            ImageDialog.this.initURIEditor();
            this.preview();
        }

        @Override
        public void createInputInnerComposite() {
            ImageDialog.this.title.setText(Messages.getString("ImageDialog.label.EnterLocal"));
            ImageDialog.this.createURIEditor();
            Composite innerComp = ImageDialog.this.createInnerComposite();
            this.createLocalBrowseButton(innerComp);
            ImageDialog.this.createPreviewButton(innerComp);
        }

        @Override
        public void preview() {
            if (this.isComplete()) {
                String uri = ImageDialog.this.removeQuote(ImageDialog.this.uriEditor.getText());
                ImageDialog.this.previewCanvas.updateCanvas(uri);
            }
        }

        @Override
        public boolean isComplete() {
            boolean complete;
            try {
                URL url = new URL(ImageDialog.this.removeQuote(ImageDialog.this.uriEditor.getText().trim()));
                File file = new File(url.getPath());
                complete = file.exists() && file.isAbsolute();
            }
            catch (Exception exception) {
                complete = false;
            }
            return complete;
        }

        @Override
        public void performOKPressed() {
            ImageDialog.this.fCurrent = ImageImpl.create((String)ImageDialog.this.removeQuote(ImageDialog.this.uriEditor.getText().trim()));
        }

        private void createLocalBrowseButton(Composite innerComp) {
            ImageDialog.this.browseButton = new Button(innerComp, 8);
            ImageDialog.this.browseButton.setText(Messages.getString("ImageDialog.label.Browse"));
            ImageDialog.this.browseButton.setLayoutData((Object)new GridData(128));
            ImageDialog.this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    FileDialog fileChooser = new FileDialog(ImageDialog.this.getShell(), 4096);
                    fileChooser.setText(Messages.getString("ImageDialog.label.SelectFile"));
                    fileChooser.setFilterExtensions(new String[]{"*.gif", "*.jpg", "*.png"});
                    try {
                        String fileName;
                        String fullPath = fileChooser.open();
                        if (fullPath != null && (fileName = fileChooser.getFileName()) != null) {
                            ((LocalSelectTypeHandleImpl)LocalSelectTypeHandleImpl.this).ImageDialog.this.imageData = null;
                            fullPath = new StringBuffer("file:///").append(fullPath).toString();
                            ImageDialog.this.uriEditor.setText(fullPath);
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    private class ResourceSelectTypeHandleImpl
    implements SelectTypeHandle {
        private ResourceSelectTypeHandleImpl() {
        }

        @Override
        public void createInputInnerComposite() {
            ImageDialog.this.title.setText("Select Image from resource folder");
            ImageDialog.this.createURIEditor();
            Composite innerComp = ImageDialog.this.createInnerComposite();
            ImageDialog.this.createResourceBrowseButton(innerComp);
            ImageDialog.this.createPreviewButton(innerComp);
        }

        @Override
        public void preview() {
            if (this.isComplete()) {
                String fileName = ImageDialog.this.removeQuote(ImageDialog.this.uriEditor.getText());
                try {
                    org.eclipse.swt.graphics.Image image = ImageDialog.this.getImageServiceProvider().loadImage(fileName);
                    ImageDialog.this.previewCanvas.updateCanvas(image.getImageData());
                }
                catch (ChartException e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public boolean isComplete() {
            return ImageDialog.this.checkURIEditorTextIsEmpty();
        }

        @Override
        public void performOKPressed() {
            ImageDialog.this.fCurrent = ImageImpl.create((String)ImageDialog.this.removeQuote(ImageDialog.this.uriEditor.getText().trim()), (ImageSourceType)ImageSourceType.FILE);
        }

        @Override
        public void initDialog() {
            ImageDialog.this.resource.setSelection(true);
            ImageDialog.this.switchTo(this);
            ImageDialog.this.initURIEditor();
            this.preview();
        }
    }

    private static enum SelectType {
        URI_TYPE,
        RESOURCE_TYPE,
        EMBEDDED_TYPE,
        LOCAL_TYPE;

    }

    protected static interface SelectTypeHandle {
        public void initDialog();

        public void createInputInnerComposite();

        public void preview();

        public boolean isComplete();

        public void performOKPressed();
    }

    private class URISelectTypeHandleImpl
    implements SelectTypeHandle {
        private URISelectTypeHandleImpl() {
        }

        @Override
        public void createInputInnerComposite() {
            ImageDialog.this.title.setText(Messages.getString("ImageDialog.label.EnterURL"));
            ImageDialog.this.createURIEditor();
            Composite innerComp = ImageDialog.this.createInnerComposite();
            ImageDialog.this.createPreviewButton(innerComp);
        }

        @Override
        public void preview() {
            if (this.isComplete()) {
                String uri = ImageDialog.this.removeQuote(ImageDialog.this.uriEditor.getText());
                ImageDialog.this.previewCanvas.updateCanvas(uri);
            }
        }

        @Override
        public boolean isComplete() {
            boolean complete;
            try {
                new URL(ImageDialog.this.removeQuote(ImageDialog.this.uriEditor.getText().trim()));
                complete = true;
            }
            catch (Exception exception) {
                complete = false;
            }
            return complete;
        }

        @Override
        public void performOKPressed() {
            ImageDialog.this.fCurrent = ImageImpl.create((String)ImageDialog.this.removeQuote(ImageDialog.this.uriEditor.getText().trim()), (ImageSourceType)ImageSourceType.STATIC);
        }

        @Override
        public void initDialog() {
            ImageDialog.this.uri.setSelection(true);
            ImageDialog.this.switchTo(this);
            ImageDialog.this.initURIEditor();
            this.preview();
        }
    }
}

