/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.csd.ui.views;

import java.text.DecimalFormat;
import javax.inject.Inject;
import org.eclipse.chemclipse.csd.model.core.IScanCSD;
import org.eclipse.chemclipse.csd.model.core.selection.IChromatogramSelectionCSD;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.chemclipse.swt.ui.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.ux.extension.csd.ui.views.AbstractChromatogramSelectionCSDView;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ScanView
extends AbstractChromatogramSelectionCSDView {
    private Label scanNumberLabel;
    private Label retentionTimeLabel;
    private Label retentionIndexLabel;
    private Label totalSignalLabel;
    private DecimalFormat decimalFormat = ValueFormat.getDecimalFormatEnglish((String)"0.000");

    @Inject
    public ScanView(Composite parent, MPart part, EPartService partService, IEventBroker eventBroker) {
        super(part, partService, eventBroker);
        this.createControl(parent);
    }

    @Override
    public void update(IChromatogramSelectionCSD chromatogramSelection, boolean forceReload) {
        if (this.doUpdate(chromatogramSelection)) {
            IScanCSD selectedScan = chromatogramSelection.getSelectedScan();
            this.scanNumberLabel.setText(Integer.toString(selectedScan.getScanNumber()));
            this.retentionTimeLabel.setText(this.decimalFormat.format((double)selectedScan.getRetentionTime() / 60000.0));
            if (PreferenceSupplier.showRetentionIndexWithoutDecimals()) {
                this.retentionIndexLabel.setText(Integer.toString((int)selectedScan.getRetentionIndex()));
            } else {
                this.retentionIndexLabel.setText(this.decimalFormat.format(selectedScan.getRetentionIndex()));
            }
            if (PreferenceSupplier.showAreaWithoutDecimals()) {
                this.totalSignalLabel.setText(Integer.toString((int)selectedScan.getTotalSignal()));
            } else {
                this.totalSignalLabel.setText(this.decimalFormat.format(selectedScan.getTotalSignal()));
            }
        }
    }

    private void createControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(2, false));
        parent.setBackground(Display.getCurrent().getSystemColor(1));
        Label info = new Label(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        FontDescriptor fontDescriptor = FontDescriptor.createFrom((Font)info.getFont()).setStyle(1).setHeight(15);
        info.setFont(fontDescriptor.createFont((Device)info.getDisplay()));
        info.setLayoutData((Object)gridData);
        info.setText("Selected Scan");
        info = new Label(parent, 0);
        info.setText("Scan Number: ");
        this.scanNumberLabel = new Label(parent, 0);
        this.scanNumberLabel.setLayoutData((Object)new GridData(768));
        info = new Label(parent, 0);
        info.setText("Retention Time (Min): ");
        this.retentionTimeLabel = new Label(parent, 0);
        this.retentionTimeLabel.setLayoutData((Object)new GridData(768));
        info = new Label(parent, 0);
        info.setText("Retention Index: ");
        this.retentionIndexLabel = new Label(parent, 0);
        this.retentionIndexLabel.setLayoutData((Object)new GridData(768));
        info = new Label(parent, 0);
        info.setText("Total Signal: ");
        this.totalSignalLabel = new Label(parent, 0);
        this.totalSignalLabel.setLayoutData((Object)new GridData(768));
    }
}

