/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.converter.core;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.chemclipse.converter.core.IConverterSupportSetter;
import org.eclipse.chemclipse.converter.core.ISupplier;
import org.eclipse.chemclipse.converter.exceptions.NoConverterAvailableException;
import org.eclipse.chemclipse.converter.support.FileExtensionCompiler;
import org.eclipse.chemclipse.support.util.FileUtil;

public abstract class AbstractConverterSupport
implements IConverterSupportSetter {
    private List<ISupplier> suppliers = new ArrayList<ISupplier>();
    private Map<String, String> regularExpressions = new HashMap<String, String>();

    public static String getExtensionMatcher(String supplierExtension) {
        String extensionMatcher = supplierExtension.replaceAll("#", "[0-9]");
        return extensionMatcher.replace(".", ".*\\.");
    }

    @Override
    public void add(ISupplier supplier) {
        this.suppliers.add(supplier);
    }

    @Override
    public String getConverterId(int index) throws NoConverterAvailableException {
        this.areConvertersStored();
        if (index < 0 || index > this.suppliers.size() - 1) {
            throw new NoConverterAvailableException("There is no converter available.");
        }
        ISupplier supplier = this.suppliers.get(index);
        return supplier.getId();
    }

    @Override
    public String getConverterId(String name, boolean exportConverterOnly) throws NoConverterAvailableException {
        this.areConvertersStored();
        String id = "";
        for (ISupplier supplier : this.suppliers) {
            if (!supplier.getFilterName().equals(name)) continue;
            if (exportConverterOnly) {
                if (!supplier.isExportable()) continue;
                id = supplier.getId();
                break;
            }
            id = supplier.getId();
            break;
        }
        if (id.equals("")) {
            throw new NoConverterAvailableException("There is no converter available.");
        }
        return id;
    }

    @Override
    public String[] getFilterExtensions() throws NoConverterAvailableException {
        this.areConvertersStored();
        ArrayList<String> extensions = new ArrayList<String>();
        for (ISupplier supplier : this.suppliers) {
            String extension = supplier.getDirectoryExtension().equals("") ? supplier.getFileExtension() : supplier.getDirectoryExtension();
            extensions.add(extension);
        }
        return extensions.toArray(new String[extensions.size()]);
    }

    @Override
    public String[] getExportableFilterExtensions() throws NoConverterAvailableException {
        this.areConvertersStored();
        ArrayList<String> extensions = new ArrayList<String>();
        for (ISupplier supplier : this.suppliers) {
            if (!supplier.isExportable()) continue;
            if (supplier.getDirectoryExtension().equals("")) {
                FileExtensionCompiler fileExtensionCompiler = new FileExtensionCompiler(supplier.getFileExtension(), true);
                extensions.add(fileExtensionCompiler.getCompiledFileExtension());
                continue;
            }
            extensions.add("*.");
        }
        return extensions.toArray(new String[extensions.size()]);
    }

    @Override
    public String[] getFilterNames() throws NoConverterAvailableException {
        this.areConvertersStored();
        ArrayList<String> filterNames = new ArrayList<String>();
        for (ISupplier supplier : this.suppliers) {
            filterNames.add(supplier.getFilterName());
        }
        return filterNames.toArray(new String[filterNames.size()]);
    }

    @Override
    public String[] getExportableFilterNames() throws NoConverterAvailableException {
        this.areConvertersStored();
        ArrayList<String> filterNames = new ArrayList<String>();
        for (ISupplier supplier : this.suppliers) {
            if (!supplier.isExportable()) continue;
            filterNames.add(supplier.getFilterName());
        }
        return filterNames.toArray(new String[filterNames.size()]);
    }

    @Override
    public List<String> getAvailableConverterIds(File file) throws NoConverterAvailableException {
        this.areConvertersStored();
        ArrayList<String> availableConverters = new ArrayList<String>();
        String fileName = file.getName();
        for (ISupplier supplier : this.suppliers) {
            if (file.isDirectory()) {
                String directoryExtension = supplier.getDirectoryExtension();
                if (!fileName.endsWith(directoryExtension) && !fileName.endsWith(directoryExtension.toLowerCase()) && !fileName.endsWith(directoryExtension.toUpperCase())) continue;
                availableConverters.add(supplier.getId());
                continue;
            }
            if (FileUtil.fileHasExtension((File)file)) {
                String fileExtension = supplier.getFileExtension();
                if (fileExtension == null || fileExtension.equals("")) continue;
                if (fileExtension.contains("#")) {
                    String supplierExtension = fileExtension.toLowerCase();
                    String extensionMatcher = this.regularExpressions.get(supplierExtension);
                    if (extensionMatcher == null) {
                        extensionMatcher = AbstractConverterSupport.getExtensionMatcher(supplierExtension);
                        this.regularExpressions.put(supplierExtension, extensionMatcher);
                    }
                    if (!fileName.toLowerCase().matches(extensionMatcher)) continue;
                    availableConverters.add(supplier.getId());
                    continue;
                }
                if (!fileName.endsWith(fileExtension) && !fileName.endsWith(fileExtension.toLowerCase()) && !fileName.endsWith(fileExtension.toUpperCase())) continue;
                availableConverters.add(supplier.getId());
                continue;
            }
            String supplierFileName = supplier.getFileName().toLowerCase();
            if (supplierFileName == null || supplierFileName.equals("") || !fileName.endsWith(supplierFileName) && !fileName.endsWith(supplierFileName.toLowerCase()) && !fileName.endsWith(supplierFileName.toUpperCase())) continue;
            availableConverters.add(supplier.getId());
        }
        if (availableConverters.isEmpty()) {
            throw new NoConverterAvailableException("There is no converter available to process the file: " + file.toString());
        }
        return availableConverters;
    }

    @Override
    public List<ISupplier> getSupplier() {
        return this.suppliers;
    }

    @Override
    public ISupplier getSupplier(String id) throws NoConverterAvailableException {
        ISupplier instance = null;
        for (ISupplier supplier : this.suppliers) {
            if (!supplier.getId().equals(id)) continue;
            instance = supplier;
            break;
        }
        if (instance == null) {
            throw new NoConverterAvailableException("There is no converter available with the given id: " + id + ".");
        }
        return instance;
    }

    @Override
    public List<ISupplier> getExportSupplier() {
        ArrayList<ISupplier> exportSupplier = new ArrayList<ISupplier>();
        for (ISupplier supplier : this.suppliers) {
            if (!supplier.isExportable()) continue;
            exportSupplier.add(supplier);
        }
        return exportSupplier;
    }

    private void areConvertersStored() throws NoConverterAvailableException {
        if (this.suppliers.size() < 1) {
            throw new NoConverterAvailableException();
        }
    }
}

