/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.equation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.ejml.data.DenseMatrix64F;
import org.ejml.equation.Function;
import org.ejml.equation.ManagerFunctions;
import org.ejml.equation.ManagerTempVariables;
import org.ejml.equation.MatrixConstructor;
import org.ejml.equation.Operation;
import org.ejml.equation.Sequence;
import org.ejml.equation.Symbol;
import org.ejml.equation.TokenList;
import org.ejml.equation.Variable;
import org.ejml.equation.VariableDouble;
import org.ejml.equation.VariableInteger;
import org.ejml.equation.VariableMatrix;
import org.ejml.equation.VariableScalar;
import org.ejml.equation.VariableSpecial;
import org.ejml.simple.SimpleMatrix;

public class Equation {
    HashMap<String, Variable> variables = new HashMap();
    char[] storage = new char[1024];
    ManagerFunctions functions = new ManagerFunctions();

    public Equation() {
        this.alias(Math.PI, "pi");
        this.alias(Math.E, "e");
    }

    public void alias(DenseMatrix64F variable, String name) {
        if (this.isReserved(name)) {
            throw new RuntimeException("Reserved word or contains a reserved character");
        }
        VariableMatrix old = (VariableMatrix)this.variables.get(name);
        if (old == null) {
            this.variables.put(name, new VariableMatrix(variable));
        } else {
            old.matrix = variable;
        }
    }

    public void alias(SimpleMatrix variable, String name) {
        this.alias(variable.getMatrix(), name);
    }

    public void alias(double value, String name) {
        if (this.isReserved(name)) {
            throw new RuntimeException("Reserved word or contains a reserved character");
        }
        VariableDouble old = (VariableDouble)this.variables.get(name);
        if (old == null) {
            this.variables.put(name, new VariableDouble(value));
        } else {
            old.value = value;
        }
    }

    public void alias(int value, String name) {
        if (this.isReserved(name)) {
            throw new RuntimeException("Reserved word or contains a reserved character");
        }
        VariableInteger old = (VariableInteger)this.variables.get(name);
        if (old == null) {
            this.variables.put(name, new VariableInteger(value));
        } else {
            old.value = value;
        }
    }

    public void alias(Object ... args) {
        if (args.length % 2 == 1) {
            throw new RuntimeException("Even number of arguments expected");
        }
        int i = 0;
        while (i < args.length) {
            if (args[i].getClass() == Integer.class) {
                this.alias((Integer)args[i], (String)args[i + 1]);
            } else if (args[i].getClass() == Double.class) {
                this.alias((Double)args[i], (String)args[i + 1]);
            } else if (args[i].getClass() == DenseMatrix64F.class) {
                this.alias((DenseMatrix64F)args[i], (String)args[i + 1]);
            } else if (args[i].getClass() == SimpleMatrix.class) {
                this.alias((SimpleMatrix)args[i], (String)args[i + 1]);
            } else {
                throw new RuntimeException("Unknown value type " + args[i]);
            }
            i += 2;
        }
    }

    public Sequence compile(String equation) {
        return this.compile(equation, false);
    }

    public Sequence compile(String equation, boolean debug) {
        TokenList.Token t0;
        ManagerTempVariables managerTemp = new ManagerTempVariables();
        this.functions.setManagerTemp(managerTemp);
        Sequence sequence = new Sequence();
        TokenList tokens = this.extractTokens(equation, managerTemp);
        if (tokens.size() < 3) {
            throw new RuntimeException("Too few tokens");
        }
        if (debug) {
            System.out.println("Parsed tokens:\n------------");
            tokens.print();
            System.out.println();
        }
        if ((t0 = tokens.getFirst()).getType() != TokenList.Type.VARIABLE && t0.getType() != TokenList.Type.WORD) {
            throw new RuntimeException("Expected variable name first.  Not " + t0);
        }
        List<Variable> range = this.parseAssignRange(sequence, tokens, t0);
        TokenList.Token t1 = t0.next;
        if (t1.getType() != TokenList.Type.SYMBOL || t1.getSymbol() != Symbol.ASSIGN) {
            throw new RuntimeException("Expected assign next");
        }
        TokenList tokensRight = tokens.extractSubList(t1.next, tokens.last);
        this.checkForUnknownVariables(tokensRight);
        this.handleParentheses(tokensRight, sequence);
        if (tokensRight.size() != 1) {
            throw new RuntimeException("BUG");
        }
        if (tokensRight.getLast().getType() != TokenList.Type.VARIABLE) {
            throw new RuntimeException("BUG the last token must be a variable");
        }
        Variable variableRight = tokensRight.getFirst().getVariable();
        if (range == null) {
            Variable output = this.createVariableInferred(t0, variableRight);
            sequence.addOperation(Operation.copy(variableRight, output));
        } else {
            if (t0.getType() == TokenList.Type.WORD) {
                throw new RuntimeException("Can't do lazy variable initialization with submatrices. " + t0.getWord());
            }
            sequence.addOperation(Operation.copy(variableRight, t0.getVariable(), range));
        }
        if (debug) {
            System.out.println("Operations:\n------------");
            int i = 0;
            while (i < sequence.operations.size()) {
                System.out.println(sequence.operations.get(i).name());
                ++i;
            }
        }
        return sequence;
    }

    private void checkForUnknownVariables(TokenList tokens) {
        TokenList.Token t = tokens.getFirst();
        while (t != null) {
            if (t.getType() == TokenList.Type.WORD) {
                throw new RuntimeException("Unknown variable on right side. " + t.getWord());
            }
            t = t.next;
        }
    }

    private Variable createVariableInferred(TokenList.Token t0, Variable variableRight) {
        Variable result;
        if (t0.getType() == TokenList.Type.WORD) {
            switch (variableRight.getType()) {
                case MATRIX: {
                    this.alias(new DenseMatrix64F(1, 1), t0.getWord());
                    break;
                }
                case SCALAR: {
                    if (variableRight instanceof VariableInteger) {
                        this.alias(0, t0.getWord());
                        break;
                    }
                    this.alias(1.0, t0.getWord());
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown type");
                }
            }
            result = this.variables.get(t0.getWord());
        } else {
            result = t0.getVariable();
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<Variable> parseAssignRange(Sequence sequence, TokenList tokens, TokenList.Token t0) {
        TokenList.Token t1 = t0.next;
        if (t1.getType() != TokenList.Type.SYMBOL) throw new RuntimeException("Expecting symbol after first variable");
        if (t1.symbol == Symbol.ASSIGN) {
            return null;
        }
        if (t1.symbol != Symbol.PAREN_LEFT) throw new RuntimeException("Expected assign or submatrix");
        ArrayList<Variable> range = new ArrayList<Variable>();
        TokenList.Token t2 = t1.next;
        while (t2 != null && t2.symbol != Symbol.PAREN_RIGHT) {
            t2 = t2.next;
        }
        if (t2 == null) {
            throw new RuntimeException("Could not find closing )");
        }
        TokenList.Token n = t2.next;
        TokenList sublist = tokens.extractSubList(t1, t2);
        sublist.remove(sublist.first);
        sublist.remove(sublist.last);
        this.parseSubmatrixRange(sublist, sequence, range);
        t1 = n;
        if (t1.symbol == Symbol.ASSIGN) return range;
        throw new RuntimeException("Expected assign after sub-matrix");
    }

    protected void handleParentheses(TokenList tokens, Sequence sequence) {
        ArrayList<TokenList.Token> left = new ArrayList<TokenList.Token>();
        TokenList.Token t = tokens.first;
        while (t != null) {
            TokenList.Token next = t.next;
            if (t.getType() == TokenList.Type.SYMBOL) {
                if (t.getSymbol() == Symbol.PAREN_LEFT) {
                    left.add(t);
                } else if (t.getSymbol() == Symbol.PAREN_RIGHT) {
                    if (left.isEmpty()) {
                        throw new RuntimeException(") found with no matching (");
                    }
                    TokenList.Token a = (TokenList.Token)left.remove(left.size() - 1);
                    TokenList.Token before = a.previous;
                    TokenList sublist = tokens.extractSubList(a, t);
                    sublist.remove(sublist.first);
                    sublist.remove(sublist.last);
                    if (before != null && before.getType() == TokenList.Type.FUNCTION) {
                        List<TokenList.Token> inputs = this.parseParameterCommaBlock(sublist, sequence);
                        if (inputs.isEmpty()) {
                            throw new RuntimeException("Empty function input parameters");
                        }
                        this.createFunction(before, inputs, tokens, sequence);
                    } else if (before != null && before.getType() == TokenList.Type.VARIABLE) {
                        TokenList.Token extract = this.parseSubmatrixToExtract(before, sublist, sequence);
                        tokens.insert(before, extract);
                        tokens.remove(before);
                    } else {
                        TokenList.Token output = this.parseBlockNoParentheses(sublist, sequence);
                        if (output != null) {
                            tokens.insert(before, output);
                        }
                    }
                }
            }
            t = next;
        }
        if (!left.isEmpty()) {
            throw new RuntimeException("Dangling ( parentheses");
        }
        if (tokens.size() > 1) {
            this.parseBlockNoParentheses(tokens, sequence);
        }
    }

    protected List<TokenList.Token> parseParameterCommaBlock(TokenList tokens, Sequence sequence) {
        ArrayList<TokenList.Token> commas = new ArrayList<TokenList.Token>();
        TokenList.Token token = tokens.first;
        while (token != null) {
            if (token.getType() == TokenList.Type.SYMBOL && token.getSymbol() == Symbol.COMMA) {
                commas.add(token);
            }
            token = token.next;
        }
        ArrayList<TokenList.Token> output = new ArrayList<TokenList.Token>();
        if (commas.isEmpty()) {
            output.add(this.parseBlockNoParentheses(tokens, sequence));
        } else {
            TokenList.Token before = tokens.first;
            int i = 0;
            while (i < commas.size()) {
                TokenList.Token after = (TokenList.Token)commas.get(i);
                if (before == after) {
                    throw new RuntimeException("No empty function inputs allowed!");
                }
                TokenList.Token tmp = after.next;
                TokenList sublist = tokens.extractSubList(before, after);
                sublist.remove(after);
                output.add(this.parseBlockNoParentheses(sublist, sequence));
                before = tmp;
                ++i;
            }
            if (before == null) {
                throw new RuntimeException("No empty function inputs allowed!");
            }
            TokenList.Token after = tokens.last;
            TokenList sublist = tokens.extractSubList(before, after);
            output.add(this.parseBlockNoParentheses(sublist, sequence));
        }
        return output;
    }

    protected TokenList.Token parseSubmatrixToExtract(TokenList.Token variableTarget, TokenList tokens, Sequence sequence) {
        Operation.Info info;
        ArrayList<Variable> variables = new ArrayList<Variable>();
        variables.add(variableTarget.getVariable());
        this.parseSubmatrixRange(tokens, sequence, variables);
        if (variables.get(1) == variables.get(2) && variables.get(3) == variables.get(4)) {
            variables.remove(4);
            variables.remove(2);
            info = this.functions.create("extractScalar", variables);
        } else {
            info = this.functions.create("extract", variables);
        }
        sequence.addOperation(info.op);
        return new TokenList.Token(info.output);
    }

    private void parseSubmatrixRange(TokenList tokens, Sequence sequence, List<Variable> variables) {
        TokenList.Token comma = tokens.first;
        while (comma != null && comma.getSymbol() != Symbol.COMMA) {
            comma = comma.next;
        }
        if (comma == null) {
            throw new RuntimeException("Can't find comma inside submatrix");
        }
        TokenList listLeft = tokens.extractSubList(tokens.first, comma.previous);
        TokenList listRight = tokens.extractSubList(comma.next, tokens.last);
        this.parseValueRange(listLeft, sequence, variables);
        this.parseValueRange(listRight, sequence, variables);
    }

    protected void parseValueRange(TokenList tokens, Sequence sequence, List<Variable> variables) {
        TokenList listRow0;
        TokenList.Token[] t = new TokenList.Token[2];
        TokenList.Token colon = tokens.first;
        while (colon != null && colon.getSymbol() != Symbol.COLON) {
            colon = colon.next;
        }
        if (colon == null) {
            t[0] = t[1] = this.parseBlockNoParentheses(tokens, sequence);
        } else if (colon.previous == null && colon.next == null) {
            t[0] = new TokenList.Token(VariableSpecial.Special.ALL);
        } else if (colon.next == null) {
            listRow0 = tokens.extractSubList(tokens.first, colon.previous);
            t[0] = this.parseBlockNoParentheses(listRow0, sequence);
            t[1] = new TokenList.Token(VariableSpecial.Special.END);
        } else {
            if (colon.previous == null) {
                throw new RuntimeException(":<int> not allowed");
            }
            listRow0 = tokens.extractSubList(tokens.first, colon.previous);
            TokenList listRow1 = tokens.extractSubList(colon.next, tokens.last);
            t[0] = this.parseBlockNoParentheses(listRow0, sequence);
            t[1] = this.parseBlockNoParentheses(listRow1, sequence);
        }
        int i = 0;
        while (i < t.length) {
            if (t[i] != null) {
                if (t[i].getType() != TokenList.Type.VARIABLE) {
                    throw new RuntimeException("Expected variable inside of range");
                }
                variables.add(t[i].getVariable());
            }
            ++i;
        }
    }

    protected TokenList.Token parseBlockNoParentheses(TokenList tokens, Sequence sequence) {
        this.parseBracketCreateMatrix(tokens, sequence);
        this.parseNegOp(tokens, sequence);
        this.parseOperationsL(tokens, sequence);
        this.parseOperationsLR(new Symbol[]{Symbol.POWER, Symbol.ELEMENT_POWER}, tokens, sequence);
        this.parseOperationsLR(new Symbol[]{Symbol.TIMES, Symbol.RDIVIDE, Symbol.LDIVIDE, Symbol.ELEMENT_TIMES, Symbol.ELEMENT_DIVIDE}, tokens, sequence);
        this.parseOperationsLR(new Symbol[]{Symbol.PLUS, Symbol.MINUS}, tokens, sequence);
        if (tokens.size() > 1) {
            throw new RuntimeException("BUG in parser.  There should only be a single token left");
        }
        return tokens.first;
    }

    protected void parseBracketCreateMatrix(TokenList tokens, Sequence sequence) {
        ArrayList<TokenList.Token> left = new ArrayList<TokenList.Token>();
        TokenList.Token t = tokens.getFirst();
        while (t != null) {
            TokenList.Token next = t.next;
            if (t.getSymbol() == Symbol.BRACKET_LEFT) {
                left.add(t);
            } else if (t.getSymbol() == Symbol.BRACKET_RIGHT) {
                if (left.isEmpty()) {
                    throw new RuntimeException("No matching left bracket for right");
                }
                TokenList.Token start = (TokenList.Token)left.remove(left.size() - 1);
                TokenList.Token i = start.next;
                MatrixConstructor constructor = new MatrixConstructor(this.functions.getManagerTemp());
                TokenList.Token opStart = null;
                while (true) {
                    if (i.getType() == TokenList.Type.VARIABLE) {
                        this.innerMatrixConstructorOp(tokens, sequence, constructor, opStart, i.previous);
                        opStart = i;
                    } else if (i.getType() == TokenList.Type.SYMBOL) {
                        boolean finished = false;
                        boolean ignore = true;
                        if (i.getSymbol() == Symbol.SEMICOLON) {
                            ignore = false;
                        } else if (i.getSymbol() == Symbol.BRACKET_RIGHT) {
                            finished = true;
                            ignore = false;
                        }
                        if (!ignore) {
                            this.innerMatrixConstructorOp(tokens, sequence, constructor, opStart, i.previous);
                            constructor.endRow();
                            opStart = null;
                            if (finished) {
                                break;
                            }
                        }
                    } else {
                        throw new RuntimeException("Unexpected token " + i);
                    }
                    i = i.next;
                }
                Operation.Info info = Operation.matrixConstructor(constructor);
                sequence.addOperation(info.op);
                tokens.insert(t, new TokenList.Token(info.output));
                tokens.extractSubList(start, t);
            }
            t = next;
        }
        if (!left.isEmpty()) {
            throw new RuntimeException("Dangling [");
        }
    }

    private void innerMatrixConstructorOp(TokenList tokens, Sequence sequence, MatrixConstructor constructor, TokenList.Token opStart, TokenList.Token opEnd) {
        if (opStart == null) {
            return;
        }
        if (opStart != opEnd) {
            TokenList opList = tokens.extractSubList(opStart, opEnd);
            TokenList.Token var = this.parseBlockNoParentheses(opList, sequence);
            constructor.addToRow(var.getVariable());
        } else {
            constructor.addToRow(opStart.getVariable());
        }
    }

    protected void parseNegOp(TokenList tokens, Sequence sequence) {
        if (tokens.size == 0) {
            return;
        }
        TokenList.Token token = tokens.first;
        while (token != null) {
            TokenList.Token next = token.next;
            if (token.getSymbol() == Symbol.MINUS && (token.previous == null || token.previous.getType() == TokenList.Type.SYMBOL) && token.next != null && token.next.getType() != TokenList.Type.SYMBOL) {
                if (token.next.getType() != TokenList.Type.VARIABLE) {
                    throw new RuntimeException("Crap bug rethink this function");
                }
                Operation.Info info = Operation.neg(token.next.getVariable(), this.functions.getManagerTemp());
                sequence.addOperation(info.op);
                TokenList.Token t = new TokenList.Token(info.output);
                tokens.insert(token.next, t);
                tokens.remove(token.next);
                tokens.remove(token);
                next = t;
            }
            token = next;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void parseOperationsL(TokenList tokens, Sequence sequence) {
        if (tokens.size == 0) {
            return;
        }
        token = tokens.first;
        if (token.getType() == TokenList.Type.VARIABLE) ** GOTO lbl14
        throw new RuntimeException("The first token in an equation needs to be a variable and not " + token);
lbl-1000:
        // 1 sources

        {
            if (token.getType() == TokenList.Type.FUNCTION) {
                throw new RuntimeException("Function encountered with no parentheses");
            }
            if (token.getType() == TokenList.Type.SYMBOL && token.getSymbol() == Symbol.TRANSPOSE) {
                if (token.previous.getType() == TokenList.Type.VARIABLE) {
                    token = this.insertTranspose(token.previous, tokens, sequence);
                } else {
                    throw new RuntimeException("Expected variable before tranpose");
                }
            }
            token = token.next;
lbl14:
            // 2 sources

            ** while (token != null)
        }
lbl15:
        // 1 sources

    }

    protected void parseOperationsLR(Symbol[] ops, TokenList tokens, Sequence sequence) {
        if (tokens.size == 0) {
            return;
        }
        TokenList.Token token = tokens.first;
        if (token.getType() != TokenList.Type.VARIABLE) {
            throw new RuntimeException("The first token in an equation needs to be a variable and not " + token);
        }
        boolean hasLeft = false;
        while (token != null) {
            if (token.getType() == TokenList.Type.FUNCTION) {
                throw new RuntimeException("Function encountered with no parentheses");
            }
            if (token.getType() == TokenList.Type.VARIABLE) {
                if (hasLeft) {
                    if (token.previous.getType() == TokenList.Type.VARIABLE) {
                        throw new RuntimeException("Two variables next to each other");
                    }
                    if (Equation.isTargetOp(token.previous, ops)) {
                        token = this.createOp(token.previous.previous, token.previous, token, tokens, sequence);
                    }
                } else {
                    hasLeft = true;
                }
            } else if (token.previous.getType() == TokenList.Type.SYMBOL) {
                throw new RuntimeException("Two symbols next to each other. " + token.previous + " and " + token);
            }
            token = token.next;
        }
    }

    protected TokenList.Token insertTranspose(TokenList.Token variable, TokenList tokens, Sequence sequence) {
        Operation.Info info = this.functions.create('\'', variable.getVariable());
        sequence.addOperation(info.op);
        TokenList.Token t = new TokenList.Token(info.output);
        tokens.remove(variable.next);
        tokens.replace(variable, t);
        return t;
    }

    protected TokenList.Token createOp(TokenList.Token left, TokenList.Token op, TokenList.Token right, TokenList tokens, Sequence sequence) {
        Operation.Info info = this.functions.create(op.symbol, left.getVariable(), right.getVariable());
        sequence.addOperation(info.op);
        TokenList.Token t = new TokenList.Token(info.output);
        tokens.remove(left);
        tokens.remove(right);
        tokens.replace(op, t);
        return t;
    }

    protected TokenList.Token createFunction(TokenList.Token name, List<TokenList.Token> inputs, TokenList tokens, Sequence sequence) {
        Operation.Info info;
        if (inputs.size() == 1) {
            info = this.functions.create(name.getFunction().getName(), inputs.get(0).getVariable());
        } else {
            ArrayList<Variable> vars = new ArrayList<Variable>();
            int i = 0;
            while (i < inputs.size()) {
                vars.add(inputs.get(i).getVariable());
                ++i;
            }
            info = this.functions.create(name.getFunction().getName(), vars);
        }
        sequence.addOperation(info.op);
        TokenList.Token t = new TokenList.Token(info.output);
        tokens.replace(name, t);
        return t;
    }

    public <T extends Variable> T lookupVariable(String token) {
        Variable result = this.variables.get(token);
        return (T)result;
    }

    public DenseMatrix64F lookupMatrix(String token) {
        return ((VariableMatrix)this.variables.get((Object)token)).matrix;
    }

    public int lookupInteger(String token) {
        return ((VariableInteger)this.variables.get((Object)token)).value;
    }

    public double lookupDouble(String token) {
        Variable v = this.variables.get(token);
        if (v instanceof VariableMatrix) {
            DenseMatrix64F m = ((VariableMatrix)v).matrix;
            if (m.numCols == 1 && m.numRows == 1) {
                return m.get(0, 0);
            }
            throw new RuntimeException("Can only return 1x1 real matrices as doubles");
        }
        return ((VariableScalar)this.variables.get(token)).getDouble();
    }

    protected TokenList extractTokens(String equation, ManagerTempVariables managerTemp) {
        TokenList tokens = new TokenList();
        int length = 0;
        TokenType type = TokenType.UNKNOWN;
        int i = 0;
        while (i < equation.length()) {
            block44: {
                boolean again;
                block32: {
                    char c;
                    block43: {
                        block42: {
                            block38: {
                                block41: {
                                    block40: {
                                        block39: {
                                            block33: {
                                                block37: {
                                                    block36: {
                                                        block35: {
                                                            block34: {
                                                                block31: {
                                                                    again = false;
                                                                    c = equation.charAt(i);
                                                                    if (type != TokenType.WORD) break block31;
                                                                    if (Equation.isLetter(c)) {
                                                                        this.storage[length++] = c;
                                                                    } else {
                                                                        String name = new String(this.storage, 0, length);
                                                                        Object v = this.lookupVariable(name);
                                                                        if (v == null) {
                                                                            if (this.functions.isFunctionName(name)) {
                                                                                tokens.add(new Function(name));
                                                                            } else {
                                                                                tokens.add(name);
                                                                            }
                                                                        } else {
                                                                            tokens.add((Variable)v);
                                                                        }
                                                                        type = TokenType.UNKNOWN;
                                                                        again = true;
                                                                    }
                                                                    break block32;
                                                                }
                                                                if (type != TokenType.INTEGER) break block33;
                                                                if (c != '.') break block34;
                                                                type = TokenType.FLOAT;
                                                                this.storage[length++] = c;
                                                                break block32;
                                                            }
                                                            if (c != 'e' && c != 'E') break block35;
                                                            type = TokenType.FLOAT_EXP;
                                                            this.storage[length++] = c;
                                                            break block32;
                                                        }
                                                        if (!Character.isDigit(c)) break block36;
                                                        this.storage[length++] = c;
                                                        break block32;
                                                    }
                                                    if (!Equation.isSymbol(c) && !Character.isWhitespace(c)) break block37;
                                                    int value = Integer.parseInt(new String(this.storage, 0, length));
                                                    tokens.add(managerTemp.createInteger(value));
                                                    type = TokenType.UNKNOWN;
                                                    again = true;
                                                    break block32;
                                                }
                                                throw new RuntimeException("Unexpected character at the end of an integer " + c);
                                            }
                                            if (type != TokenType.FLOAT) break block38;
                                            if (c == '.') {
                                                throw new RuntimeException("Unexpected '.' in a float");
                                            }
                                            if (c != 'e' && c != 'E') break block39;
                                            this.storage[length++] = c;
                                            type = TokenType.FLOAT_EXP;
                                            break block32;
                                        }
                                        if (!Character.isDigit(c)) break block40;
                                        this.storage[length++] = c;
                                        break block32;
                                    }
                                    if (!Equation.isSymbol(c) && !Character.isWhitespace(c)) break block41;
                                    double value = Double.parseDouble(new String(this.storage, 0, length));
                                    tokens.add(managerTemp.createDouble(value));
                                    type = TokenType.UNKNOWN;
                                    again = true;
                                    break block32;
                                }
                                throw new RuntimeException("Unexpected character at the end of an float " + c);
                            }
                            if (type != TokenType.FLOAT_EXP) break block42;
                            boolean end = false;
                            if (c == '-') {
                                char p = this.storage[length - 1];
                                if (p == 'e' || p == 'E') {
                                    this.storage[length++] = c;
                                } else {
                                    end = true;
                                }
                            } else if (Character.isDigit(c)) {
                                this.storage[length++] = c;
                            } else if (Equation.isSymbol(c) || Character.isWhitespace(c)) {
                                end = true;
                            } else {
                                throw new RuntimeException("Unexpected character at the end of an float " + c);
                            }
                            if (end) {
                                double value = Double.parseDouble(new String(this.storage, 0, length));
                                tokens.add(managerTemp.createDouble(value));
                                type = TokenType.UNKNOWN;
                                again = true;
                            }
                            break block32;
                        }
                        if (!Equation.isSymbol(c)) break block43;
                        boolean special = false;
                        if (c == '-' && i + 1 < equation.length() && Character.isDigit(equation.charAt(i + 1)) && (tokens.last == null || Equation.isOperatorLR(tokens.last.getSymbol()))) {
                            type = TokenType.INTEGER;
                            this.storage[0] = c;
                            length = 1;
                            special = true;
                        }
                        if (!special) {
                            TokenList.Token t = tokens.add(Symbol.lookup(c));
                            if (t.previous != null && t.previous.getType() == TokenList.Type.SYMBOL && t.previous.getSymbol() == Symbol.PERIOD) {
                                tokens.remove(t.previous);
                                tokens.remove(t);
                                tokens.add(Symbol.lookupElementWise(c));
                            }
                        }
                        break block32;
                    }
                    if (Character.isWhitespace(c)) break block44;
                    type = Character.isDigit(c) ? TokenType.INTEGER : TokenType.WORD;
                    this.storage[0] = c;
                    length = 1;
                }
                if (again) {
                    --i;
                }
            }
            ++i;
        }
        if (type == TokenType.WORD) {
            String word = new String(this.storage, 0, length);
            Object v = this.lookupVariable(word);
            if (v == null) {
                throw new RuntimeException("Unknown variable " + word);
            }
            tokens.add((Variable)v);
        } else if (type == TokenType.INTEGER) {
            tokens.add(managerTemp.createInteger(Integer.parseInt(new String(this.storage, 0, length))));
        } else if (type == TokenType.FLOAT || type == TokenType.FLOAT_EXP) {
            tokens.add(managerTemp.createDouble(Double.parseDouble(new String(this.storage, 0, length))));
        }
        return tokens;
    }

    protected static boolean isTargetOp(TokenList.Token token, Symbol[] ops) {
        Symbol c = token.symbol;
        int i = 0;
        while (i < ops.length) {
            if (c == ops[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected static boolean isSymbol(char c) {
        return c == '*' || c == '/' || c == '+' || c == '-' || c == '(' || c == ')' || c == '[' || c == ']' || c == '=' || c == '\'' || c == '.' || c == ',' || c == ':' || c == ';' || c == '\\' || c == '^';
    }

    protected static boolean isOperatorLR(Symbol s) {
        if (s == null) {
            return false;
        }
        switch (s) {
            case PLUS: 
            case MINUS: 
            case TIMES: 
            case LDIVIDE: 
            case RDIVIDE: 
            case POWER: 
            case ELEMENT_TIMES: 
            case ELEMENT_DIVIDE: 
            case ELEMENT_POWER: 
            case ASSIGN: {
                return true;
            }
        }
        return false;
    }

    protected static boolean isLetter(char c) {
        return !Equation.isSymbol(c) && !Character.isWhitespace(c);
    }

    protected boolean isReserved(String name) {
        if (this.functions.isFunctionName(name)) {
            return true;
        }
        int i = 0;
        while (i < name.length()) {
            if (!Equation.isLetter(name.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void process(String equation) {
        this.compile(equation).perform();
    }

    public void process(String equation, boolean debug) {
        this.compile(equation, debug).perform();
    }

    public ManagerFunctions getFunctions() {
        return this.functions;
    }

    protected static enum TokenType {
        WORD,
        INTEGER,
        FLOAT,
        FLOAT_EXP,
        UNKNOWN;

    }
}

