/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.integrator.core.peaks;

import java.util.List;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.peaks.IPeakIntegrator;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.peaks.IPeakIntegratorSupport;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.peaks.PeakIntegratorSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.peaks.PeakIntegratorSupport;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.core.settings.peaks.IPeakIntegrationSettings;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.processing.IPeakIntegratorProcessingInfo;
import org.eclipse.chemclipse.chromatogram.xxd.integrator.processing.PeakIntegratorProcessingInfo;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.MessageType;
import org.eclipse.chemclipse.processing.core.ProcessingMessage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;

public class PeakIntegrator {
    private static final Logger logger = Logger.getLogger(PeakIntegrator.class);
    private static final String EXTENSION_POINT = "org.eclipse.chemclipse.chromatogram.xxd.integrator.peakIntegratorSupplier";
    private static final String ID = "id";
    private static final String DESCRIPTION = "description";
    private static final String INTEGRATOR_NAME = "integratorName";
    private static final String INTEGRATOR = "integrator";
    private static final String NO_INTEGRATOR_AVAILABLE = "There is no peak integrator available.";

    private PeakIntegrator() {
    }

    public static IPeakIntegratorProcessingInfo integrate(IPeak peak, IPeakIntegrationSettings peakIntegrationSettings, String integratorId, IProgressMonitor monitor) {
        IPeakIntegrator integrator = PeakIntegrator.getPeakIntegrator(integratorId);
        IPeakIntegratorProcessingInfo processingInfo = integrator != null ? integrator.integrate(peak, peakIntegrationSettings, monitor) : PeakIntegrator.getNoIntegratorAvailableProcessingInfo();
        return processingInfo;
    }

    public static IPeakIntegratorProcessingInfo integrate(List<? extends IPeak> peaks, IPeakIntegrationSettings peakIntegrationSettings, String integratorId, IProgressMonitor monitor) {
        IPeakIntegrator integrator = PeakIntegrator.getPeakIntegrator(integratorId);
        IPeakIntegratorProcessingInfo processingInfo = integrator != null ? integrator.integrate(peaks, peakIntegrationSettings, monitor) : PeakIntegrator.getNoIntegratorAvailableProcessingInfo();
        return processingInfo;
    }

    public static IPeakIntegratorProcessingInfo integrate(List<? extends IPeak> peaks, String integratorId, IProgressMonitor monitor) {
        IPeakIntegrator integrator = PeakIntegrator.getPeakIntegrator(integratorId);
        IPeakIntegratorProcessingInfo processingInfo = integrator != null ? integrator.integrate(peaks, monitor) : PeakIntegrator.getNoIntegratorAvailableProcessingInfo();
        return processingInfo;
    }

    public static IPeakIntegratorProcessingInfo integrate(IChromatogramSelection chromatogramSelection, IPeakIntegrationSettings peakIntegrationSettings, String integratorId, IProgressMonitor monitor) {
        IPeakIntegrator integrator = PeakIntegrator.getPeakIntegrator(integratorId);
        IPeakIntegratorProcessingInfo processingInfo = integrator != null ? integrator.integrate(chromatogramSelection, peakIntegrationSettings, monitor) : PeakIntegrator.getNoIntegratorAvailableProcessingInfo();
        return processingInfo;
    }

    public static IPeakIntegratorProcessingInfo integrate(IChromatogramSelection chromatogramSelection, String integratorId, IProgressMonitor monitor) {
        IPeakIntegrator integrator = PeakIntegrator.getPeakIntegrator(integratorId);
        IPeakIntegratorProcessingInfo processingInfo = integrator != null ? integrator.integrate(chromatogramSelection, monitor) : PeakIntegrator.getNoIntegratorAvailableProcessingInfo();
        return processingInfo;
    }

    public static IPeakIntegratorSupport getPeakIntegratorSupport() {
        IConfigurationElement[] extensions;
        PeakIntegratorSupport integratorSupport = new PeakIntegratorSupport();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensions = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            PeakIntegratorSupplier supplier = new PeakIntegratorSupplier();
            supplier.setId(element.getAttribute(ID));
            supplier.setDescription(element.getAttribute(DESCRIPTION));
            supplier.setIntegratorName(element.getAttribute(INTEGRATOR_NAME));
            integratorSupport.add(supplier);
            ++n2;
        }
        return integratorSupport;
    }

    private static IPeakIntegrator getPeakIntegrator(String integratorId) {
        IConfigurationElement element = PeakIntegrator.getConfigurationElement(integratorId);
        IPeakIntegrator instance = null;
        if (element != null) {
            try {
                instance = (IPeakIntegrator)element.createExecutableExtension(INTEGRATOR);
            }
            catch (CoreException e) {
                logger.warn((Object)e);
            }
        }
        return instance;
    }

    private static IConfigurationElement getConfigurationElement(String integratorId) {
        IConfigurationElement[] elements;
        if ("".equals(integratorId)) {
            return null;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor(EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getAttribute(ID).equals(integratorId)) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    private static IPeakIntegratorProcessingInfo getNoIntegratorAvailableProcessingInfo() {
        PeakIntegratorProcessingInfo processingInfo = new PeakIntegratorProcessingInfo();
        ProcessingMessage processingMessage = new ProcessingMessage(MessageType.ERROR, "Peak Integrator", NO_INTEGRATOR_AVAILABLE);
        processingInfo.addMessage((IProcessingMessage)processingMessage);
        return processingInfo;
    }
}

