/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.swt.ui.components;

import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.notifier.IChromatogramSelectionMSDUpdateNotifier;
import org.eclipse.chemclipse.msd.swt.ui.components.MassSpectrumAxisTitles;
import org.eclipse.chemclipse.swt.ui.components.AbstractLineSeriesUI;
import org.eclipse.chemclipse.swt.ui.series.IMultipleSeries;
import org.eclipse.chemclipse.swt.ui.support.ChartUtil;
import org.eclipse.chemclipse.swt.ui.support.IAxisTitles;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Composite;
import org.swtchart.Range;

public abstract class AbstractProfileMassSpectrumUI
extends AbstractLineSeriesUI
implements IChromatogramSelectionMSDUpdateNotifier {
    private IChromatogramSelectionMSD chromatogramSelection;

    public AbstractProfileMassSpectrumUI(Composite parent, int style) {
        super(parent, style, (IAxisTitles)new MassSpectrumAxisTitles());
    }

    public void update(IChromatogramSelectionMSD chromatogramSelection, boolean forceReload) {
        this.chromatogramSelection = chromatogramSelection;
        if (!this.isMaster() || this.isMaster() && forceReload) {
            double maxSignal = this.chromatogramSelection.getSelectedScan().getTotalSignal();
            this.setMaxSignal(maxSignal);
            this.setSeries(forceReload);
        }
    }

    public IChromatogramSelectionMSD getChromatogramSelection() {
        return this.chromatogramSelection;
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
    }

    private void setSecondaryRanges() {
        assert (this.chromatogramSelection != null) : "The chromatogramSelection instance must be not null.";
        IMultipleSeries multipleLineSeries = this.getMultipleSeries();
        double min = multipleLineSeries.getXMin();
        double max = multipleLineSeries.getXMax();
        Range range = new Range(min, max);
        this.getXAxisTop().setRange(range);
        min = ChartUtil.getRelativeAbundance((double)this.getMaxSignal(), (double)multipleLineSeries.getYMin());
        max = ChartUtil.getRelativeAbundance((double)this.getMaxSignal(), (double)multipleLineSeries.getYMax());
        range = new Range(min, max);
        this.getYAxisRight().setRange(range);
    }

    private void setSeries(boolean forceReload) {
        assert (this.chromatogramSelection != null) : "The chromatogramSelection instance must be not null.";
        this.deleteAllCurrentSeries();
        this.setViewSeries();
        this.getAxisSet().adjustRange();
        this.setSecondaryRanges();
        this.redraw();
    }
}

