/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.csd.converter.supplier.xy.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.eclipse.chemclipse.converter.exceptions.FileIsEmptyException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotReadableException;
import org.eclipse.chemclipse.csd.converter.io.AbstractChromatogramCSDReader;
import org.eclipse.chemclipse.csd.converter.supplier.xy.model.VendorChromatogram;
import org.eclipse.chemclipse.csd.converter.supplier.xy.model.VendorScan;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.model.core.IChromatogramOverview;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramReader
extends AbstractChromatogramCSDReader {
    public IChromatogramCSD read(File file, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        return this.readChromatogram(file, monitor);
    }

    public IChromatogramOverview readOverview(File file, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        return this.readChromatogram(file, monitor);
    }

    private IChromatogramCSD readChromatogram(File file, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        String line;
        VendorChromatogram chromatogram = new VendorChromatogram();
        chromatogram.setFile(file);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        while ((line = bufferedReader.readLine()) != null) {
            String[] values = line.split("\t");
            if (values.length != 2) continue;
            double retentionTimeInMinutes = Double.parseDouble(values[0]);
            int retentionTime = (int)(retentionTimeInMinutes * 60000.0);
            float totalSignal = Float.parseFloat(values[1]);
            VendorScan scan = new VendorScan(retentionTime, totalSignal);
            chromatogram.addScan((IScan)scan);
        }
        bufferedReader.close();
        int scanInterval = chromatogram.getStopRetentionTime() / chromatogram.getNumberOfScans();
        int scanDelay = chromatogram.getStartRetentionTime() - scanInterval;
        scanDelay = scanDelay < 0 ? 0 : scanDelay;
        chromatogram.setScanInterval(scanInterval);
        chromatogram.setScanDelay(scanDelay);
        return chromatogram;
    }
}

