/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.nls.search;

import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.internal.ui.refactoring.nls.search.CompilationUnitEntry;
import org.eclipse.jdt.internal.ui.refactoring.nls.search.FileEntry;
import org.eclipse.jdt.internal.ui.refactoring.nls.search.NLSSearchMessages;
import org.eclipse.jdt.internal.ui.search.TextSearchLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.swt.graphics.Image;

class NLSSearchResultLabelProvider2
extends TextSearchLabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private AppearanceAwareLabelProvider fLabelProvider = new AppearanceAwareLabelProvider(JavaElementLabels.ALL_POST_QUALIFIED, 0);

    public NLSSearchResultLabelProvider2(AbstractTextSearchViewPage page) {
        super(page);
    }

    public StyledString getStyledText(Object element) {
        return this.getColoredLabelWithCounts(element, this.internalGetText(element));
    }

    public String getText(Object element) {
        return this.getLabelWithCounts(element, this.internalGetText(element).getString());
    }

    private StyledString internalGetText(Object element) {
        StyledString elementLabel;
        String description;
        if (element instanceof FileEntry) {
            FileEntry fileEntry = (FileEntry)element;
            description = fileEntry.getMessage();
            elementLabel = this.getPropertiesName(fileEntry.getPropertiesFile());
        } else if (element instanceof CompilationUnitEntry) {
            CompilationUnitEntry cuEntry = (CompilationUnitEntry)element;
            description = cuEntry.getMessage();
            elementLabel = JavaElementLabels.getStyledTextLabel(cuEntry.getCompilationUnit(), JavaElementLabels.ALL_POST_QUALIFIED | 0x80000000000000L);
        } else {
            description = NLSSearchMessages.NLSSearchResultLabelProvider2_undefinedKeys;
            elementLabel = JavaElementLabels.getStyledTextLabel(element, JavaElementLabels.ALL_POST_QUALIFIED | 0x80000000000000L);
        }
        return new StyledString(description).append(' ').append(elementLabel);
    }

    private StyledString getPropertiesName(IFile propertiesFile) {
        String path = BasicElementLabels.getPathLabel(propertiesFile.getFullPath().removeLastSegments(1), false);
        String propertiesName = BasicElementLabels.getResourceName(propertiesFile.getName());
        return new StyledString(propertiesName).append(String.valueOf(JavaElementLabels.CONCAT_STRING) + path, StyledString.QUALIFIER_STYLER);
    }

    public Image getImage(Object element) {
        if (element instanceof FileEntry) {
            element = ((FileEntry)element).getPropertiesFile();
        }
        if (element instanceof CompilationUnitEntry) {
            element = ((CompilationUnitEntry)element).getCompilationUnit();
        }
        return this.fLabelProvider.getImage(element);
    }

    public void dispose() {
        this.fLabelProvider.dispose();
        this.fLabelProvider = null;
        super.dispose();
    }
}

